/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.sequencer;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.codegen.*;
import de.uni_paderborn.fujaba.uml.UMLTransition;
import de.uni_paderborn.fujaba.uml.UMLTransitionGuard;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.32.2.1 $
 */
public class Rep extends Flow
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (Rep.class);

   /**
    * The body of the repetition
    */
   private Seq bodySeq;

   /**
    * The transition which leaves the repetition top/buttom controlled
    */
   private UMLTransition leavingUMLTransition;

   /**
    * The transition which runs the repetition
    */
   private UMLTransition nextUMLTransition;

   /**
    * The type of transition
    */
   private boolean type;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static boolean HEAD_CONTROLLED = true;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static boolean FOOT_CONTROLLED = false;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean headedByActivity = false;


   /**
    * @return   Returns the headedByActivity.
    */
   public boolean isHeadedByActivity()
   {
      return headedByActivity;
   }


   /**
    * @param headedByActivity  The headedByActivity to set.
    */
   public void setHeadedByActivity (boolean headedByActivity)
   {
      this.headedByActivity = headedByActivity;
   }


   /**
    * Constructor for class Rep
    */
   public Rep() { }


   /**
    * @param bodySeq               The body of the repetition
    * @param nextUMLTransition     The transition which runs the repetition
    * @param leavingUMLTransition  The transition which runs the repetition
    * @param type                  The type of transition
    */
   public Rep (Seq bodySeq, UMLTransition nextUMLTransition, UMLTransition leavingUMLTransition, boolean type)
   {
      this.bodySeq = bodySeq;
      this.nextUMLTransition = nextUMLTransition;
      this.leavingUMLTransition = leavingUMLTransition;
      this.type = type;
   } // Rep


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param flowActivity  No description provided
    */
   public void removeLastFlowActivity (FlowActivity flowActivity)
   {
      if (bodySeq != null)
      {
         bodySeq.removeLastFlowActivity (flowActivity);
      }
   } // removeLastFlowActivity


   /**
    * Get the condition attribute of the Rep object
    *
    * @param client  No description provided
    * @return        The condition value
    */
   private OOExpression getCondition (OOGenStrategyClient client)
   {
      OOExpression result;
      switch (UMLTransitionGuard.getGuardType (nextUMLTransition))
      {
         case UMLTransitionGuard.FAILURE:
            result = client.methodFlowCondition (false);
            break;
         case UMLTransitionGuard.ELSE:
            result = new OOPrefixExpr (OOPrefixOp.NOT_OP,
               new OOStringExpr (leavingUMLTransition.getGuard().getBoolExpr()));
            break;
         case UMLTransitionGuard.BOOL:
            result = new OOStringExpr (nextUMLTransition.getGuard().getBoolExpr());
            break;
         default: // UMLTransitionGuard.SUCCESS:
            result = client.methodFlowCondition (true);
            break;
      } // switch

      return result;
   }


   /**
    * Get the bodySeq attribute of the Rep object
    *
    * @return   The bodySeq value
    */
   public Seq getBodySeq()
   {
      return bodySeq;
   }


   /**
    * Get the type attribute of the Rep object
    *
    * @return   The type value
    */
   public boolean getType()
   {
      return type;
   }


   /**
    * Get the leavingUMLTransition attribute of the Rep object
    *
    * @return   The leavingUMLTransition value
    */
   public UMLTransition getLeavingUMLTransition()
   {
      return leavingUMLTransition;
   }


   /**
    * Get the nextUMLTransition attribute of the Rep object
    *
    * @return   The nextUMLTransition value
    */
   public UMLTransition getNextUMLTransition()
   {
      return nextUMLTransition;
   }



//     public UMLToken generateJava (UMLToken firstToken, UMLToken lastToken)
//     {
//        SourceCodeFactory factory = UMLProject.getSourceCodeFactory ();
//        String section;

//        section = firstToken.newSection ("MethodBody_ActivityDiagram_FlowControl", lastToken);
//        firstToken = firstToken.getNextOrAppend (section, lastToken);

//        String comment = null;
//        if (nextUMLTransition.getComment () != null)
//        {
//           comment = nextUMLTransition.getComment ().getText ();
//        }

//        if (type == HEAD_CONTROLLED)
//        {
//           // HEAD_CONTROLLED
//           firstToken.setText (factory.methodFlowWhileHead (comment, getCondition (factory)));
//           firstToken = bodySeq.generateJava (firstToken, lastToken);
//           factory.decIndent ();
//           section = firstToken.newSection ("MethodBody_ActivityDiagram_FlowControl", lastToken);
//           firstToken = firstToken.getNextOrAppend (section, lastToken);
//           firstToken.setText (factory.closeBlockBracket (null));
//        }
//        else
//        {
//           // FOOT_CONTROLLED
//           firstToken.setText (factory.methodFlowDo (comment));
//           firstToken = bodySeq.generateJava (firstToken, lastToken);
//           factory.decIndent ();
//           section = firstToken.newSection ("MethodBody_ActivityDiagram_FlowControl", lastToken);
//           firstToken = firstToken.getNextOrAppend (section, lastToken);
//           firstToken.setText (factory.methodFlowWhileFoot (getCondition (factory)));

//        }	// if

//        return firstToken;
//     }	// generateJava

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param firstToken  No description provided
    * @param lastToken   No description provided
    * @return            No description provided
    */
   public OOGenToken generateSourceCode (OOGenToken firstToken, OOGenToken lastToken)
   {

      if (log.isDebugEnabled())
      {
         log.debug (this + ".generateSourceCode(" + firstToken + "," + lastToken + ")");
      }

      //      SourceCodeFactory factory = UMLProject.getSourceCodeFactory ();
      String section;

      // attention ! fix me !
      OOGenStrategyClient client = (OOGenStrategyClient) CodeGenFactory.get().getCurrentStrategy();

      section = firstToken.newSection ("MethodBody_ActivityDiagram_FlowControl", lastToken);
      firstToken = firstToken.getNextOrAppend (section, lastToken);

      String comment = null;
      if (nextUMLTransition.getComment() != null)
      {
         comment = nextUMLTransition.getComment().getText();
      }

      OOExpression condition = getCondition (client);
      if (type == HEAD_CONTROLLED)
      {
         // HEAD_CONTROLLED
         if (this.isHeadedByActivity())
         {
            firstToken.appendStatement (client.methodFlowWhileHead (comment, OOIdentifierExpr.TRUE_IDENTIFIER));
            firstToken = bodySeq.generateSourceCode (firstToken, lastToken, condition);

         }
         else
         {
            firstToken.appendStatement (client.methodFlowWhileHead (comment, condition));
            firstToken = bodySeq.generateSourceCode (firstToken, lastToken);
         }
         //         factory.decIndent ();
         section = firstToken.newSection ("MethodBody_ActivityDiagram_FlowControl", lastToken);
         firstToken = firstToken.getNextOrAppend (section, lastToken);
         firstToken.appendStatement (OO.endBlock());
      }
      else
      {
         // FOOT_CONTROLLED
         //         firstToken.appendStatement (factory.methodFlowDo (comment));
         firstToken.appendStatement (client.methodFlowDo (comment));
         firstToken = bodySeq.generateSourceCode (firstToken, lastToken);
         //         factory.decIndent ();
         section = firstToken.newSection ("MethodBody_ActivityDiagram_FlowControl", lastToken);
         firstToken = firstToken.getNextOrAppend (section, lastToken);
         //         firstToken.appendStatement (factory.methodFlowWhileFoot (getCondition (factory)));
         firstToken.appendStatement (client.methodFlowWhileFoot (condition));

      } // if

      return firstToken;
   } // generateJava


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      StringBuffer result = new StringBuffer();

      result.append ("Rep[]");

      return result.toString();
   }

}

/*
 * $Log: Rep.java,v $
 * Revision 1.32.2.1  2006/06/07 09:13:30  creckord
 * - UMLTransitionGuard can be null instead of UMLTransitionGuard.NONE
 * - old "repair assoc" code removed (access methods are not kept, so repairing them is no longer needed)
 * - loop bends for assocs are removed when loop is removed
 *
 */
