/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.sequencer;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.basic.FujabaDebug;
import de.uni_paderborn.fujaba.codegen.*;
import de.uni_paderborn.fujaba.uml.UMLTransition;
import de.uni_paderborn.fujaba.uml.UMLTransitionGuard;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.31.2.2 $
 */
public class Sel extends Flow
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (Sel.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FlowActivity flowActivity;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLTransition thenUMLTransition;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Seq thenSeq;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLTransition elseUMLTransition;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Seq elseSeq;


   /**
    * Constructor for class Sel
    */
   public Sel() { }


   /**
    * @param flowActivity       first flowActivity in the selection
    * @param thenSeq            Then part of the selection; may be any Seq
    * @param thenUMLTransition  Then transition guard of the selection
    * @param elseSeq            Else part of the selection; may be any Seq or null
    * @param elseUMLTransition  Else transition guard of the selection
    */
   public Sel (FlowActivity flowActivity, Seq thenSeq, UMLTransition thenUMLTransition, Seq elseSeq, UMLTransition elseUMLTransition)
   {
      this.flowActivity = flowActivity;
      this.thenSeq = thenSeq;
      this.thenUMLTransition = thenUMLTransition;
      this.elseSeq = elseSeq;
      this.elseUMLTransition = elseUMLTransition;
   } // Sel


   /**
    * Get the condition attribute of the Sel object
    *
    * @param client  No description provided
    * @return        The condition value
    */
   private OOExpression getCondition (OOGenStrategyClient client)
   {
      OOExpression condition = null;

      switch (UMLTransitionGuard.getGuardType (thenUMLTransition))
      {
         case UMLTransitionGuard.FAILURE:
            condition = client.methodFlowCondition (false);
            break;
         case UMLTransitionGuard.ELSE:
            condition = new OOPrefixExpr (OOPrefixOp.NOT_OP,
               new OOStringExpr (elseUMLTransition.getGuard().getBoolExpr()));
            break;
         case UMLTransitionGuard.BOOL:
            condition = new OOStringExpr (thenUMLTransition.getGuard().getBoolExpr());
            break;
         default: // UMLTransitionGuard.SUCCESS:
            condition = client.methodFlowCondition (true);
            break;
      } // switch

      return condition;
   } // getCondition


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param firstToken  No description provided
    * @param lastToken   No description provided
    * @return            No description provided
    */
   public OOGenToken generateSourceCode (OOGenToken firstToken, OOGenToken lastToken)
   {
      if (log.isDebugEnabled())
      {
         log.debug (this + ".generateSourceCode(" + firstToken + "," + lastToken + ")");
      }

      // attention ! fix me !
      OOGenStrategyClient strategy = (OOGenStrategyClient) CodeGenFactory.get().getCurrentStrategy();

      String section;

      firstToken = flowActivity.generateSourceCode (firstToken, lastToken);

      section = firstToken.newSection ("MethodBody_ActivityDiagram_FlowControl", lastToken);
      firstToken = firstToken.getNextOrAppend (section, lastToken);

      String comment = null;
      if (thenUMLTransition.getComment() != null)
      {
         comment = thenUMLTransition.getComment().getText();
      }
      firstToken.appendStatement (strategy.methodFlowIfThen (comment, getCondition (strategy)));
      firstToken = thenSeq.generateSourceCode (firstToken, lastToken);
      //      factory.decIndent ();
      section = firstToken.newSection ("MethodBody_ActivityDiagram_FlowControl", lastToken);
      firstToken = firstToken.getNextOrAppend (section, lastToken);
      firstToken.appendStatement (OO.endBlock());

      if ( (elseSeq != null) && !elseSeq.isEmpty())
      {
         firstToken.appendStatement (strategy.methodFlowElse());
         firstToken = elseSeq.generateSourceCode (firstToken, lastToken);
         //         factory.decIndent ();
         section = firstToken.newSection ("MethodBody_ActivityDiagram_FlowControl", lastToken);
         firstToken = firstToken.getNextOrAppend (section, lastToken);
         firstToken.appendStatement (OO.endBlock());
      }
      return firstToken;
   } // generateJava


   /**
    * Get the thenSeq attribute of the Sel object
    *
    * @return   The thenSeq value
    */
   public Seq getThenSeq()
   {
      return thenSeq;
   }


   /**
    * Get the thenUMLTransitionGuard attribute of the Sel object
    *
    * @return   The thenUMLTransitionGuard value
    */
   public UMLTransition getThenUMLTransition()
   {
      return thenUMLTransition;
   }


   /**
    * Get the elseUMLTransitionGuard attribute of the Sel object
    *
    * @return   The elseUMLTransitionGuard value
    */
   public UMLTransition getElseUMLTransition()
   {
      return elseUMLTransition;
   }


   /**
    * Get the elseSeq attribute of the Sel object
    *
    * @return   The elseSeq value
    */
   public Seq getElseSeq()
   {
      return elseSeq;
   }


   /**
    * Get the flowActivity attribute of the Sel object
    *
    * @return   The flowActivity value
    */
   public FlowActivity getFlowActivity()
   {
      return flowActivity;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param flowActivity  No description provided
    */
   public void removeLastFlowActivity (FlowActivity flowActivity)
   {
      if (log.isInfoEnabled())
      {
         log.info ("Error: removeLastFlowActivity called on SEL");
      }
      FujabaDebug.printStackTrace (10);
      if (elseSeq != null)
      {
         elseSeq.removeLastFlowActivity (flowActivity);
      }
      if (thenSeq != null)
      {
         thenSeq.removeLastFlowActivity (flowActivity);
      }
   } // removeLastFlowActivity

}

/*
 * $Log: Sel.java,v $
 * Revision 1.31.2.2  2006/06/07 09:13:30  creckord
 * - UMLTransitionGuard can be null instead of UMLTransitionGuard.NONE
 * - old "repair assoc" code removed (access methods are not kept, so repairing them is no longer needed)
 * - loop bends for assocs are removed when loop is removed
 *
 */
