/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.texteditor;

import javax.swing.text.BadLocationException;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.mpEdit.*;


/**
 * @author    $Author: cschneid $
 * @version   $Revision: 1.4 $ $Date: 2005/02/14 14:28:14 $
 */
public class TextEditorMP extends TextEditor
{

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.4 $ $Date: 2005/02/14 14:28:14 $
    */
   private static class BufferMP implements TextEditor.Buffer
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      mpEDIT edit;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      TagLine tagLine;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      DocInterface doc;


      /**
       * Sets the syntaxHighlightingEnabled attribute of the BufferMP object
       *
       * @param enabled  The new syntaxHighlightingEnabled value
       */
      public void setSyntaxHighlightingEnabled (boolean enabled)
      {
         edit.setHighlightingEnabled (enabled);
      }


      /**
       * Constructor for class BufferMP
       *
       * @param owner  No description provided
       */
      private BufferMP (BufferOwner owner)
      {
         edit = new mpEDIT (FrameMain.get());
         doc = edit.newDoc (new OwnerMP (owner));
         tagLine = doc.tagLine (0);
      }


      /**
       * Access method for an one to n association.
       *
       * @param line  The object added.
       */
      public void addLine (String line)
      {
         doc.addLine (tagLine, line);
      }


      /**
       * Sets the filename attribute of the BufferMP object
       *
       * @param filename  The new filename value
       */
      public void setFilename (String filename)
      {
         doc.setFilename (filename);
      }


      /**
       * Sets the dirty attribute of the BufferMP object
       *
       * @param dirty  The new dirty value
       */
      public void setDirty (boolean dirty)
      {
         doc.setDirty (dirty);
      }


      /**
       * @return   the content of this buffer
       */
      public String getText()
      {
         try
         {
            return doc.getDocument().getText (0, doc.getDocument().getLength());
         }
         catch (BadLocationException e)
         {
            e.printStackTrace();
            return "";
         }
      }


      /**
       * show a line in the editor (e.g. to highlight error). Unsupported by MPEdit.
       *
       * @param lineNr  which line to be shown
       */
      public void showLine (int lineNr)
      {
         //not available
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @author    $Author: cschneid $
       * @version   $Revision: 1.4 $ $Date: 2005/02/14 14:28:14 $
       */
      private class OwnerMP implements DocOwnerInterface
      {
         /**
          * No comment provided by developer, please add a comment to improve documentation.
          */
         BufferOwner owner;


         /**
          * Constructor for class OwnerMP
          *
          * @param owner  No description provided
          */
         public OwnerMP (TextEditor.BufferOwner owner)
         {
            this.owner = owner;
         }


         /**
          * Called when the user has writes out a document using "save as".
          *
          * @param doc       The document which has been written.
          * @param filename  The new document name (full path).
          */
         public void savedAsDoc (DocInterface doc, String filename)
         {

         }


         /**
          * Called when the user has writes out a document using "save".
          *
          * @param doc  The document which has been written.
          */
         public void savedDoc (DocInterface doc)
         {
            owner.bufferSaved (BufferMP.this);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param owner  No description provided
    * @return       No description provided
    */
   public TextEditor.Buffer createBuffer (BufferOwner owner)
   {
      return new BufferMP (owner);
   }
}

/*
 * $Log: TextEditorMP.java,v $
 * Revision 1.4  2005/02/14 14:28:14  cschneid
 * introduced message view, getParentElement() for FElement, code generation and compiler messages in message view
 *
 */
