/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import java.lang.reflect.Method;
import org.apache.log4j.Logger;

import de.upb.tools.sdm.Path;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.21 $
 */
public class From extends Path
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (From.class);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param enum1  No description provided
    * @param enum2  No description provided
    * @return       No description provided
    */
   public static From two (Path enum1, Path enum2)
   {
      From result = new From();
      result.myEnum = Path.union (enum1, enum2);
      return result;
   }

   // several constructors
   /**
    * Constructor for class From
    */
   public From()
   {
      super();
   }


   /**
    * Constructor for class From
    *
    * @param expr  No description provided
    */
   public From (String expr)
   {
      super (expr);
   }


   /**
    * Constructor for class From
    *
    * @param start  No description provided
    * @param expr   No description provided
    */
   public From (Object start, String expr)
   {
      super (start, expr);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public static void selfTest()
   {
      // test all methods beginning with to
      Method[] myMethods = From.class.getMethods();
      Method method = null;
      From dummy = new From();

      for (int i = 0; i < myMethods.length; i++)
      {
         method = myMethods[i];
         if (method.getName().startsWith ("to"))
         {
            try
            {
               if (log.isDebugEnabled())
               {
                  log.debug ("Testing path " + method.getName());
               }
               method.invoke (dummy, null);
            }
            catch (Exception e)
            {
            }
         }
      }
   }
}

/*
 * $Log: From.java,v $
 * Revision 1.21  2004/10/20 17:50:10  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
