/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;



/**
 * UMLClass: 'UMLAction'.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.9 $
 */
public class UMLAction extends UMLDiagramItem
{
   /**
    * Constructor for class UMLAction
    *
    * @param action  No description provided
    */
   public UMLAction (String action)
   {
      setAction (action);
   }


   /**
    * Constructor for class UMLAction
    *
    * @param action  No description provided
    */
   public UMLAction (UMLMethod action)
   {
      setUMLMethod (action);
   }


   /**
    * Constructor for class UMLAction
    *
    * @param action  No description provided
    */
   public UMLAction (UMLStoryPattern action)
   {
      setUMLStoryPattern (action);
   }


   /**
    * Get the actionAsString attribute of the UMLAction object
    *
    * @return   The actionAsString value
    */
   public String getActionAsString()
   {
      if (hasString())
      {
         return action;
      }
      else if (hasUMLMethod())
      {
         return  (getUMLMethod().getName() + "()");
      }
      else
      { //hasUMLStotyPattern

         //return getUMLStoryPattern(). ...
         return "";
      }
   }


   /**
    * UMLAttr: 'action : String'.
    */
   private String action = null;


   /**
    * UMLMethod: '+ hasUMLStoryPattern (): Boolean'. When this method returns true, hasUMLMethod()
    * and hasString() should return false.
    *
    * @return   No description provided
    */
   public boolean hasUMLStoryPattern()
   {
      return  (getUMLStoryPattern() != null);
   }


   /**
    * UMLMethod: '+ hasUMLMethod (): Boolean'. When this method returns true, hasUMLStoryPattern()
    * and hasString() should return false.
    *
    * @return   No description provided
    */
   public boolean hasUMLMethod()
   {
      return  (getUMLMethod() != null);
   }


   /**
    * UMLMethod: '+ hasString (): Boolean'. When this method returns true, hasUMLMethod() and
    * hasStoryPattern() should return false.
    *
    * @return   No description provided
    */
   public boolean hasString()
   {
      return  (getAction() != null);
   }


   /**
    * UMLMethod: '+ getAction (): String'.
    *
    * @return   The action value
    */
   public String getAction()
   {
      return this.action;
   }


   /**
    * UMLMethod: '+ setAction (newAction: String): Void'. Sets the new Action and removes the
    * UMLMethod and the UMLStoryPattern Object.
    *
    * @param newAction  The new action value
    */
   public void setAction (String newAction)
   {
      if ( (this.action == null) ||  (this.action != null && !this.action.equals (newAction)))
      {
         String oldValue = this.action;
         this.action = newAction;
         setUMLMethod (null);
         setUMLStoryPattern (null);
         firePropertyChange ("action", oldValue, newAction);
      } // if

   }


   /**
    * <pre>
    *            0..1     method     0..1
    * UMLMethod -------------------------- UMLAction
    *            uMLMethod      uMLAction
    * </pre>
    */
   private UMLMethod uMLMethod;


   /**
    * UMLMethod: '+ setUMLMethod (value: UMLMethod): Boolean'. Sets the new Action, removes
    * the UMLStoryPattern Object and sets the 'action' Attribut to null.
    *
    * @param value  The new uMLMethod value
    * @return       No description provided
    */
   public boolean setUMLMethod (UMLMethod value)
   {
      boolean changed = false;
      if (this.uMLMethod != value)
      {
         if (this.uMLMethod != null)
         {
            UMLMethod oldValue = this.uMLMethod;
            this.uMLMethod = null;
            oldValue.setUMLAction (null);

            setUMLStoryPattern (null);
            setAction (null);
         }
         this.uMLMethod = value;
         if (value != null)
         {
            value.setUMLAction (this);
         }
         changed = true;
      }
      return changed;
   }


   /**
    * UMLMethod: '+ getUMLMethod (): UMLMethod'.
    *
    * @return   The uMLMethod value
    */
   public UMLMethod getUMLMethod()
   {
      return this.uMLMethod;
   }


   /**
    * <pre>
    *                  0..1     storyPattern     0..1
    * UMLStoryPattern -------------------------------- UMLAction
    *                  uMLStoryPattern      uMLAction
    * </pre>
    */
   private UMLStoryPattern uMLStoryPattern;


   /**
    * UMLMethod: '+ setUMLStoryPattern (value: UMLStoryPattern): Boolean'. Sets the new Action,
    * removes the UMLSMethod Object and sets the 'action' Attribut to null.
    *
    * @param value  The new uMLStoryPattern value
    * @return       No description provided
    */
   public boolean setUMLStoryPattern (UMLStoryPattern value)
   {
      boolean changed = false;
      if (this.uMLStoryPattern != value)
      {
         if (this.uMLStoryPattern != null)
         {
            UMLStoryPattern oldValue = this.uMLStoryPattern;
            this.uMLStoryPattern = null;
            oldValue.setUMLAction (null);

            setUMLMethod (null);
            setAction (null);
         }
         this.uMLStoryPattern = value;
         if (value != null)
         {
            value.setUMLAction (this);
         }
         changed = true;
      }
      return changed;
   }


   /**
    * UMLMethod: '+ getUMLStoryPattern (): UMLStoryPattern'.
    *
    * @return   The uMLStoryPattern value
    */
   public UMLStoryPattern getUMLStoryPattern()
   {
      return this.uMLStoryPattern;
   }


   /**
    * UMLMethod: '+ removeYou (): Void'.
    */
   public void removeYou()
   {
      UMLStoryPattern tmpUMLStoryPattern = getUMLStoryPattern();
      if (tmpUMLStoryPattern != null)
      {
         setUMLStoryPattern (null);
      } // if

      UMLMethod tmpUMLMethod = getUMLMethod();
      if (tmpUMLMethod != null)
      {
         setUMLMethod (null);
      } // if

   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public String toString()
   {
      if (getAction() != null)
      {
         return getAction();
      }
      else if (getUMLMethod() != null)
      {
         return getUMLMethod().toString();
      }
      else
      {
         return getUMLStoryPattern().toString();
      }
   }
}

/*
 * $Log: UMLAction.java,v $
 * Revision 1.9  2004/11/03 11:47:54  lowende
 * Javadoc warnings removed.
 *
 */
