/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import java.util.Iterator;
import de.uni_paderborn.fujaba.basic.RuntimeExceptionWithContext;

import de.uni_paderborn.fujaba.metamodel.*;
import de.uni_paderborn.fujaba.uml.unparse.UMLUnparseGetter;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FPropTreeSet;


/**
 * <h2>Associations</h2>
 *
 * <pre>
 *             +------+ 1                 1
 * UMLTypeList | name +--------------------- UMLType
 *             +------+ revTypes      types
 * </pre>
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.41.2.3 $
 */
public class UMLArray extends UMLIncrement implements UMLType, FArray
{
   /**
    * Constructor for class UMLArray
    */
   public UMLArray()
   {
      super();
   }


   /**
    * Constructor for class UMLArray
    *
    * @param arrayType  No description provided
    */
   public UMLArray (UMLType arrayType)
   {
      this.setArrayType (arrayType);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected String createUnparseModuleName()
   {
      return UMLUnparseGetter.getUnparseModuleName (this);
   }


   /**
    * Get the progLangType attribute of the UMLArray object
    *
    * @return   The progLangType value
    */
   public String getProgLangType()
   {
      StringBuffer buf;
      buf = new StringBuffer (this.getArrayType().getProgLangType());
      buf.append ("[]");
      return new String (buf);
   }


   /**
    * Sets the progLangType attribute of the UMLArray object
    *
    * @param progLangType  The new progLangType value
    */
   public void setProgLangType (String progLangType)
   {
      //this.setName (progLangType);
   }


   /**
    * Get the text attribute of the UMLArray object
    *
    * @return   The text value
    */
   public String getText()
   {
      return getName();
   }


   /**
    * Get name of the base type of the UMLArray object.
    *
    * <pre>
    * If the base type of this UMLArray object is a UMLClass,
    * the full class name will be returned.
    * </pre>
    *
    * @return   The name of the base type, or an empty String if this
    * UMLArray object has no base type.
    */
   public String getBaseTypeName()
   {
      UMLType baseType = this.getBaseType();

      if (baseType instanceof UMLClass)
      {
         return  ((UMLClass) baseType).getFullClassName();
      }
      else if (baseType != null)
      {
         return baseType.getName();
      }
      else
      {
         return "null";
      }
   }


   /**
    * Get the full qualified name of this array.
    *
    * @return   A String holding the full qualified name of this array.
    */
   public String getFullArrayName()
   {
      StringBuffer buf;
      UMLType arrayType = this.getArrayType();
      if (arrayType == null)
      {
         // TODO: what to return, if arrayType isn't set?
         // should we throw an exception?
         buf = new StringBuffer ("null");
      }
      else
      {
         if (arrayType instanceof UMLClass)
         {
            buf = new StringBuffer ( ((UMLClass) arrayType).getFullClassName());
         }
         else if (arrayType instanceof UMLArray)
         {
            buf = new StringBuffer ( ((UMLArray) arrayType).getFullArrayName());
         }
         else
         {
            buf = new StringBuffer (arrayType.getName());
         }
      }

      buf.append ("[]");
      return new String (buf);
   }


   /**
    * Get the name attribute of the UMLArray object
    *
    * @return   The name value
    */
   public String getName()
   {
      StringBuffer buf;
      UMLType arrayType = this.getArrayType();
      if (arrayType == null)
      {
         // TODO: what to return, if arrayType isn't set?
         // should we throw an exception?
         buf = new StringBuffer ("null");
      }
      else
      {
         buf = new StringBuffer (arrayType.getName());
      }

      buf.append ("[]");
      return new String (buf);
   }


   /**
    * Sets the name attribute of the UMLArray object
    *
    * @param name  The new name value
    */
   public void setName (String name) { }

   // ######################################################################

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private transient FPropTreeSet revResultType;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInRevResultType (FMethod value)
   {
      return  ( (this.revResultType != null) &&
          (value != null) &&
         this.revResultType.contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfRevResultType()
   {
      return  ( (this.revResultType == null)
         ? FEmptyIterator.get()
         : this.revResultType.iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfRevResultType()
   {
      return  ( (this.revResultType == null)
         ? 0
         : this.revResultType.size());
   }


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToRevResultType (FMethod value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.revResultType == null)
         {
            this.revResultType = new FPropTreeSet (this, "revResultType");
         }
         changed = this.revResultType.add (value);
         if (changed)
         {
            value.setResultType (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromRevResultType (FMethod value)
   {
      boolean changed = false;
      if ( (this.revResultType != null) &&  (value != null))
      {
         changed = this.revResultType.remove (value);
         if (changed)
         {
            value.setResultType (null);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromRevResultType()
   {
      UMLMethod tmpValue;
      Iterator iter = this.iteratorOfRevResultType();
      while (iter.hasNext())
      {
         tmpValue = (UMLMethod) iter.next();
         this.removeFromRevResultType (tmpValue);
      }
   }

   // ######################################################################

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private transient FPropTreeSet revParamType;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInRevParamType (FParam value)
   {
      return  ( (this.revParamType != null) &&
          (value != null) &&
         this.revParamType.contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfRevParamType()
   {
      return  ( (this.revParamType == null)
         ? FEmptyIterator.get()
         : this.revParamType.iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfRevParamType()
   {
      return  ( (this.revParamType == null)
         ? 0
         : this.revParamType.size());
   }


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToRevParamType (FParam value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.revParamType == null)
         {
            this.revParamType = new FPropTreeSet (this, "revParamType");
         }
         changed = this.revParamType.add (value);
         if (changed)
         {
            value.setParamType (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromRevParamType (FParam value)
   {
      boolean changed = false;
      if ( (this.revParamType != null) &&  (value != null))
      {
         changed = this.revParamType.remove (value);
         if (changed)
         {
            value.setParamType (null);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromRevParamType()
   {
      UMLParam tmpValue;
      Iterator iter = this.iteratorOfRevParamType();
      while (iter.hasNext())
      {
         tmpValue = (UMLParam) iter.next();
         this.removeFromRevParamType (tmpValue);
      }
   }

   // ######################################################################

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private transient FPropTreeSet revAttrType;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInRevAttrType (FAttr value)
   {
      return  ( (this.revAttrType != null) &&
          (value != null) &&
         this.revAttrType.contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfRevAttrType()
   {
      return  ( (this.revAttrType == null)
         ? FEmptyIterator.get()
         : this.revAttrType.iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfRevAttrType()
   {
      return  ( (this.revAttrType == null)
         ? 0
         : this.revAttrType.size());
   }


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToRevAttrType (FAttr value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.revAttrType == null)
         {
            this.revAttrType = new FPropTreeSet (this, "revAttrType");
         }
         changed = this.revAttrType.add (value);
         if (changed)
         {
            value.setAttrType (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromRevAttrType (FAttr value)
   {
      boolean changed = false;
      if ( (this.revAttrType != null) &&  (value != null))
      {
         changed = this.revAttrType.remove (value);
         if (changed)
         {
            value.setAttrType ((UMLType) null);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromRevAttrType()
   {
      UMLAttr tmpValue;
      Iterator iter = this.iteratorOfRevAttrType();
      while (iter.hasNext())
      {
         tmpValue = (UMLAttr) iter.next();
         this.removeFromRevAttrType (tmpValue);
      }
   }

   // ######################################################################

   /**
    * <pre>
    *             +------+ 1                 1
    * UMLTypeList | name +--------------------- UMLType
    *             +------+ revTypes      types
    * </pre>
    */
   private transient UMLTypeList revTypes;


   /**
    * Sets the revTypes attribute of the UMLArray object
    *
    * @param obj  The new revTypes value
    * @return     No description provided
    */
   public boolean setRevTypes (FTypeList obj)
   {
      boolean changed = false;

      if (this.revTypes != obj)
      {
         UMLTypeList oldValue = null;
         if (this.revTypes != null)
         {
            oldValue = this.revTypes;
            this.revTypes = null;
            oldValue.removeFromTypes (this);
         }
         this.revTypes = (UMLTypeList) obj;
         if (obj != null)
         {
            obj.addToTypes (this);
         }
         changed = true;

         // side effects
         firePropertyChange ("revTypes", oldValue, obj);
      }

      return changed;
   }


   /**
    * Get the revTypes attribute of the UMLArray object
    *
    * @return   The revTypes value
    */
   public UMLTypeList getRevTypes()
   {
      return this.revTypes;
   }

   // ######################################################################

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLArray revArrayType;

   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the revArrayType attribute of the UMLArray object
    *
    * @return   The revArrayType value
    */
   public UMLArray getRevArrayType()
   {
      return this.revArrayType;
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FType#getFRevArrayType()
    */
   /**
    * Get the fRevArrayType attribute of the UMLArray object
    *
    * @return   The fRevArrayType value
    */
   public FArray getFRevArrayType()
   {
      return getRevArrayType();
   }
   // TODO-END

   /**
    * Sets the revArrayType attribute of the UMLArray object
    *
    * @param revArrayType  The new revArrayType value
    */
   public void setRevArrayType (FArray revArrayType)
   {
      if (this.revArrayType != revArrayType)
      {
         UMLArray oldRevArrayType = this.revArrayType;
         // new partner
         if (this.revArrayType != null)
         {
            // inform old partner
            this.revArrayType = null;
            oldRevArrayType.setArrayType (this);
         }
         this.revArrayType = (UMLArray) revArrayType;
         if (revArrayType != null)
         {
            // inform new partner
            revArrayType.setArrayType (this);
         }
         firePropertyChange ("revArrayType", oldRevArrayType, revArrayType);
      }
   }

   // ######################################################################

   /**
    * 0..1 has 0..1 UMLArray ------------------------------------- UMLType + revArrayType +
    * arrayType
    */

   // @@@FIX ME: this should be removed, if we could save
   // interfaces, JHM
   //private UMLType arrayType;      // reverse attribute array
   private UMLIncrement arrayType; // reverse attribute array
   //      ^^^^^^^^^^^^ needed, because the current save methods
   //                   couldn't save interfaces, JHM

   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the arrayType attribute of the UMLArray object
    *
    * @return   The arrayType value
    */
   public UMLType getArrayType()
   {
      return (UMLType) this.arrayType;
   } // getArrayType


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FArray#getFArrayType()
    */
   /**
    * Get the fArrayType attribute of the UMLArray object
    *
    * @return   The fArrayType value
    */
   public FType getFArrayType()
   {
      return getArrayType();
   }
   // TODO-END

   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the baseType attribute of the UMLArray object
    *
    * @return   The baseType value
    */
   public UMLType getBaseType()
   {
      UMLType baseType = null;
      UMLArray current = this;

      while (current != null)
      {
         baseType = current.getArrayType();
         if (baseType instanceof UMLArray)
         {
            current = (UMLArray) baseType;
         }
         else
         {
            current = null;
         }
      }

      return baseType;
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FArray#getFBaseType()
    */
   /**
    * Get the fBaseType attribute of the UMLArray object
    *
    * @return   The fBaseType value
    */
   public FType getFBaseType()
   {
      return getBaseType();
   }
   // TODO-END

   /**
    * Sets the arrayType attribute of the UMLArray object
    *
    * @param tmpType  The new arrayType value
    */
   public void setArrayType (FType tmpType)
   {
      UMLIncrement type = (UMLIncrement) tmpType;
      if (this.arrayType != type)
      {
         UMLIncrement oldType = this.arrayType;
         // newPartner
         if (this.arrayType != null)
         {
            // inform old partner
            //UMLType oldType = this.arrayType;
            this.arrayType = null;

             ((UMLType) oldType).setRevArrayType (null);
         }

         this.arrayType = type;
         if (this.arrayType != null)
         {
            // inform new partner
             ((UMLType) this.arrayType).setRevArrayType (this);
         }

         firePropertyChange (ARRAY_TYPE_PROPERTY, oldType, type);
      }
   } // setArrayType

   // ######################################################################

   /**
    * Isolates the object so the garbage collector can remove it.
    */
   public void removeYou()
   {
      removeAllFromRevParamType();
      removeAllFromRevResultType();
      removeAllFromRevAttrType();

      this.setRevArrayType (null);
      this.setRevTypes (null);
      this.setArrayType (null);

      super.removeYou();
   }


   /**
    * Query the logical parent of this element (e.g. package of a class, diagram of an object).
    *
    * @return   the logical parent of this element;
    */
   public FElement getParentElement()
   {
      //todo: this is a top level object - should it be somewhere else?
      return UMLProject.get();
   }

   // ######################################################################

   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the realType attribute of the UMLArray object
    *
    * @return   The realType value
    */
   public UMLType getRealType()
   {
      return this.getArrayType().getRealType();
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FType#getFRealType()
    */
   /**
    * Get the fRealType attribute of the UMLArray object
    *
    * @return   The fRealType value
    */
   public FType getFRealType()
   {
      return getRealType();
   }
   // TODO-END

   /**
    * Get the dimension attribute of the UMLArray object
    *
    * @return   The dimension value
    */
   public int getDimension()
   {
      return this.getArrayType().getDimension() + 1;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public String toString()
   {
      // the unparsing seems to need this method...
      return this.getName();
   }


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToRevType (FQualifier value)
   {
      throw new RuntimeExceptionWithContext ("Use an array as Qualifier?! That seems to be rubbish to me!", value);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInRevType (FQualifier value)
   {
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfRevType()
   {
      return FEmptyIterator.get();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromRevType()
   {

   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromRevType (FQualifier value)
   {
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfRevType()
   {
      return 0;
   }

}

/*
 * $Log: UMLArray.java,v $
 * Revision 1.41.2.3  2005/08/23 08:24:44  lowende
 * Removed compile warnings.
 *
 */
