/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import java.util.Iterator;

import de.uni_paderborn.fujaba.metamodel.*;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FPropTreeSet;


/**
 * <h2>Associations</h2> <pre>
 *                0..n     constraints     0..n
 * UMLConstraint ------------------------------- UMLIncrement
 *                constraints    revConstraints
 * </pre>
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.64.2.1 $
 */
public class UMLConstraint extends UMLDiagramItem implements FConstraint
{
   /**
    * Constructor for class UMLConstraint
    */
   public UMLConstraint()
   {
      super();
   }


   /**
    * Constructor for class UMLConstraint
    *
    * @param text  No description provided
    */
   public UMLConstraint (String text)
   {
      super();
      setText (text);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String text;


   /**
    * Get the text attribute of the UMLConstraint object
    *
    * @return   The text value
    */
   public String getText()
   {
      return text;
   }


   /**
    * Sets the text attribute of the UMLConstraint object
    *
    * @param text  The new text value
    */
   public void setText (String text)
   {
      String oldValue = this.text;
      if (text != null)
      {
         this.text = text.trim();
      }
      else
      {
         this.text = null;
      }
      firePropertyChange (TEXT_PROPERTY, oldValue, this.text);
   }


   /**
    * <pre>
    *                0..n     constraints     0..n
    * UMLConstraint ------------------------------- UMLIncrement
    *                constraints        increments
    * </pre>
    */
   private FPropTreeSet increments;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInIncrements (FIncrement value)
   {
      return  ( (this.increments != null) &&
          (value != null) &&
         this.increments.contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfIncrements()
   {
      return  ( (this.increments == null)
         ? FEmptyIterator.get()
         : this.increments.iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfIncrements()
   {
      return  ( (this.increments == null)
         ? 0
         : this.increments.size());
   }


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToIncrements (FIncrement value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.increments == null)
         {
            this.increments = new FPropTreeSet (this, INCREMENTS_PROPERTY);
         }
         changed = this.increments.add (value);
         if (changed)
         {
            value.addToConstraints (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromIncrements (FIncrement value)
   {
      boolean changed = false;
      if ( (this.increments != null) &&  (value != null))
      {
         changed = this.increments.remove (value);
         if (changed)
         {
            value.removeFromConstraints (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllIncrements()
   {
      UMLIncrement tmpValue;
      Iterator iter = this.iteratorOfIncrements();
      while (iter.hasNext())
      {
         tmpValue = (UMLIncrement) iter.next();
         this.removeFromIncrements (tmpValue);
      }
   }


   /**
    * <pre>
    *                0..n     constraints     0..n
    * UMLConstraint ------------------------------- UMLDiagram
    *                constraints    revConstraints
    * </pre>
    */
   private FPropTreeSet revConstraint;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInRevConstraint (FDiagram value)
   {
      return  ( (this.revConstraint != null) &&
          (value != null) &&
         this.revConstraint.contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfRevConstraint()
   {
      return  ( (this.revConstraint == null)
         ? FEmptyIterator.get()
         : this.revConstraint.iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfRevConstraint()
   {
      return  ( (this.revConstraint == null)
         ? 0
         : this.revConstraint.size());
   }


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToRevConstraint (FDiagram value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.revConstraint == null)
         {
            this.revConstraint = new FPropTreeSet (this, REV_CONSTRAINT_PROPERTY);
         }
         changed = this.revConstraint.add (value);
         if (changed)
         {
             ((UMLDiagram) value).addToConstraints (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromRevConstraint (FDiagram value)
   {
      boolean changed = false;
      if ( (this.revConstraint != null) &&  (value != null))
      {
         changed = this.revConstraint.remove (value);
         if (changed)
         {
             ((UMLDiagram) value).removeFromConstraints (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllRevConstraints()
   {
      UMLDiagram tmpValue;
      Iterator iter = this.iteratorOfRevConstraint();
      while (iter.hasNext())
      {
         tmpValue = (UMLDiagram) iter.next();
         this.removeFromRevConstraint (tmpValue);
      }
   }


   /**
    * Added by Erik Weihrauch for testing at 2005-07-13
    * Hangs the current ASGElement into the ASG-tree. Needed for cut'n'paste.
    *
    * @param parent
    */
   public void setCutCopyPasteParent (FElement parent)
   {
      if (parent instanceof UMLStoryActivity)
      {
         UMLStoryActivity activity = (UMLStoryActivity) parent;
         this.removeAllFromDiagrams();
         activity.getStoryPattern().addToElements (this);
      }
      else
      {
         super.setCutCopyPasteParent (parent);
      }
   } // end of adding


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public String toString()
   {
      return getText();
   } // toString


   /**
    * Isolates the object so the garbage collector can remove it.
    */
   public void removeYou()
   {
      removeAllIncrements();

      removeAllRevConstraints();

      super.removeYou();
   } // removeYou

}

/*
 * $Log: UMLConstraint.java,v $
 * Revision 1.64.2.1  2005/12/20 13:16:53  cschneid
 * More warning/error info, some copy/paste fixes from erik, message listener for JEM (andreas/manuel), new libs
 *
 */
