/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.metamodel.FElement;


/**
 * @author    $Author: cschneid $
 * @version   $Revision: 1.51 $
 */
public class UMLStatement extends UMLDiagramItem
{

   /**
    * @param coobraPersistent
    */
   public UMLStatement (boolean coobraPersistent)
   {
      super (coobraPersistent);
   }


   /**
    * Constructor for class UMLStatement
    */
   public UMLStatement()
   {
      super();
   }


   /**
    * Constructor for class UMLStatement
    *
    * @param statement  No description provided
    * @param activity   No description provided
    */
   public UMLStatement (String statement, UMLStatementActivity activity)
   {
      super();
      setStatement (statement);
      setActivity (activity);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String statement;


   /**
    * Get the statement attribute of the UMLStatement object
    *
    * @return   The statement value
    */
   public String getStatement()
   {
      return statement;
   }


   /**
    * Sets the statement attribute of the UMLStatement object
    *
    * @param statement  The new statement value
    */
   public void setStatement (String statement)
   {
      // change only, if necessary
      if (! (statement != null && statement.equals (this.statement)))
      {
         //avoid an empty statement, because this looks ugly in diagrams
         if (statement == null || statement.trim().length() == 0)
         {
            statement = "//Statement";
         }

         String oldValue = this.statement;
         this.statement = statement;
         firePropertyChange ("statement", oldValue, statement);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param statement  No description provided
    */
   public void append (String statement)
   {
      if (this.statement == null)
      {
         setStatement (statement);
      }
      else
      {
         setStatement (this.statement + statement);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLStatementActivity activity;


   /**
    * Get the activity attribute of the UMLStatement object
    *
    * @return   The activity value
    */
   public UMLStatementActivity getActivity()
   {
      return activity;
   }


   /**
    * Sets the activity attribute of the UMLStatement object
    *
    * @param activity  The new activity value
    */
   public void setActivity (UMLStatementActivity activity)
   {
      if (this.activity != activity)
      {
         // new partner
         UMLStatementActivity oldActivity = this.activity;
         if (this.activity != null)
         {
            // inform old partner
            this.activity = null;
            oldActivity.setState (null);
         }
         this.activity = activity;
         if (activity != null)
         {
            // inform new partner
            activity.setState (this);
         }
         firePropertyChange ("activity", oldActivity, activity);
      }
   }


   /**
    * Isolates the object so the garbage collector can remove it.
    */
   public void removeYou()
   {
      setActivity (null);

      super.removeYou();
   }


   /**
    * Query the logical parent of this element (e.g. package of a class, diagram of an object).
    *
    * @return   the logical parent of this element;
    */
   public FElement getParentElement()
   {
      return getActivity();
   }

}

/*
 * $Log: UMLStatement.java,v $
 * Revision 1.51  2005/02/14 14:28:21  cschneid
 * introduced message view, getParentElement() for FElement, code generation and compiler messages in message view
 *
 */
