/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import java.util.Iterator;
import java.util.Vector;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.metamodel.FStereotype;
import de.uni_paderborn.fujaba.metamodel.FStereotypeManager;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;


/**
 * <h2>Associations</h2>
 *
 * <pre>
 *                      +-----------+ 0..1        stereotypes         0..1
 * UMLStereotypeManager | getText() |----------------------------------------- UMLStereotype
 *                      +-----------+ uMLStereotypeManager     stereotypes
 * </pre>
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.42 $
 */
public class UMLStereotypeManager implements FStereotypeManager
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String TYPE = "type";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String INTERFACE = "interface";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String REFERENCE = "reference";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String IMPORT = "import";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String IMMUTABLE = "immutable";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String SINGLETON = "singleton";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String SQLPERSISTENT = "SQL persistent";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String OQLPERSISTENT = "OQL persistent";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DATABASE = "database";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String OODATABASE = "OO database";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String SQLDATABASE = "SQL database";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DBVERSANT = "VersantDB";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String FSA_UNPARSE_MODULE = "unparse module (FSA)";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String NAVIGABLE = "navigable";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DTD_PERSISTENT = "persistent (DTD)";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DTD_CHOICE = "choice (DTD)";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DTD_MIXED = "mixed (DTD)";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DTD_SEQUENCE = "sequence (DTD)";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String XML_PERSISTENT = "persistent (XML)";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String XML_CHOICE = "choice (XML)";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String XML_MIXED = "mixed (XML)";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String XML_SEQUENCE = "sequence (XML)";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String CONSISTENCYRULE = "consistency rule";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String SDLBLOCK = "block";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String SDLPROCESS = "process";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String SDLACTOR = "actor";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String CONTRACT = "contract";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String COMPONENT = "component";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String JAVA_BEAN_COMPONENT = "JavaBean";

   /**
    * Used to flag associations that only make user provided iteratorOf methods available as
    * links in story patterns. AZ
    */
   public final static String VIRTUAL_PATH = "Virtual Path";


   /**
    * Constructor for class UMLStereotypeManager
    */
   UMLStereotypeManager() { }


   /**
    * @return   UMLProject.get().getStereotypeManager(), possibly null when in loading phase
    */
   public static UMLStereotypeManager get()
   {
      if (UMLProject.get() != null)
      {
         return UMLProject.get().getStereotypeManager();
      }
      else
      {
         return null;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void initDefaultStereotypes()
   {
      initStereotype (INTERFACE);
      initStereotype (REFERENCE);

      initStereotype (TYPE);
      initStereotype (IMMUTABLE);
      initStereotype (SINGLETON);
      initStereotype (IMPORT);

      initStereotype (SQLPERSISTENT);
      initStereotype (OQLPERSISTENT);
      initStereotype (DATABASE);
      initStereotype (OODATABASE);
      initStereotype (SQLDATABASE);
      initStereotype (DBVERSANT);

      initStereotype (FSA_UNPARSE_MODULE);

      initStereotype (DTD_PERSISTENT);
      initStereotype (DTD_CHOICE);
      initStereotype (DTD_MIXED);
      initStereotype (DTD_SEQUENCE);

      initStereotype (XML_PERSISTENT);
      initStereotype (XML_CHOICE);
      initStereotype (XML_MIXED);
      initStereotype (XML_SEQUENCE);

      initStereotype (CONSISTENCYRULE);
      initStereotype (NAVIGABLE);
      initStereotype (SDLBLOCK);
      initStereotype (SDLPROCESS);
      initStereotype (SDLACTOR);

      initStereotype (JAVA_BEAN_COMPONENT);

      // add none stereotype for UMLAssoc
      initStereotype (VIRTUAL_PATH);
   }


   /**
    * create a stereotype if it does not exist
    *
    * @param type  what stereotype to create
    */
   private void initStereotype (String type)
   {
      if (!hasKeyInStereotypes (type))
      {
         addToStereotypes (new UMLStereotype (type));
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator entriesOfBasicStereotypes()
   {
      Vector vector = new Vector();
      vector.add (getFromStereotypes (INTERFACE));
      vector.add (getFromStereotypes (REFERENCE));
      vector.add (getFromStereotypes (TYPE));
      vector.add (getFromStereotypes (JAVA_BEAN_COMPONENT));

      return vector.iterator();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfBasicStereotypes()
   {
      return entriesOfBasicStereotypes();
   }


   /**
    * <pre>
    *                      +-----------+ 0..1        stereotypes         0..1
    * UMLStereotypeManager | getText() |-------------------------------------- UMLStereotype
    *                      +-----------+ uMLStereotypeManager     stereotypes
    * </pre>
    */
   private FHashMap stereotypes;


   /**
    * Access method for one to n association "stereotypes". CAUTION: should normally never
    * be called. Exception: storage image restore mechanisms.
    *
    * @param value  The object added.
    * @return       true when the stereotype was added
    */
   public boolean addToStereotypes (UMLStereotype value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.stereotypes == null)
         {
            this.stereotypes = new FHashMap();
         }

         if (this.stereotypes.get (value.getText()) == null)
         {
            Object old = this.stereotypes.put (value.getText(), value);

            if (old != value)
            {
               value.setUMLStereotypeManager (this);
            }
            changed = true;
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator entriesOfStereotypes()
   {
      return  ( (this.stereotypes == null)
         ? FEmptyIterator.get()
         : this.stereotypes.entrySet().iterator());
   }

   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the fromStereotypes attribute of the UMLStereotypeManager object
    *
    * @param key  No description provided
    * @return     The fromStereotypes value
    */
   public UMLStereotype getFromStereotypes (String key)
   {
      UMLStereotype result = null;
      if (key != null)
      {
         if (this.stereotypes != null)
         {
            result = (UMLStereotype) this.stereotypes.get (key);
         }
         if (result == null)
         {
            result = new UMLStereotype (key);
            new Exception ("Stereotypes should not be created on the fly here (especially not while loading)" +
               " - ensure that they are created by explicit calls!").printStackTrace();
            addToStereotypes (result);
         }
      }
      return result;
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FStereotypeManager#getFromFStereotypes(java.lang.String)
    */
   /**
    * Get the fromFStereotypes attribute of the UMLStereotypeManager object
    *
    * @param key  No description provided
    * @return     The fromFStereotypes value
    */
   public FStereotype getFromFStereotypes (String key)
   {
      return getFromStereotypes (key);
   }
   // TODO-END

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInStereotypes (FStereotype value)
   {
      return  ( (this.stereotypes != null) &&
          (value != null) &&  (value.getText() != null) &&
         this.stereotypes.containsKey (value.getText()));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public boolean hasKeyInStereotypes (String key)
   {
      return  ( (this.stereotypes != null) &&
          (key != null) &&
         this.stereotypes.containsKey (key));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfStereotypes()
   {
      return  ( (this.stereotypes == null)
         ? FEmptyIterator.get()
         : this.stereotypes.values().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator keysOfStereotypes()
   {
      return  ( (this.stereotypes == null)
         ? FEmptyIterator.get()
         : this.stereotypes.keySet().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromStereotypes()
   {
      UMLStereotype tmpValue;
      Iterator iter = this.iteratorOfStereotypes();
      while (iter.hasNext())
      {
         tmpValue = (UMLStereotype) iter.next();
         this.removeFromStereotypes (tmpValue);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromStereotypes (FStereotype value)
   {
      boolean changed = false;
      if ( (this.stereotypes != null) &&  (value != null) &&  (value.getText() != null))
      {
         Object oldValue = this.stereotypes.remove (value.getText());
         if (oldValue != null)
         {
             ((UMLStereotype) value).setUMLStereotypeManager (null);
            changed = true;
            value.removeYou();
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public boolean removeFromStereotypes (String key)
   {
      boolean changed = false;
      if ( (this.stereotypes != null) &&  (key != null))
      {
         Object value = this.stereotypes.remove (key);
         if (value != null)
         {
            changed = true;
             ((UMLStereotype) value).setUMLStereotypeManager (null);
             ((UMLStereotype) value).removeYou();
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfStereotypes()
   {
      return  ( (this.stereotypes == null)
         ? 0
         : this.stereotypes.size());
   }


   /**
    * Searches the ASG tree for a given id
    *
    * @param id  The id to search for.
    * @return    The Element with the given id, null if not found.
    */
   public ASGElement searchID (String id)
   {
      Iterator iter = iteratorOfStereotypes();
      ASGElement elem = null;
      while ( (elem == null) &&  (iter.hasNext()))
      {
         elem =  ((ASGElement) iter.next()).searchID (id);
      }
      return elem;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeYou()
   {
      removeAllFromStereotypes();
   } // removeYou
}

/*
 * $Log: UMLStereotypeManager.java,v $
 * Revision 1.42  2005/02/07 16:43:12  cschneid
 * param recognized in create object dialog
 *
 */
