/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.actions;

import java.awt.event.ActionEvent;
import java.util.*;

import javax.swing.*;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.uml.*;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.upb.tools.fca.FTreeSet;


/**
 * Delete last selected class.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.25.2.1 $
 */
public class DeleteClassAction extends AbstractAction
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      FrameMain frameMain = FrameMain.get();

      UMLDiagram currentDiagram = (UMLDiagram) UMLProject.get().getCurrentDiagram();
      Iterator iter;
      LinkedList selectedClasses = new LinkedList();
      try
      {
         Object source = e.getSource();

         if (source instanceof UMLClass)
         {
            // Single UMLClass selected
            selectedClasses.add (source);
         }
         else if (source instanceof UMLAttr)
         {
            // Single UMLClass selected
            selectedClasses.add ( ((UMLAttr) source).getParent());
         }
         else if (source instanceof UMLMethod)
         {
            // Single UMLClass selected
            selectedClasses.add ( ((UMLMethod) source).getParent());
         }
         else
         {
            // Several Classes are selected
            iter = SelectionManager.get().iteratorOfSelectionAsIncrements();

            // filter all UMLClasses from selection
            while (iter.hasNext())
            {
               // wrong conversion! might lead to a ClassCastException
               // in some cases, because elements in iterator are
               // of type 'LogicUnparseInterface' not 'UMLIncrement'
               //UMLIncrement incr = (UMLIncrement) iter.next();
               LogicUnparseInterface unparseInterface = (LogicUnparseInterface) iter.next();
               if (unparseInterface instanceof UMLClass)
               {
                  selectedClasses.add (unparseInterface);
               }
            }
         }

         iter = selectedClasses.iterator();

         //Check if the class(es) is used as a return type or attribute type
         LinkedList revClassesList = new LinkedList();
         LinkedList inMoreThanOneDiag = new LinkedList();
         while (iter.hasNext())
         {
            UMLClass umlClass = (UMLClass) iter.next();

            // used as return type?
            Vector revClassesV = new Vector();
            Iterator revIter = umlClass.iteratorOfRevResultType();

            while (revIter.hasNext())
            {
               UMLMethod revMethod = (UMLMethod) revIter.next();

               // Ooops... found a broken method, remove it!
               if (revMethod.getParent() == null)
               {
                  revMethod.removeYou();
               }
               else if (!revClassesV.contains (revMethod.getParent().getName()))
               {
                  revClassesV.add (revMethod.getParent());
               }
            }

            //used as attribute type?
            revIter = umlClass.iteratorOfRevAttrType();
            while (revIter.hasNext())
            {
               UMLAttr revAttr = (UMLAttr) revIter.next();
               if (revAttr.getParent() == null)
               {
                  revAttr.removeYou();
               }
               else if (!revClassesV.contains (revAttr.getParent().getName()))
               {
                  revClassesV.add (revAttr.getParent());
               }
            }

            //used as object type?
            revIter = umlClass.iteratorOfInstances();
            while (revIter.hasNext())
            {
               UMLObject revObj = (UMLObject) revIter.next();
               boolean willBeDeletedToo = false;
               for (Iterator it = revObj.iteratorOfDiagrams(); it.hasNext(); )
               {
                  ASGDiagram asgDiagram = (ASGDiagram) it.next();
                  if (asgDiagram instanceof UMLStoryPattern)
                  {
                     final UMLStoryPattern storyPattern =  ((UMLStoryPattern) asgDiagram);
                     if (storyPattern.getRevStoryPattern() != null)
                     {
                        for (Iterator it2 = storyPattern.getRevStoryPattern().iteratorOfDiagrams(); it2.hasNext(); )
                        {
                           ASGDiagram diagram = (ASGDiagram) it2.next();
                           if (diagram instanceof UMLActivityDiagram)
                           {
                              final UMLActivityDiagram activityDiagram =  ((UMLActivityDiagram) diagram);
                              final UMLMethod method = activityDiagram.getStoryMethod();
                              if (method != null)
                              {
                                 if (selectedClasses.contains (method.getParent()))
                                 {
                                    willBeDeletedToo = true;
                                 }
                              }
                           }
                        }
                     }
                  }
               }
               if (!willBeDeletedToo)
               {
                  revClassesV.add (revObj);
               }
            }

            if (!revClassesV.isEmpty())
            {
               for (int i = 0; i < revClassesV.size(); i++)
               {
                  if (!selectedClasses.contains (revClassesV.elementAt (i)))
                  {
                     revClassesList.add (umlClass);
                     break;
                  }
               }
            }

            // Check if other diagrams contain selected class(es)
            int diagCounter = 0;

            Iterator diags = umlClass.iteratorOfDiagrams();
            while (diags.hasNext())
            {
               UMLDiagram diagram = (UMLDiagram) diags.next();
               if (diagram.hasInElements (umlClass) && ! (diagram instanceof ViewDiagram))
               {
                  diagCounter++;
                  if (diagCounter > 1)
                  {
                     inMoreThanOneDiag.add (source);
                     break;
                  }
               }
            }
         }

         Iterator revClasses = revClassesList.iterator();

         if (revClasses.hasNext())
         {
            // Show Warning
            String revClassesString = "";
            for (int i = 0; i < revClassesList.size(); i++)
            {
               if (i % 5 == 0)
               { //show max 5 classes in one line of the dialog

                  revClassesString = revClassesString + "\n";
               }
               revClassesString = revClassesString + revClassesList.get (i) + ", ";
            }
            revClassesString = revClassesString.substring (0, revClassesString.length() - 2); //delete the last ","

            if (JOptionPane.showConfirmDialog (frameMain.getFrame(), "The classes" + revClassesString + "\nare used as a" +
               " return type, attribute type or object type by some other classes. \n\n" +
               "Delete it anyway? (All referring methods will be set to Void, all attributes to <unknown>)",
               "Delete Class", JOptionPane.YES_NO_OPTION) == JOptionPane.NO_OPTION)
            {
               UMLProject.get().refreshDisplay();
               return; //user chanceled deletion

            }
         }

         int userChoice = 1;
         if (inMoreThanOneDiag.size() > 0)
         {
            // Some classes are in several diagrams
            // Ask the user wether he wants to delete the class or just remove it from current diagram
            String classOutput = "";
            for (int i = 0; i < inMoreThanOneDiag.size(); i++)
            {
               if (i % 5 == 0)
               { //show max 5 classes in one line of the dialog

                  classOutput = classOutput + "\n  ";
               }
               classOutput = classOutput + inMoreThanOneDiag.get (i) + ", ";
            }
            Object[] options =
               {
               "...remove from current Diagram", "... delete classes"
               };
            userChoice = JOptionPane.showOptionDialog (null, "The following class(es) have been found in several Diagrams: " + classOutput + "\n\n Do you want to delete the whole class or remove it from current diagram (this may lead to inconsistence between the Diagrams...)", "Delete class", JOptionPane.DEFAULT_OPTION, JOptionPane.WARNING_MESSAGE, null, options, options[0]);
         }

         iter = selectedClasses.iterator();

         while (iter.hasNext())
         {
            UMLClass umlClass = (UMLClass) iter.next();
            if (userChoice == 1 || ! (inMoreThanOneDiag.contains (source)))
            {
               // User accepted deletion, return type for methods will be set to void, attributes to <unknown>
               Iterator revIter = umlClass.iteratorOfRevResultType();
               if (umlClass.getRevTypes() != null)
               {
                  UMLType voidType = umlClass.getRevTypes().provideType (UMLBaseTypes.VOID);
                  while (revIter.hasNext())
                  {
                     UMLMethod revMethod = (UMLMethod) revIter.next();
                     revMethod.setResultType (voidType);
                  }
               }

               iter = selectedClasses.iterator();
               FTreeSet diagrams = new FTreeSet(); // list of diagrams in which the deleted classes were

               while (iter.hasNext())
               {
                  UMLIncrement incr = (UMLIncrement) iter.next();

                  if (incr instanceof UMLClass)
                  {
                     UMLClass selectedClass = (UMLClass) incr;
                     Iterator diags = selectedClass.iteratorOfDiagrams();
                     while (diags.hasNext())
                     {
                        UMLDiagram diagram = (UMLDiagram) diags.next();
                        if (diagram.hasInElements (selectedClass))
                        {
                           diagrams.add (diagram);
                        }
                     }
                     selectedClass.removeYou();
                  }
               }

               UMLProject.get().refreshDisplay();
            }
            else
            {
               umlClass.removeFromDiagrams (currentDiagram);
            }
         }

         // because some Activity-Diagrams might have been deleted
         // we have to update the tree-view
         FrameMain.get().createNewTreeItems();
      }
      catch (Exception e2)
      {
         e2.printStackTrace();
      }
      finally
      {
      }
   } // executeAction

}

/*
 * $Log: DeleteClassAction.java,v $
 * Revision 1.25.2.1  2005/05/13 14:52:20  cschneid
 * fixed warning dialogs
 *
 */
