/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.actions;

import java.awt.event.ActionEvent;

import javax.swing.*;

import de.uni_paderborn.fujaba.codegen.OOGenToken;
import de.uni_paderborn.fujaba.uml.*;


/**
 * @author    $Author: lowende $
 * @version   $Revision: 1.15 $
 */
public class KillAllTokenAction extends AbstractAction
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void actionPerformed (ActionEvent event)
   {
      UMLClass clazz = null;
      if (event.getSource() instanceof UMLClass)
      {
         clazz = (UMLClass) event.getSource();
      }
      else if (event.getSource() instanceof UMLMethod)
      {
         clazz =  ((UMLMethod) event.getSource()).getParent();
      }
      else if (event.getSource() instanceof UMLAttr)
      {
         clazz =  ((UMLAttr) event.getSource()).getParent();
      }

      // kill all tokens of my corresponding file to get rid of garbage
      // and don't forget to increment the age of each
      // increment which is responsible for the tokens of this
      // class
      UMLFile myFile = clazz.getFile();
      OOGenToken token = myFile.getFirstOOGenToken();
      OOGenToken nextToken = token;
      while (token != null)
      {
         nextToken = token.getNext();
         token.removeYouFromList();
         token.removeYou();
         token = nextToken;
      }
   }
}

/*
 * $Log: KillAllTokenAction.java,v $
 * Revision 1.15  2004/11/03 11:47:57  lowende
 * Javadoc warnings removed.
 *
 */
