/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.actions;

import java.util.Iterator;
import java.util.TreeMap;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.asg.ASGUnparseInformation;
import de.uni_paderborn.fujaba.uml.*;


/**
 * @author    $Author: cschneid $
 * @version   $Revision: 1.20.2.1 $
 */
public class LogicalStoryPatternAction extends CreateSuccessorAbstractAction
{

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public UMLActivity createNewActivity()
   {
      return createNewActivity (null);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param newActivity  No description provided
    * @return             No description provided
    */
   public UMLActivity createNewActivity (UMLStoryActivity newActivity)
   {
      try
      {
         UMLStoryPattern newStoryPattern;

         UMLStoryPattern storyPattern =  ((UMLStoryActivity) activity).getStoryPattern();

         if (newActivity == null)
         {
            // create one
            newStoryPattern = new UMLStoryPattern ("Successor of " + storyPattern.getName(),
               UMLProject.get(), UMLStoryPattern.STORYPATTERN, null);
            newActivity = new UMLStoryActivity ( ((UMLStoryActivity) activity).isForEach(), newStoryPattern);
         }
         else
         {
            // reuse it
            newStoryPattern = newActivity.getStoryPattern();
         }

         TreeMap succObjectMap = new TreeMap();
         Iterator iter;

         iter = storyPattern.iteratorOfObjects();
         while (iter.hasNext())
         {
            UMLObject obj = (UMLObject) iter.next();
            UMLObject succObj = obj.getSuccessorObject();
            if (succObj != null)
            {
               succObjectMap.put (obj, succObj);

               // copy location of obj to succObj
               copyLocations (obj, succObj, storyPattern, newStoryPattern);
               // go Markus go

               newStoryPattern.addToElements (succObj);
            }
         }

         iter = storyPattern.iteratorOfElements();
         while (iter.hasNext())
         {
            ASGElement tmpElement = (ASGElement) iter.next();
            UMLDiagramItem newItem = null;
            if (tmpElement instanceof UMLLink)
            {
               newItem =  ((UMLLink) tmpElement).getSuccessorLink (succObjectMap);
            }
            if (tmpElement instanceof UMLLinkSet)
            {
               newItem =  ((UMLLinkSet) tmpElement).getSuccessorLinkSet (succObjectMap);
            }
            if (newItem != null && tmpElement instanceof UMLDiagramItem)
            {
               copyLocations ((UMLDiagramItem) tmpElement, newItem, storyPattern, newStoryPattern);
               newStoryPattern.addToElements (newItem);
            }
         }

         UMLProject.get().refreshDisplay();

         return newActivity;
      }
      catch (RuntimeException except)
      {
         except.printStackTrace();
      }
      return null;
   }


   /**
    * copy the UnparseInformation from one item to a new one
    *
    * @param item             old item (source)
    * @param newItem          new item (destination)
    * @param storyPattern     pattern of the old item
    * @param newStoryPattern  pattern of the new item
    */
   private void copyLocations (UMLDiagramItem item, UMLDiagramItem newItem, UMLStoryPattern storyPattern, UMLStoryPattern newStoryPattern)
   {
      Iterator locIter = item.iteratorOfKeyFromUnparseInformations();
      while (locIter.hasNext())
      {
         ASGElement key = (ASGElement) locIter.next();
         ASGUnparseInformation info = item.getFromUnparseInformations (key);
         if (key == item)
         {
            newItem.addToUnparseInformations (newItem, new ASGUnparseInformation (info));
         }
         else if (key == storyPattern)
         {
            newItem.addToUnparseInformations (newStoryPattern, new ASGUnparseInformation (info));
         }
         else
         {
            newItem.addToUnparseInformations (key, new ASGUnparseInformation (info));
         }
      }
   }
}

/*
 * $Log: LogicalStoryPatternAction.java,v $
 * Revision 1.20.2.1  2005/12/20 13:16:53  cschneid
 * More warning/error info, some copy/paste fixes from erik, message listener for JEM (andreas/manuel), new libs
 *
 */
