/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;

import javax.swing.*;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.messages.WarningMessages;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.gui.PEActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * Creates a new activity diagram.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.16 $
 */
public class NewActivityDiagramAction extends AbstractAction
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      String name;
      UMLProject project = UMLProject.get();
      ASGDiagram diagram;
      UMLActivityDiagram activityDiagram = new UMLActivityDiagram (null, null);
      boolean done = false;
      boolean found;

      FrameMain frameMain = FrameMain.get();

      try
      {
         PEActivityDiagram activityDiagramEditor = new PEActivityDiagram (frameMain.getFrame());
         while (!done)
         {
            activityDiagramEditor.setIncrement (activityDiagram);
            activityDiagramEditor.showCentered();

            if (activityDiagramEditor.isResult())
            {
               name = activityDiagram.getName();

               Iterator iter = project.iteratorOfDiags();

               found = false;
               if (name != null)
               {
                  if ( (name.trim().equals ("")))
                  {
                     WarningMessages.warnUnnamedDiagram (frameMain, "activity");
                     found = true;
                  }

                  while (!found && iter.hasNext())
                  {
                     diagram = (ASGDiagram) iter.next();
                     if ( (diagram instanceof UMLActivityDiagram) &&
                         (diagram.getName().equals (name)) &&  (diagram != activityDiagram))
                     {
                        WarningMessages.warnDoubleIdentifiedDiagram (frameMain, "activity", name);
                        found = true;
                     }
                  }

                  if (!found)
                  {
                     project.addToDiags (activityDiagram);
                     frameMain.createNewTreeItems();
                     frameMain.selectTreeItem (activityDiagram);
                     done = true;
                  }
                  else
                  {
                     activityDiagram.removeYou();
                  }

               }

            }
            else
            {
               done = true;
            }
         }
      }
      finally
      {
      }
   } // actionPerformed

}

/*
 * $Log: NewActivityDiagramAction.java,v $
 * Revision 1.16  2004/11/03 11:47:58  lowende
 * Javadoc warnings removed.
 *
 */
