/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.actions;

import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;

import javax.swing.*;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.gui.SelectFromListDialog;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * Creates a new Statechart. The user chooses a class from a dialog showing all classes without
 * statecharts.
 *
 * @author    $Author: trinet $
 * @version   $Revision: 1.18 $
 */
public class NewStatechartAction extends AbstractAction
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      FrameMain frameMain = FrameMain.get();

      try
      {
         // Show dialog containing all classes without statecharts.  If
         // the user selects a class, create a statechart for it, else
         // do nothing.
         SelectClassDialog classDialog = new SelectClassDialog (frameMain.getFrame());
         classDialog.setHeading ("Select a class to create a statechart for: ");
         classDialog.show();
         if ((UMLClass) classDialog.getSelectedObject() != null)
         {
            Action action = new CreateStatechartAction();
            action.actionPerformed (new ActionEvent (classDialog.getSelectedObject(),
               ActionEvent.ACTION_PERFORMED,
               "CreateStateChart"));
         }
      }
      finally
      {
      }
   } // actionPerformed


   /**
    * A dialog showing all classes without statecharts.
    *
    * @author    $Author: trinet $
    * @version   $Revision: 1.18 $
    */
   private class SelectClassDialog extends SelectFromListDialog
   {
      /**
       * Constructor for class SelectClassDialog
       *
       * @param frame  No description provided
       */
      public SelectClassDialog (JFrame frame)
      {
         super (frame);
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      protected void unparse()
      {
         // collect all classes without statecharts

         Vector classes = new Vector();
         Enumeration enumeration = UMLProject.get().elementsOfClasses();
         while (enumeration.hasMoreElements())
         {
            UMLClass cls = (UMLClass) enumeration.nextElement();
            if (cls.getStartOfStateChart() == null)
            {
               classes.add (cls);
            }
         }

         setObjects (classes);
      }
   } // SelectClassDialog

}

/*
 * $Log: NewStatechartAction.java,v $
 * Revision 1.18  2004/11/08 19:16:20  trinet
 * changed saving of FSAProperties, added String support for Maps in BasicIncrement, some cleanup
 *
 */
