/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.swing.UMLAttrExprOperationComboBoxModel;
import de.uni_paderborn.fujaba.fsa.unparse.AbstractUnparseModule;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.23 $
 */
public class UMAttrExprPair extends AbstractUnparseModule
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      FSAPanel textPanel = new FSAPanel (incr, getMainFsaName(), parent.getJComponent());
      textPanel.setLayout (new FlowLayout (FlowLayout.LEFT, 2, 0));

      FSATextFieldLabel attr = new FSATextFieldLabel (incr, "name", textPanel.getJComponent());
      attr.addToUpdater (attr.createDefaultUpdater());

      FSAComboBoxLabel operationLabel = new FSAComboBoxLabel (incr,
         "attrOperationAsText",
         textPanel.getJComponent());
      operationLabel.setModel (new UMLAttrExprOperationComboBoxModel());
      operationLabel.setForeground (FSAObject.COLOR_FOREGROUND);
      operationLabel.setBackground (FSAObject.COLOR_BACKGROUND);

      FSATextFieldLabel expression = new FSATextFieldLabel (incr, "expression", textPanel.getJComponent());
      expression.addToUpdater (expression.createDefaultUpdater());
      textPanel.setBold (false);

      // It is necessary for inner graphic listeners that such
      // listeners are added before the updater between the
      // logical increment and the fsa object because otherwise
      // no initial value changed event is fired.
      operationLabel.getJComponent().addPropertyChangeListener ("value", new LabelUpdaterForExpression (expression.getJComponent()));
      operationLabel.getJComponent().addPropertyChangeListener ("value", new LabelUpdaterForExpression (attr.getJComponent()));
      operationLabel.getJComponent().addPropertyChangeListener ("value", new LabelUpdaterForExpression (operationLabel.getJComponent()));
      operationLabel.addToUpdater (operationLabel.createDefaultUpdater());

      return textPanel;
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.23 $
 */
class LabelUpdaterForExpression implements PropertyChangeListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JComponent jComponent = null;


   /**
    * Constructor for class LabelUpdaterForExpression
    *
    * @param jComponent  No description provided
    */
   public LabelUpdaterForExpression (JComponent jComponent)
   {
      this.jComponent = jComponent;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param evt  No description provided
    */
   public void propertyChange (PropertyChangeEvent evt)
   {
      Object value = evt.getNewValue();
      if (value instanceof String)
      {
         String name = (String) value;
         if (name.equals (":="))
         {
            jComponent.setForeground (ColorsPreferences.get().ASSIGNMENT);
         }
         else
         {
            jComponent.setForeground (FSAObject.COLOR_FOREGROUND);
         }
      }
   }
}

/*
 * $Log: UMAttrExprPair.java,v $
 * Revision 1.23  2004/10/20 17:50:23  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
