/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.awt.*;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.listener.*;
import de.uni_paderborn.fujaba.fsa.unparse.AbstractUnparseModule;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.*;
import de.uni_paderborn.fujaba.uml.UMLCollabStat;

// $Id: UMCollabStat.java,v 1.32.2.1 2005/05/30 15:33:44 fklar Exp $

/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: fklar $
 * @version   $Revision: 1.32.2.1 $
 */
public class UMCollabStat extends AbstractUnparseModule
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      UMLCollabStat collabStat = (UMLCollabStat) incr;
      FSAContainer container = (FSAContainer) parent;

      FSAPanel collabPanel = new FSAPanel (incr, getMainFsaName(), parent.getJComponent(), false);
//      collabPanel.setTransientProperties (false);
      collabPanel.setLayout (new FlowLayout (FlowLayout.LEFT, 0, 0));

      collabPanel.setParentOfJComponent (container.getJComponent());

      FSABigArrow arrow = new FSABigArrow (incr, "arrow", collabPanel.getJComponent());
      Translator translator = new LogicFsaTranslator (collabPanel, 1);
      AbstractUpdater updater = new LogicToFsaUpdater();
      updater.setTranslator (translator);
      updater.setLogicAttrName ("callTarget");
      updater.setFsaAttrName ("target");
      updater.setLogicObject (collabStat);
      arrow.addToUpdater (updater);

      updater = new VisibilityUpdater (collabStat, "callTarget");
      arrow.addToUpdater (updater);

      AbstractUpdater updater2 = new LogicToFsaUpdater();
      updater2.setLogicAttrName ("CallOnElementsOfSet");
      updater2.setFsaAttrName ("DoubleArrow");
      updater2.setLogicObject (collabStat);
      arrow.addToUpdater (updater2);

      arrow.setSource (collabPanel);

      FSATextFieldLabel textField = new FSATextFieldLabel (incr, "text", collabPanel.getJComponent());
      textField.addToUpdater (textField.createDefaultUpdater());

      JPanel jPanel = (JPanel) collabPanel.getJComponent();
      AscendDescendMouseHandler.addMouseInputListener (jPanel, SelectionMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, DragMouseListener.get());
      SelectionListenerHelper.addSelectionListener (jPanel,
         BorderHighlighter.get());
      return collabPanel;
   }

}

/*
 * $Log: UMCollabStat.java,v $
 * Revision 1.32.2.1  2005/05/30 15:33:44  fklar
 * adjusted to FSA-changes ... calling constructor, that takes transientProperties as argument to save initial-location
 *
 */
