/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.listener.*;
import de.uni_paderborn.fujaba.fsa.swing.*;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.*;
import de.uni_paderborn.fujaba.uml.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: trinet $
 * @version   $Revision: 1.34 $
 */
public class UMGeneralization extends UMConnection
{

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      UMLGeneralization generalization = (UMLGeneralization) incr;

      FSAPolyLine line = (FSAPolyLine) super.create (parent, incr);
      line.setTransientProperties (false);
      JBendLine bendLine = (JBendLine) line.getJComponent();

      // check if the superclass is an interface
      UMLClass superClass = generalization.getSuperclass();
      if (superClass != null && superClass.hasInStereotypes (UMLStereotypeManager.get().getFromStereotypes (UMLStereotypeManager.INTERFACE)))
      {
         bendLine.setLineDashed (true);
      }
      new UMGeneralizationPropertyChangeListener (generalization, line);

      Container grabParent = bendLine.getParent();
      FSAGrab fsaGrab = new FSAGrab (incr, "superGrab", (JComponent) grabParent);
      Translator translator = new LogicFsaTranslator (line, 1);
      AbstractUpdater updater = new LogicToFsaUpdater();
      updater.setTranslator (translator);
      updater.setLogicAttrName ("superclass");
      updater.setFsaAttrName ("target");
      updater.setLogicObject (generalization);
      fsaGrab.addToUpdater (updater);

      JGrab grab = (JGrab) fsaGrab.getJComponent();
      ArrowGrabUI ui = (ArrowGrabUI) ArrowGrabUI.createUI (grab);
      ui.setArrow ((JArrowHead) UMArrowHead.GENERALIZATION.clone());
      grab.setUI (ui);
      bendLine.setStartBend (grab);

      SelectionListenerHelper.addSelectionListener (grab, ForegroundHighlighter.get());
      AscendDescendMouseHandler.addMouseInputListener (grab, GrabMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (grab, DoubleClickMouseListener.get());

      fsaGrab = new FSAGrab (incr, "subGrab", (JComponent) grabParent);
      updater = new LogicToFsaUpdater();
      updater.setTranslator (translator);
      updater.setLogicAttrName ("subclass");
      updater.setFsaAttrName ("target");
      updater.setLogicObject (generalization);
      fsaGrab.addToUpdater (updater);

      grab = (JGrab) fsaGrab.getJComponent();
      bendLine.setEndBend (grab);

      SelectionListenerHelper.addSelectionListener (grab, ForegroundHighlighter.get());
      AscendDescendMouseHandler.addMouseInputListener (grab, GrabMouseListener.get());
      //AscendDescendMouseHandler.addMouseInputListener (grab, DoubleClickMouseListener.get());

      AscendDescendMouseHandler.removeMouseInputListener (bendLine, DoubleClickMouseListener.get());

      return line;
   }

   // -------------------------------------------- inner classes --------------------------------------------
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: trinet $
    * @version   $Revision: 1.34 $
    */
   private class UMGeneralizationPropertyChangeListener implements PropertyChangeListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private UMLGeneralization gen;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private UMLClass superClass;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private FSAPolyLine genLine;


      /**
       * Constructor for class UMGeneralizationPropertyChangeListener
       *
       * @param gen      No description provided
       * @param genLine  No description provided
       */
      public UMGeneralizationPropertyChangeListener (UMLGeneralization gen, FSAPolyLine genLine)
      {
         this.gen = gen;
         this.superClass = gen.getSuperclass();
         this.genLine = genLine;

         gen.addPropertyChangeListener (this);
         if (superClass != null)
         {
            superClass.addPropertyChangeListener (this);
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param event  No description provided
       */
      public void propertyChange (PropertyChangeEvent event)
      {
         String propertyName = event.getPropertyName();

         if ("stereotypes".equals (propertyName) || "superClass".equals (propertyName))
         {
            JBendLine bendLine = (JBendLine) genLine.getJComponent();
            if (superClass.hasInStereotypes (UMLStereotypeManager.get().getFromStereotypes (UMLStereotypeManager.INTERFACE)))
            {
               bendLine.setLineDashed (true);
            }
            else
            {
               bendLine.setLineDashed (false);
            }
         }
         else if ("removeYou".equals (propertyName))
         {
            superClass.removePropertyChangeListener (this);
            gen.removePropertyChangeListener (this);
         }
      }
   }
}

/*
 * $Log: UMGeneralization.java,v $
 * Revision 1.34  2004/11/20 15:55:08  trinet
 * added flag to avoid unnecessary saving of unparse information
 *
 */
