/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JComponent;
import javax.swing.JLabel;

import de.uni_paderborn.fujaba.basic.FontContainer;
import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.listener.*;
import de.uni_paderborn.fujaba.fsa.swing.*;
import de.uni_paderborn.fujaba.fsa.swing.border.CrossBorder;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.*;
import de.uni_paderborn.fujaba.layout.options.LayoutPreferences;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;
import de.uni_paderborn.fujaba.uml.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: mtt $
 * @version   $Revision: 1.54.2.2 $
 */
public class UMLink extends UMConnection
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      UMLLink link = (UMLLink) incr;
      if (link != null)
      {

         FSABendLine line = (FSAPolyLine) super.create (parent, incr);
         line.setTransientProperties (false);
         JBendLine bendLine = (JBendLine) line.getJComponent();

         JComponent grabParent = (JComponent) bendLine.getParent();

         JGrab grab = createGrab (link, line, grabParent, "source", link.getSource());
         bendLine.setStartBend (grab);

         grab = createGrab (link, line, grabParent, "target", link.getTarget());
         bendLine.setEndBend (grab);

         //	manage text panel to keep direction icon next to the link name
         FSAPanel textPanel = new FSAPanel (incr, "textPanel", bendLine);
         textPanel.setLayout (new FlowLayout (FlowLayout.LEFT, 0, 0));
         JComponent jTextPanel = textPanel.getJComponent();

         //	create arrow showing direction of assoc
         FSADirectionIndicator arrow = new FSADirectionIndicator (link, "arrow", jTextPanel);

         AbstractUpdater updater = new LogicToFsaUpdater();
         Translator translator = new LogicFsaTranslator (line, 1);
         updater.setTranslator (translator);
         updater.setLogicAttrName ("target");
         updater.setFsaAttrName ("target");
         updater.setLogicObject (link);
         arrow.addToUpdater (updater);

         updater = new LogicToFsaUpdater();
         updater.setTranslator (translator);
         updater.setLogicAttrName ("source");
         updater.setFsaAttrName ("source");
         updater.setLogicObject (link);
         arrow.addToUpdater (updater);

         updater = new LogicToFsaUpdater();
         updater.setTranslator (ColorToModifierTranslator.get());
         updater.setLogicObject (incr);
         updater.setLogicAttrName ("modifier");
         updater.setFsaAttrName ("foreground");
         arrow.addToUpdater (updater);

         // add separator between icon and label
         textPanel.addToComponents (new JLabel (" "));

         FSATextFieldLabel text = new FSATextFieldLabel (incr, "modifier", bendLine);
         updater = text.createDefaultUpdater();
         updater.setTranslator (StringToModifierTranslator.get());
         text.addToUpdater (updater);
         text.addToUpdater (new VisibilityUpdater (incr, "modifier"));
         updater = text.createDefaultUpdater();
         updater.setTranslator (ColorToModifierTranslator.get());
         updater.setFsaAttrName ("foreground");
         text.addToUpdater (updater);
         updater = new LogicToFsaUpdater();
         updater.setTranslator (ColorToModifierTranslator.get());
         updater.setLogicObject (incr);
         updater.setLogicAttrName ("modifier");
         updater.setFsaAttrName ("foreground");
         line.addToUpdater (updater);

         text.setOpaque (false);

         JTextFieldLabel field = (JTextFieldLabel) text.getJComponent();
         if (bendLine.getLayout() instanceof LayoutManager2)
         {
             ((LayoutManager2) bendLine.getLayout()).addLayoutComponent (field, new LineDecoratorConstraints (bendLine, 0.3, 8));
         }
         field.setFont (FontContainer.getFont (FontContainer.DEFAULT_FONT, -2));

         // create link name icon
         FSATextFieldLabel nametext = new FSATextFieldLabel (incr, "name", jTextPanel);
         AbstractUpdater nameupdater = nametext.createDefaultUpdater();
         nametext.addToUpdater (nameupdater);
         nametext.addToUpdater (new VisibilityUpdater (incr, "name"));
         nametext.setOpaque (false);

         updater = new LogicToFsaUpdater();
         updater.setTranslator (ColorToModifierTranslator.get());
         updater.setLogicObject (incr);
         updater.setLogicAttrName ("modifier");
         updater.setFsaAttrName ("foreground");
         nametext.addToUpdater (updater);

         // add separator/bracket between name and range
         JLabel openingRangeBracket = new JLabel (" [");
         if (link.getRange() == null || link.getRange().equals (""))
         {
            openingRangeBracket.setVisible (false);
         }
         textPanel.addToComponents (openingRangeBracket);

         // create link range
         FSATextFieldLabel rangetext = new FSATextFieldLabel (incr, "range", jTextPanel);
         AbstractUpdater rangeupdater = rangetext.createDefaultUpdater();
         rangetext.addToUpdater (rangeupdater);
         rangetext.addToUpdater (new VisibilityUpdater (incr, "range"));
         rangetext.setOpaque (false);

         // add bracket after range
         JLabel closingRangeBracket = new JLabel ("]");
         if (link.getRange() == null || link.getRange().equals (""))
         {
            closingRangeBracket.setVisible (false);
         }
         textPanel.addToComponents (closingRangeBracket);

         // updater for range
         UMLinkPropertyChangeListener pclListener = new UMLinkPropertyChangeListener (rangetext, openingRangeBracket, closingRangeBracket, null);
         link.addPropertyChangeListener ("range", pclListener);

         JTextFieldLabel namefield = (JTextFieldLabel) nametext.getJComponent();
         if (bendLine.getLayout() instanceof LayoutManager2)
         {
             ((LayoutManager2) bendLine.getLayout()).addLayoutComponent (jTextPanel,
               new LineDecoratorConstraints (bendLine, 0.5, 8));
         }
         field.setFont (FontContainer.getFont (FontContainer.DEFAULT_FONT, -1));

         if (link.getIsViaASGElementRef())
         {
            FSALabel suffixLabel = new FSALabel (incr, "suffix", jTextPanel);
            suffixLabel.setText (UMLLink.VIA_ASGELEMENTREF_SUFFIX);
            suffixLabel.setOpaque (true);
         }

         // updater for type
         pclListener = new UMLinkPropertyChangeListener (nametext, null, null, null);
         link.addPropertyChangeListener ("type", pclListener);

         switch (link.getType())
         {
            case UMLLink.OPTIONAL:
               line.setForeground (ColorsPreferences.get().OPTIONAL);
               bendLine.setStroke (LineStyle.DASHED);
               arrow.setForeground (ColorsPreferences.get().OPTIONAL);
               nametext.setForeground (ColorsPreferences.get().OPTIONAL);
               break;
            case UMLLink.NEGATIVE:
               namefield.setBorder (new CrossBorder (ColorsPreferences.get().DEFAULT_FOREGROUND));
               break;
            default:
               break;
         }

         switch (link.getModifier())
         {
            case UMLLink.CREATE:
               arrow.setForeground (ColorsPreferences.get().CREATION);
               nametext.setForeground (ColorsPreferences.get().CREATION);
               break;
            case UMLLink.DELETE:
               arrow.setForeground (ColorsPreferences.get().DELETION);
               nametext.setForeground (ColorsPreferences.get().DELETION);
               break;
            default:
               break;
         }

         //todo: an updater for a missing association is needed
         if (link.getInstanceOf() == null)
         {
            //broken link
            namefield.setOpaque (true);
            namefield.setBackground (Color.RED);
         }

         return line;
      }
      else
      {
         return null;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param link        No description provided
    * @param line        No description provided
    * @param grabParent  No description provided
    * @param role        No description provided
    * @param target      No description provided
    * @return            No description provided
    */
   private JGrab createGrab (UMLLink link, FSABendLine line, JComponent grabParent, String role, UMLObject target)
   {
      FSAGrab fsaGrab = new FSAGrab (link, role + "Grab", grabParent);
      Translator translator = new LogicFsaTranslator (line, 1);
      AbstractUpdater updater = new LogicToFsaUpdater();
      updater.setTranslator (translator);
      updater.setLogicAttrName (role);
      updater.setFsaAttrName ("target");
      updater.setLogicObject (link);
      fsaGrab.addToUpdater (updater);

      PanelGrabUI ui = (PanelGrabUI) PanelGrabUI.createUI (fsaGrab.getJComponent());
      fsaGrab.setUI (ui);
      fsaGrab.getJComponent().setOpaque (false);

      JGrab grab = (JGrab) fsaGrab.getJComponent();
      JRectangle rect = new JRectangle (DefaultBendUI.DEFAULT_SIZE, DefaultBendUI.DEFAULT_SIZE);
      grab.add (rect);

      SelectionListenerHelper.addSelectionListener (rect,
         SelectionPropagationListener.get (SelectionPropagationListener.CHILDREN));
      SelectionListenerHelper.addSelectionListener (rect,
         SelectionPropagationListener.get (SelectionPropagationListener.PARENT));
      AscendDescendMouseHandler.addMouseInputListener (rect, SelectionMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (rect, GrabMouseListener.get());
      ui.setGrabComponent (rect);

      FSALabel nameLabel = new FSALabel (link, role + "Role", fsaGrab.getJComponent());
      nameLabel.getJComponent().setOpaque (false);
      nameLabel.getJComponent().setVisible (LayoutPreferences.get().isShowRoleNames());
      Font tmpFont = FontContainer.getFont (FontContainer.DEFAULT_FONT, -2);
      nameLabel.setFont (tmpFont);
      SelectionListenerHelper.addSelectionListener (nameLabel.getJComponent(), ForegroundHighlighter.get());
      if (!LayoutPreferences.get().isShowRoleNames())
      {
         SelectionListenerHelper.addSelectionListener (nameLabel.getJComponent(), VisibilityHighlighter.get());
      }
      JLabel roleLabel = (JLabel) nameLabel.getJComponent();

      PropertyChangeListener pcl = new UMLinkPropertyChangeListener (null, null, null, roleLabel);
      link.addPropertyChangeListener (role + "Role", pcl);
      pcl.propertyChange (new PropertyChangeEvent (link, role + "Role", null, link.getCorrespondingRole (target)));

      RoleLayout layout = new RoleLayout (grab, rect,
         nameLabel.getJComponent(), null);
      grab.setLayout (layout);

      SelectionListenerHelper.addSelectionListener (grab, ForegroundHighlighter.get());
      AscendDescendMouseHandler.addMouseInputListener (grab, GrabMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (grab, DoubleClickMouseListener.get());
      SelectionListenerHelper.addSelectionListener (grab,
         SelectionPropagationListener.get (SelectionPropagationListener.CHILDREN));

      return grab;
   }
//	------------------------------ inner classes --------------------------------------------

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: mtt $
    * @version   $Revision: 1.54.2.2 $
    */
   private class UMLinkPropertyChangeListener implements PropertyChangeListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private FSATextFieldLabel textField;

      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private JLabel openingRangeBracket;

      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private JLabel closingRangeBracket;

      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private JLabel roleLabel;


      /**
       * Constructor for class UMPSObjectPropertyChangeListener
       *
       * @param textField  No description provided
       * @param opening    No description provided
       * @param closing    No description provided
       * @param role       No description provided
       */
      public UMLinkPropertyChangeListener (FSATextFieldLabel textField, JLabel opening, JLabel closing, JLabel role)
      {
         this.textField = textField;
         this.openingRangeBracket = opening;
         this.closingRangeBracket = closing;
         this.roleLabel = role;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param event  No description provided
       */
      public void propertyChange (PropertyChangeEvent event)
      {
         String propertyName = event.getPropertyName();
         if ("type".equals (propertyName))
         {
            boolean negative =
                ( ((Integer) event.getNewValue()).intValue() == 1) ? true : false;

            JTextFieldLabel field =
               (JTextFieldLabel) textField.getJComponent();
            if (negative)
            {
               field.setBorder (new CrossBorder (Color.black));
            }
            else
            {
               field.setBorder (null);
            }
         }
         else if ("range".equals (propertyName))
         {
            if ("".equals (event.getNewValue()))
            {
               openingRangeBracket.setVisible (false);
               closingRangeBracket.setVisible (false);
            }
            else
            {
               openingRangeBracket.setVisible (true);
               closingRangeBracket.setVisible (true);
            }
         }
         else if ("sourceRole".equals (propertyName) || "targetRole".equals (propertyName))
         {
            UMLRole oldRole = (UMLRole) event.getOldValue();
            UMLRole newRole = (UMLRole) event.getNewValue();
            if (oldRole != null)
            {
               oldRole.removePropertyChangeListener ("name", this);
            }
            if (newRole != null)
            {
               String name = newRole.getName();
               roleLabel.setText (name);
               newRole.addPropertyChangeListener ("name", this);
            }
         }
         else if ("name".equals (propertyName))
         {
            String name = (String) event.getNewValue();
            roleLabel.setText (name);
         }
      }
   }
}

/*
 * $Log: UMLink.java,v $
 * Revision 1.54.2.2  2005/11/04 09:35:31  mtt
 * color of link name and direction is updated according to modifier changes
 *
 */
