/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views;

import java.util.Iterator;

import javax.swing.*;


/**
 * Abstract implementation of the FilterEditor interface
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.13 $
 */
public abstract class AbstractFilterEditor extends JPanel implements FilterEditor
{
   /**
    * Get the editorPanel attribute of the AbstractFilterEditor object
    *
    * @return   The editorPanel value
    */
   public JPanel getEditorPanel()
   {
      return this;
   }


   /**
    * Get the newFilter attribute of the AbstractFilterEditor object
    *
    * @return   The newFilter value
    */
   public ConfigurableFilter getNewFilter()
   {
      ConfigurableFilter newFilter = null;

      try
      {
         newFilter = (ConfigurableFilter) getFilter().clone();
         setValues (newFilter);
      }
      catch (Exception e)
      {
      }

      return newFilter;
   }


   /**
    * Get the values attribute of the AbstractFilterEditor object
    */
   public final void getValues()
   {
      getValues (getFilter());
   }


   /**
    * Sets the values attribute of the AbstractFilterEditor object
    */
   public final void setValues()
   {
      ConfigurableFilter filter = getFilter();
      setValues (filter);

      Iterator iter = filter.iteratorOfViewDefinitions();
      while (iter.hasNext())
      {
         ViewDefinition def = (ViewDefinition) iter.next();

         if (def.isUpdate())
         {
            def.update();
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ConfigurableFilter filter = null;


   /**
    * Sets the filter attribute of the AbstractFilterEditor object
    *
    * @param filter  The new filter value
    */
   public void setFilter (ConfigurableFilter filter)
   {
      if (filter != this.filter)
      {
         this.filter = filter;

         if (this.filter != null)
         {
            getValues();
         }
      }
   }


   /**
    * Get the filter attribute of the AbstractFilterEditor object
    *
    * @return   The filter value
    */
   public ConfigurableFilter getFilter()
   {
      return this.filter;
   }


   /**
    * Get the values attribute of the AbstractFilterEditor object
    *
    * @param filter  No description provided
    */
   protected abstract void getValues (ConfigurableFilter filter);


   /**
    * Sets the values attribute of the AbstractFilterEditor object
    *
    * @param filter  The new values value
    */
   protected abstract void setValues (ConfigurableFilter filter);


   /**
    * create the Editor GUI
    */
   protected abstract void buildEditor();


   /**
    * Constructor for class AbstractFilterEditor
    *
    * @param filter  No description provided
    */
   public AbstractFilterEditor (ConfigurableFilter filter)
   {
      buildEditor();
      setFilter (filter);
   }
}

/*
 * $Log: AbstractFilterEditor.java,v $
 * Revision 1.13  2004/10/20 17:50:30  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
