/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views;

import java.util.Iterator;
import java.util.Set;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.views.cf.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.13 $
 */
public class CompositeFilter extends AbstractConfigurableFilter
{
   /**
    * Get the forDiagram attribute of the CompositeFilter object
    *
    * @param diag  No description provided
    * @return      The forDiagram value
    */
   public boolean isForDiagram (UMLDiagram diag)
   {
      CFDiagram diagram = getCFDiagram();
      if (diagram == null)
      {
         return true;
      }

      Iterator nodeIter = diagram.iteratorOfElements();
      while (nodeIter.hasNext())
      {
         ASGElement asgElement = (ASGElement) nodeIter.next();
         if (asgElement instanceof CFNode)
         {
            CFNode node = (CFNode) asgElement;
            if (node instanceof CFFilterNode)
            {
               Filter filter =  ((CFFilterNode) node).getFilter();

               if (filter != null && !filter.isForDiagram (diag))
               {
                  return false;
               }
            }
         }
      }
      return true;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param diag     No description provided
    * @param item     No description provided
    * @param context  No description provided
    * @return         No description provided
    */
   public Set grow1Context (UMLDiagram diag, UMLDiagramItem item, ItemSet context)
   {
      CFDiagram diagram = getCFDiagram();
      if (diagram == null || !diag.hasInElements (item))
      {
         return null;
      }

      if (context == null)
      {
         context = new ItemSet();
      }

      Set newItems = diagram.getResults (diag, item);
      newItems.removeAll (context);
      context.addAll (newItems);

      return newItems;
   }


   /**
    * <pre>
    *          0..1                            0..1
    * CompositeFilter ----------------------------- CFDiagram
    *          filter     CFDiagram
    * </pre>
    */
   private CFDiagram cfDiagram;


   /**
    * Sets the cFDiagram attribute of the CompositeFilter object
    *
    * @param value  The new cFDiagram value
    * @return       No description provided
    */
   public boolean setCFDiagram (CFDiagram value)
   {
      if (this.cfDiagram != value)
      {
         if (this.cfDiagram != null)
         {
            CFDiagram oldValue = this.cfDiagram;
            this.cfDiagram = null;
            oldValue.setFilter (null);
         }
         this.cfDiagram = value;
         if (value != null)
         {
            this.cfDiagram.setFilter (this);
         }

         return true;
      }

      return false;
   }


   /**
    * Get the cFDiagram attribute of the CompositeFilter object
    *
    * @return   The cFDiagram value
    */
   public CFDiagram getCFDiagram()
   {
      return this.cfDiagram;
   }


   /**
    * Get the editor attribute of the CompositeFilter object
    *
    * @return   The editor value
    */
   public FilterEditor getEditor()
   {
      return new CompositeFilterEditor (this);
   }
}

/*
 * $Log: CompositeFilter.java,v $
 * Revision 1.13  2004/10/20 17:50:30  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
