/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views;

import java.util.Iterator;
import java.util.Set;

import de.uni_paderborn.fujaba.uml.*;


/**
 * This Filter defines its 1-Context by following "+ the in- and outgoing links of the object
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.12 $
 */
public class LinkFilter extends AbstractFilter
{
   /**
    * Constructor for class LinkFilter
    */
   public LinkFilter()
   {
      super();
   }


   /**
    * Get the forDiagram attribute of the LinkFilter object
    *
    * @param diag  No description provided
    * @return      The forDiagram value
    */
   public boolean isForDiagram (UMLDiagram diag)
   {
      return  (diag instanceof UMLStoryPattern);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param diag     No description provided
    * @param item     No description provided
    * @param context  No description provided
    * @return         No description provided
    */
   public Set grow1Context (UMLDiagram diag, UMLDiagramItem item, ItemSet context)
   {
      if (item == null || ! (item instanceof UMLObject) || !diag.hasInElements (item))
      {
         return null;
      }
      ItemSet newNodes = new ItemSet();

      if (context == null)
      {
         context = new ItemSet();
      }

      Iterator iter =  ((UMLObject) item).iteratorOfRevSource();
      while (iter.hasNext())
      {
         UMLLink link = (UMLLink) iter.next();

         UMLDiagramItem tmpItem = tryAddConnection (diag, context, link);
         if (tmpItem != null)
         {
            newNodes.add (tmpItem);
         }
      }

      iter =  ((UMLObject) item).iteratorOfRevTarget();
      while (iter.hasNext())
      {
         UMLLink link = (UMLLink) iter.next();

         UMLDiagramItem tmpItem = tryAddConnection (diag, context, link);
         if (tmpItem != null)
         {
            newNodes.add (tmpItem);
         }
      }

      return newNodes;
   }


   /**
    * Get the description attribute of the LinkFilter object
    *
    * @return   The description value
    */
   public String getDescription()
   {
      return  ("This Filter defines its 1-Context by following " +
         "the in- and outgoing links of the object");
   }
}

/*
 * $Log: LinkFilter.java,v $
 * Revision 1.12  2004/10/20 17:50:30  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
