/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views.cf.unparse;

import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.swing.*;
import de.uni_paderborn.fujaba.fsa.unparse.*;
import de.uni_paderborn.fujaba.views.cf.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.10 $
 */
public class UMCFTransition extends AbstractUnparseModule
{
   /**
    * Get the mainFsaName attribute of the UMCFTransition object
    *
    * @return   The mainFsaName value
    */
   public String getMainFsaName()
   {
      return "line";
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      CFTransition transition = (CFTransition) incr;
      FSAContainer container = (FSAContainer) parent;

      // the new line
      FSABendLine line = new FSABendLine (incr, "line", parent.getJComponent());

      CFNode entry = transition.getSource();
      CFNode exit = transition.getTarget();

      if (entry == null || exit == null)
      {
         return line;
      }

      // take care that entry and exit are unparsed
      UnparseManager.get().unparse (entry, container);
      UnparseManager.get().unparse (exit, container);

      // these are the objects that definitely exist now
      FSAObject entryFsa = entry.getFromFsaObjects (container.getID() + ".entry");
      if (entry instanceof CFStartNode)
      {
         entryFsa = entry.getFromFsaObjects (entryFsa.getID() + ".circle");
      }
      FSAObject exitFsa = exit.getFromFsaObjects (container.getID() + ".entry");
      if (exit instanceof CFEndNode)
      {
         exitFsa = exit.getFromFsaObjects (exitFsa.getID() + ".circle");
      }

      JBendLine bendLine = (JBendLine) line.getJComponent();

      //FSAGrab fsaGrab = new FSAGrab (incr, "entryGrab", parent.getJComponent());
      //JGrab grab = (JGrab) fsaGrab.getJComponent ();
      JGrab grab = new JGrab (entryFsa.getJComponent());
      if (entryFsa.getJComponent().getParent() != null)
      {
         entryFsa.getJComponent().getParent().add (grab);
      }
      else if (bendLine.getParent() != null)
      {
         bendLine.getParent().add (grab);
      }

      bendLine.setStartBend (grab);
      grab.setVisible (false);

      // now the exitFsa
      //fsaGrab = new FSAGrab (incr, "exitGrab", parent.getJComponent());
      //grab = (JGrab) fsaGrab.getJComponent ();
      grab = new JGrab (exitFsa.getJComponent());
      grab.setUI ((BendUI) ArrowGrabUI.createUI (grab));
       ((ArrowGrabUI) grab.getUI()).setArrow (new JSimpleArrowHead());
      bendLine.getParent().add (grab);

      bendLine.setEndBend (grab);

      return line;
   }
}

/*
 * $Log: UMCFTransition.java,v $
 * Revision 1.10  2004/10/20 17:50:33  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
