/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.tools.fsa;

import java.awt.*;

import de.uni_paderborn.fujaba.basic.ClassMap;


/**
 * fsa default "converter"/"modifier" methods from sourcetype to targettype
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.17 $
 */
public class FSATypeConverterMethods
{

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public static String intToString (int value)
   {
      return String.valueOf (value);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public static String booleanToString (boolean value)
   {
      return String.valueOf (value);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public static String pointToString (Point value)
   {
      throw new RuntimeException ("FSATypeConverterMethods.pointToString ( " +
         value + " ) is empty!");
   }


   //
   // create boolean section
   //


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public static boolean intToboolean (int value)
   {
      return  (value == 1 ? true : false);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public static boolean stringToboolean (String value)
   {
      return Boolean.valueOf (value.trim()).booleanValue();
   }


   //
   // create Boolean section
   //


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public static Boolean stringToBoolean (String value)
   {
      return Boolean.valueOf (value);
   }


   //
   // create int section
   //


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public static int integerToint (Integer value)
   {
      return value.intValue();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public static int stringToint (String value)
   {
      return Integer.valueOf (value).intValue();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public static int booleanToint (boolean value)
   {
      return  (value ? 1 : 0);
   }


   /**
    * Get the width attribute of the FSATypeConverterMethods class
    *
    * @param value  No description provided
    * @return       The width value
    */
   public static int getWidth (Dimension value)
   {
      return value.width;
   }


   /**
    * Get the height attribute of the FSATypeConverterMethods class
    *
    * @param value  No description provided
    * @return       The height value
    */
   public static int getHeight (Dimension value)
   {
      return value.height;
   }


   /**
    * Get the x attribute of the FSATypeConverterMethods class
    *
    * @param value  No description provided
    * @return       The x value
    */
   public static int getX (Point value)
   {
      return value.x;
   }


   /**
    * Get the y attribute of the FSATypeConverterMethods class
    *
    * @param value  No description provided
    * @return       The y value
    */
   public static int getY (Point value)
   {
      return value.y;
   }


   /**
    * Get the red attribute of the FSATypeConverterMethods class
    *
    * @param value  No description provided
    * @return       The red value
    */
   public static int getRed (Color value)
   {
      return value.getRed();
   }


   /**
    * Get the blue attribute of the FSATypeConverterMethods class
    *
    * @param value  No description provided
    * @return       The blue value
    */
   public static int getBlue (Color value)
   {
      return value.getBlue();
   }


   /**
    * Get the green attribute of the FSATypeConverterMethods class
    *
    * @param value  No description provided
    * @return       The green value
    */
   public static int getGreen (Color value)
   {
      return value.getGreen();
   }


   //
   // create dimension section
   //


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public static Dimension stringToDimension (String value)
   {
      throw new RuntimeException ("FSATypeConverterMethods.stringToDimension ( " +
         value + " ) is empty !");
   }


   /**
    * set oldValue.width = newWidth
    *
    * @param newWidth  the new width
    * @param oldValue  the Dimension
    * @return          oldValue with width=newWidth
    */
   public static Dimension setWidth (int newWidth, Dimension oldValue)
   {
      oldValue.width = newWidth;

      return oldValue;
   }


   /**
    * set oldValue.height = newHeight
    *
    * @param newHeight  the new height
    * @param oldValue   the Dimension
    * @return           oldValue with height=newHeight
    */
   public static Dimension setHeight (int newHeight, Dimension oldValue)
   {
      oldValue.height = newHeight;

      return oldValue;
   }


   //
   // create point section
   //


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public static Point stringToPoint (String value)
   {
      throw new RuntimeException ("FSATypeConverterMethods.stringToPoint ( " +
         value + " ) is empty !");
   }


   /**
    * set oldValue.x = newX
    *
    * @param newX      the new X
    * @param oldValue  the Point
    * @return          oldValue with x=newX
    */
   public static Point setX (int newX, Point oldValue)
   {
      oldValue.x = newX;

      return oldValue;
   }


   /**
    * set oldValue.y = newY
    *
    * @param newY      the new Y
    * @param oldValue  the Point
    * @return          oldValue with y=newY
    */
   public static Point setY (int newY, Point oldValue)
   {
      oldValue.y = newY;

      return oldValue;
   }


   //
   // create color section
   //


   /**
    * @param newGreen  The new green value
    * @param oldValue  The new green value
    * @return          new Color ( oldValue.getRed(),newGreen , oldValue.getBlue ())
    */
   public static Color setGreen (int newGreen, Color oldValue)
   {
      return new Color (oldValue.getRed(), newGreen, oldValue.getBlue());
   }


   /**
    * @param newBlue   The new blue value
    * @param oldValue  The new blue value
    * @return          new Color ( oldValue.getRed (),oldValue.getGreen (),newBlue )
    */
   public static Color setBlue (int newBlue, Color oldValue)
   {
      return new Color (oldValue.getRed(), oldValue.getGreen(), newBlue);
   }


   /**
    * @param newRed    The new red value
    * @param oldValue  The new red value
    * @return          new Color ( newRed , oldValue.getGreen () , oldValue.getBlue ())
    */
   public static Color setRed (int newRed, Color oldValue)
   {
      return new Color (newRed, oldValue.getGreen(), oldValue.getBlue());
   }


   //
   // create class section
   //


   /**
    * @param className  No description provided
    * @return           FSAClassMap.get().forName ( className ) ;
    */
   public static Class stringToClass (String className)
   {
      return ClassMap.get().getClass (className);
   }

}

/*
 * $Log: FSATypeConverterMethods.java,v $
 * Revision 1.17  2004/10/20 17:50:34  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
