/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.uni_paderborn.lib.java.io;

import java.io.*;
import java.net.URL;
import java.util.Enumeration;


/**
 * Interface for Resource Locators<p>
 *
 * Implementors of this Interface provide a way to locate and open named Resources
 *
 * @author    student research group Reddmom
 * @version   $Revision: 1.5 $
 */
public interface ResourceLocator
{
   /**
    * Finds the resource with the given name. <p>
    *
    * A resource is some data (images, audio, text, etc) that can be accessed by class code
    * in a way that is independent of the location of the code. <p>
    *
    * The name of a resource is a "/"-separated path name that identifies the resource.
    *
    * @param name  the name of the Resource.
    * @return      a URL for reading the resource, or null if the resource could not be found
    *      or the caller doesn't have adequate privileges to get the resource.
    */
   public URL getResource (String name);


   /**
    * Returns an input stream for reading the specified resource. <p>
    *
    * A resource is some data (images, audio, text, etc) that can be accessed by class code
    * in a way that is independent of the location of the code. <p>
    *
    * The name of a resource is a "/"-separated path name that identifies the resource.
    *
    * @param name  the name of the Resource.
    * @return      an input stream for reading the resource, or null if the resource could
    *      not be found or the caller doesn't have adequate privileges to get the resource.
    */
   public InputStream getResourceAsStream (String name);


   /**
    * Finds all the resources with the given name. <p>
    *
    * A resource is some data (images, audio, text, etc) that can be accessed by class code
    * in a way that is independent of the location of the code. <p>
    *
    * The name of a resource is a "/"-separated path name that identifies the resource.
    *
    * @param name          resource name
    * @return              an enumeration of URLs to the resource. If no resources could be
    *      found, the enumeration will be empty. Resources that the ResourceLocator doesn't
    *      have access to will not be in the enumeration.
    * @throws IOException  if I/O errors occur
    */
   public Enumeration getResources (String name) throws IOException;
}

/*
 * $Log: ResourceLocator.java,v $
 * Revision 1.5  2004/08/02 07:34:12  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
