/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.uni_paderborn.lib.javax.swing;

import java.util.*;


/**
 * all sub classes of this class get a fire mechanism to inform their listeners that something
 * has changed.
 *
 * @author    Fujaba Development Group
 * @version   $Revision: 1.6 $
 */
public abstract class FireEventComponent
{
   /**
    * internal attribute to store all listeners.
    */
   private HashSet listeners = null;


   /**
    * instantiates the internal used listener set.
    */
   public FireEventComponent()
   {
      listeners = new HashSet();
   }


   /**
    * access method to get the set of listeners. This method is called by the sub classes of
    * this class when they want to inform all listeners.
    *
    * @return   set of all listeners
    */
   protected HashSet getListeners()
   {
      return listeners;
   }


   /**
    * adds an event listener to the list of listeners.
    *
    * @param listener  the EventListener to be added.
    */
   protected void addListener (EventListener listener)
   {
      if (listener != null &&
         !listeners.contains (listener))
      {
         listeners.add (listener);
      }
   }


   /**
    * removes an event listener from the list of listeners.
    *
    * @param listener  the EventListener to be removed.
    */
   protected void removeListener (EventListener listener)
   {
      if (listener != null &&
         listeners.contains (listener))
      {
         listeners.remove (listener);
      }
   }


   /**
    * access method to remove all references so that the garbage collector can free the object.
    */
   public void removeYou()
   {
      Iterator iter = listeners.iterator();
      while (iter.hasNext())
      {
         EventListener listener = (EventListener) iter.next();
         iter.remove();
         removeListener (listener);
      }
   }

}

/*
 * $Log: FireEventComponent.java,v $
 * Revision 1.6  2004/08/02 07:34:12  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
