/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.uni_paderborn.lib.javax.swing.filechooser;

import java.io.File;

import javax.swing.filechooser.FileFilter;

import de.uni_paderborn.lib.java.io.JarFileFilter;


/**
 * Implementation of a file filter for class paths.
 *
 * @author    student research group Reddmom
 * @version   $Revision: 1.4 $
 */
public class ClassPathFileFilter extends FileFilter
{
   /**
    * reference to the internal used file filter for jar files.
    */
   private JarFileFilter fileFilter;


   /**
    * get the value of fileFilter.
    *
    * @return   the value of fileFilter
    */
   public JarFileFilter getFileFilter()
   {
      return this.fileFilter;
   } // getFileFilter


   /**
    * set the value of fileFilter.
    *
    * @param value  The new fileFilter value
    */
   public void setFileFilter (JarFileFilter value)
   {
      if (this.fileFilter != value)
      {
         this.fileFilter = value;
      } // if ()
   } // setFileFilter


   /**
    * Constructor for class ClassPathFileFilter
    */
   public ClassPathFileFilter()
   {
      setFileFilter (new JarFileFilter());
   }


   /**
    * overrides the accept method inherited from javax.swing.filechooser.FileFilter.
    *
    * @param file  No description provided
    * @return      No description provided
    */
   public boolean accept (File file)
   {
      return  ( (file != null &&
         file.isDirectory()) ||
          (getFileFilter() != null &&
         getFileFilter().accept (file)));
   }


   /**
    * overrides the getDescription method inherited from javax.swing.filechooser.FileFilter.
    *
    * @return   The description value
    */
   public String getDescription()
   {
      return "Java Classpath Directories/Files";
   }
}

/*
 * $Log: ClassPathFileFilter.java,v $
 * Revision 1.4  2004/08/02 07:34:13  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
