/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.uni_paderborn.lib.javax.swing.progress;

import java.util.Vector;


/**
 * A task does something.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.3 $
 */
public abstract class Task
{
   /**
    */
   protected Vector statusRow = null;

   /**
    * if true the task finished its job.
    */
   protected boolean finished = false;

   /**
    * if true the job has been aborted.
    */
   protected boolean aborted = false;


   /**
    * create a SwingWorker thread which makes the job.
    *
    * @return   SwingWorker
    */
   protected abstract SwingWorker createSwingWorker();


   /**
    * initializes the task.
    */
   public Task()
   {
      statusRow = new Vector();
      Vector row = new Vector();
      row.add (new String ("Working - Please Wait"));
      row.add (new Integer (100));
      row.add (new Integer (0));
      statusRow.add (row);
   }


   /**
    * start the task. This method creates the special SwingWorker.
    */
   public void start()
   {
      setCurrent (0, 0);
      final SwingWorker worker = createSwingWorker();
      worker.start();
   }


   /**
    * Get the aborted attribute of the Task object.
    *
    * @return   The aborted value
    */
   public boolean isAborted()
   {
      return aborted;
   }


   /**
    * Sets the aborted attribute of the Task object
    *
    * @param value  The new aborted value
    */
   public void setAborted (boolean value)
   {
      aborted = value;
   }


   /**
    * Get the finished attribute of the Task object
    *
    * @return   The finished value
    */
   public boolean isFinished()
   {
      return finished;
   }


   /**
    * Sets the finished attribute of the Task object
    *
    * @param value  The new finished value
    */
   public void setFinished (boolean value)
   {
      finished = value;
   }


   /**
    * Get the barCount attribute of the Task object
    *
    * @return   The barCount value
    */
   public int getBarCount()
   {
      return statusRow.size();
   }


   /**
    * stop the task.
    */
   public void stop()
   {
      finished = true;
   }


   /**
    * Get the message attribute of the Task object
    *
    * @param i  No description provided
    * @return   The message value
    */
   public String getMessage (int i)
   {
      if (i >= 0 && i <= statusRow.size())
      {
         Vector row = (Vector) statusRow.get (i);
         return (String) row.get (0);
      } // end of if ()
      return "";
   }


   /**
    * Sets the message attribute of the Task object
    *
    * @param i    The new message value
    * @param msg  The new message value
    */
   protected void setMessage (int i, String msg)
   {
      if (i >= 0 && i <= statusRow.size())
      {
         Vector row = (Vector) statusRow.get (i);
         row.setElementAt (msg, 0);
      } // end of if ()
   }


   /**
    * Get the length attribute of the Task object
    *
    * @param i  No description provided
    * @return   The length value
    */
   public int getLength (int i)
   {
      if (i >= 0 && i <= statusRow.size())
      {
         Vector row = (Vector) statusRow.get (i);
         return  ((Integer) row.get (1)).intValue();
      } // end of if ()
      return 0;
   }


   /**
    * Sets the length attribute of the Task object
    *
    * @param i       The new length value
    * @param length  The new length value
    */
   protected void setLength (int i, int length)
   {
      if (i >= 0 && i <= statusRow.size())
      {
         Vector row = (Vector) statusRow.get (i);
         row.setElementAt (new Integer (length), 1);
      } // end of if ()
   }


   /**
    * Get the current attribute of the Task object
    *
    * @param i  No description provided
    * @return   The current value
    */
   public int getCurrent (int i)
   {
      if (i >= 0 && i <= statusRow.size())
      {
         Vector row = (Vector) statusRow.get (i);
         return  ((Integer) row.get (2)).intValue();
      } // end of if ()
      return 0;
   }


   /**
    * Sets the current attribute of the Task object
    *
    * @param i        The new current value
    * @param current  The new current value
    */
   protected void setCurrent (int i, int current)
   {
      if (i >= 0 && i <= statusRow.size())
      {
         Vector row = (Vector) statusRow.get (i);
         row.setElementAt (new Integer (current), 2);
      } // end of if ()
   }
}

/*
 * $Log: Task.java,v $
 * Revision 1.3  2004/08/02 07:34:13  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
