/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.uni_paderborn.lib.javax.swing.table;

import java.awt.*;

import javax.swing.*;
import javax.swing.table.TableCellRenderer;


/**
 * implements the interface TableCellRenderer of the package javax.swing.table.
 *
 * @author    Fujaba Development Group
 * @version   $Revision: 1.5 $
 * @see       javax.swing.table.TableCellRenderer
 */
public class CheckBoxCellRenderer implements TableCellRenderer
{
   /**
    * standard constructor of CheckBoxCellRenderer.
    */
   public CheckBoxCellRenderer() { }


   /**
    * overrides the method getTableCellRendererComponent of the interface TableCellRenderer.
    *
    * @param table       the table
    * @param value       a boolean value
    * @param isSelected  is the current cell selected or not
    * @param hasFocus    is the current cell focused
    * @param row         the row of the current cell
    * @param column      the column of the current cell
    * @return            a centered Checkbox which is selected ( true ) or not selected ( false
    *      ).
    * @see               javax.swing.table.TableCellRenderer#getTableCellRendererComponent
    */
   public Component getTableCellRendererComponent (JTable table,
                                                   Object value,
                                                   boolean isSelected,
                                                   boolean hasFocus,
                                                   int row,
                                                   int column)
   {
      JLabel label = new JLabel();
      GridBagLayout gridbag = new GridBagLayout();
      label.setLayout (gridbag);

      GridBagConstraints constraints = new GridBagConstraints();
      constraints.fill = GridBagConstraints.BOTH;
      constraints.anchor = GridBagConstraints.CENTER;
      constraints.gridwidth = 1;
      constraints.weightx = 1;
      constraints.weighty = 0;
      constraints.gridx = 0;
      constraints.gridy = 0;
      constraints.insets = new Insets (2, 0, 2, 0);

      if (isSelected)
      {
         label.setBackground (table.getSelectionBackground());
      } // end of if ()
      else
      {
         label.setBackground (Color.white);
      } // end of else

      if (value instanceof Boolean)
      {
         JPanel left = new JPanel();
         left.setOpaque (true);
         left.setBackground (label.getBackground());
         label.add (left, constraints);

         constraints.weightx = 0;
         constraints.gridx = 1;
         JCheckBox checkbox = new JCheckBox();
         checkbox.setBackground (label.getBackground());
         label.add (checkbox, constraints);

         constraints.weightx = 1;
         constraints.gridx = 2;
         JPanel right = new JPanel();
         right.setBackground (label.getBackground());
         label.add (right, constraints);

         checkbox.setSelected ( ((Boolean) value).booleanValue());
      } // end of if ()
      else
      {
         label.setText (value.toString());
      } // end of else

      return label;
   }
}

/*
 * $Log: CheckBoxCellRenderer.java,v $
 * Revision 1.5  2004/08/02 07:34:13  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
