/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.lib.util;

import java.awt.*;


/**
 * Class provides utility methodsfor window operations, e.g.
 * center on screen.
 *
 *
 * @author    joerg
 * @version   $Revision: 1.1 $ $Date: 2004/11/12 16:48:17 $
 */
public class WindowUtility
{

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param frame  No description provided
    */
   public final static void centerFrame (Component frame)
   {
      Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
      Dimension size = frame.getSize();

      int y =  (screenSize.height - size.height) / 2;
      int x =  (screenSize.width - size.width) / 2;

      frame.setLocation (x, y);

   }
}

/*
 * $Log: WindowUtility.java,v $
 * Revision 1.1  2004/11/12 16:48:17  joerg
 * problem: configuring different toolsuites
 * solution: use pluginlists for tool suite configs
 * additional effect: beautified plugin download dialog
 * enhancements: pluginlist tag may have name attribute, which results in a separate entry in download tree
 * note: please currently ignore the XML Parse Errors
 *
 */
