/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.upb.lib.userinterface;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.*;

import de.upb.lib.userinterface.action.*;


/**
 * @author    $Author: schneider $
 * @version   $Revision: 1.15 $
 */
/*
 *  package
 */
class ActionItem extends SectionItem
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int MENU_ITEM = 0;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int BUTTON = 1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int CHECKBOX = 2;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int RADIOBUTTON = 3;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int TOGGLE_BUTTON = 4;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static byte FLAT = 0;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static byte RAISED = 1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static byte PRESSED = 2;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private AbstractAction action;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int type;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ElementInitializer initializer;


   /**
    * Constructor for class ActionItem
    *
    * @param action  No description provided
    * @param type    No description provided
    */
   public ActionItem (AbstractAction action, int type)
   {
      this.action = action;
      this.type = type;
   } // constructor


   /**
    * Constructor for class ActionItem
    *
    * @param action       No description provided
    * @param type         No description provided
    * @param initializer  No description provided
    */
   public ActionItem (AbstractAction action, int type, ElementInitializer initializer)
   {
      this (action, type);
      this.initializer = initializer;
   } // constructor


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean showText = false;


   /**
    * Sets the showText attribute of the ActionItem object
    *
    * @param showText  The new showText value
    */
   public void setShowText (boolean showText)
   {
      this.showText = showText;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean selected = false;


   /**
    * Sets the selected attribute of the ActionItem object
    *
    * @param selected  The new selected value
    */
   public void setSelected (boolean selected)
   {
      this.selected = selected;
   }


   /**
    * ActionItem has no id, so returns the actions name.
    *
    * @return   The id value
    */
   public String getId()
   {
      return (String) action.getValue (Action.NAME);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public JComponent generateComponent()
   {
      final AbstractButton abstractButton;
      Class multiplexActionClass = UserInterfaceManager.get().getMultiplexActionClass();

      try
      {
         final AbstractMultiplexAction multiplexAction = (AbstractMultiplexAction) multiplexActionClass.newInstance();
         multiplexAction.setAction (action);
         multiplexAction.setElementInitializer (initializer);

         switch (type)
         {
            case MENU_ITEM:
               abstractButton = new JMenuItem (multiplexAction);
               break;
            case BUTTON:
               abstractButton = initButton (multiplexAction, new JButton());
               break;
            case TOGGLE_BUTTON:
               abstractButton = initButton (multiplexAction, new JToggleButton());
               break;
            case CHECKBOX:
               abstractButton = new JCheckBoxMenuItem (multiplexAction);
               abstractButton.setSelected (selected);
               break;
            case RADIOBUTTON:
               abstractButton = new JRadioButtonMenuItem (multiplexAction);
               abstractButton.setSelected (selected);
               break;
            default:
               abstractButton = null;
         }

         if (abstractButton != null)
         {
            Object visible = multiplexAction.getValue ("visible");
            if (visible instanceof Boolean)
            {
               abstractButton.setVisible ( ((Boolean) visible).booleanValue());
            }
            multiplexAction.addPropertyChangeListener (
               new PropertyChangeListener()
               {
                  public void propertyChange (PropertyChangeEvent evt)
                  {
                     if ("visible".equals (evt.getPropertyName()))
                     {
                        Object visible = multiplexAction.getValue ("visible");
                        if (visible instanceof Boolean)
                        {
                           abstractButton.setVisible ( ((Boolean) visible).booleanValue());
                        }
                     }
                  }
               });
         }

         return abstractButton;
      }
      catch (InstantiationException e)
      {
      }
      catch (IllegalAccessException e)
      {
      }

      return null;
   } // generateComponent


   /**
    * @param action  action that will be caused by the button
    * @param button  button to be initialized
    * @return        the modified button
    */
   private AbstractButton initButton (Action action, AbstractButton button)
   {
      button.setAction (action);

      ToolbarContainer toolbarContainer = (ToolbarContainer) getSection().getContainer();
      if (toolbarContainer.isRolloverButtons() &&
         ! ("Windows".equals (UIManager.getLookAndFeel().getName())))
      {
         button.setRolloverEnabled (false);
         ImageIcon imageIcon = (ImageIcon) action.getValue (Action.SMALL_ICON);

         button.setIcon (create3DBorderIcon (imageIcon, button.getBackground(), FLAT));
         button.setRolloverIcon (create3DBorderIcon (imageIcon, button.getBackground(), RAISED));
         button.setPressedIcon (create3DBorderIcon (imageIcon, button.getBackground(), PRESSED));

         button.setBorderPainted (false);
         button.setFocusPainted (false);
         button.setMargin (new Insets (-2, -2, -2, -2));
      }

      if (!showText)
      {
         button.setText (null);
      }

      return button;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param imageIcon  No description provided
    * @param color      No description provided
    * @param type       No description provided
    * @return           No description provided
    */
   private ImageIcon create3DBorderIcon (ImageIcon imageIcon, Color color, int type)
   {
      ImageIcon rolloverIcon = null;

      if (imageIcon != null)
      {
         int width = imageIcon.getIconWidth();
         int height = imageIcon.getIconHeight();

         BufferedImage bufferedImage = new BufferedImage (width + 6, height + 6, BufferedImage.TYPE_INT_RGB);
         Graphics2D graphics = bufferedImage.createGraphics();
         graphics.setColor (color);

         switch (type)
         {
            case FLAT:
               graphics.fillRect (0, 0, width + 6, height + 6);
               break;
            case RAISED:
               graphics.fill3DRect (0, 0, width + 5, height + 5, true);
               break;
            case PRESSED:
               graphics.fill3DRect (0, 0, width + 5, height + 5, false);
               break;
            default:
               break;
         }

         graphics.drawImage (imageIcon.getImage(), 3, 3, null);

         rolloverIcon = new ImageIcon (bufferedImage);
      }

      return rolloverIcon;
   }

}

/*
 * $Log: ActionItem.java,v $
 * Revision 1.15  2004/08/26 09:02:03  schneider
 * detecting conflicting mnemonics, visible property of actions introduced
 *
 */
