/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.upb.lib.userinterface.action;

import java.awt.event.ActionEvent;
import java.util.*;

import javax.swing.*;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;


/**
 * This class manages a number of actions in a chain of responsibility. Actions can register
 * themselves and are notified if an action on the responsible source object has happened.
 * An action may be responsible for a number of classes, except of 'null'. On the other hand,
 * if exist more than one responsible action for a class, the actions are notified in the sequence
 * they have been registrated.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.3 $
 */
public class CompositeAction extends AbstractAction
{
   /**
    * The hashmap to store the registrated actions.
    */
   private HashMap registratedActions = new HashMap();


   /**
    * Registrates actions.
    *
    * @param responsibleFor  class as key.
    * @param action          the action itself.
    */
   public void registerAction (String responsibleFor, AbstractAction action)
   {
      if (responsibleFor == null)
      {
         JOptionPane.showMessageDialog (
            null,
            "The action "
            + action.getValue (Action.NAME)
            + "wanted to register itself for 'null' values, which is not allowed.");
         return;
      }

      Vector list = (Vector) registratedActions.get (responsibleFor);

      if (list == null)
      {
         list = new Vector();
         list.add (action);
         registratedActions.put (responsibleFor, list);
      }
      else
      {
         if (!list.contains (action))
         {
            list.add (action);
         }
      }
   } //registerAction


   /**
    * Determines the source object and forwards the event to the responsible registrated action.
    * If no action is responsible, it shows a message dialog with detailed information.
    *
    * @param e  No description provided
    * @see      java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
    */
   public void actionPerformed (ActionEvent e)
   {
      Object source = e.getSource();

      if (source instanceof Iterator)
      {
         Iterator iter = (Iterator) source;

         Vector items = new Vector();

         // copy to temporary list because otherwise the
         // iterator in the source event will be destroyed
         while (iter.hasNext())
         {
            items.add (iter.next());
         }

         iter = items.iterator();

         while (iter.hasNext())
         {
            Object item = iter.next();
            String typeOfSrc = item.getClass().getName();

            Vector list = (Vector) registratedActions.get (typeOfSrc);
            if (list != null)
            {
               Iterator listIter = list.iterator();
               while (listIter.hasNext())
               {
                  AbstractAction action = (AbstractAction) listIter.next();

                  // construct new event
                  ActionEvent event = new ActionEvent (items.iterator(), e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers());

                  // fire new event to responsible class
                  action.actionPerformed (event);
               }
            }
         }
      }
      else
      {
         String typeOfSrc = source.getClass().getName();

         Vector list = (Vector) registratedActions.get (typeOfSrc);
         if (list != null)
         {
            Iterator iter = list.iterator();
            while (iter.hasNext())
            {
               AbstractAction action = (AbstractAction) iter.next();
               action.actionPerformed (e);
            }
         }

      }
   } // actionPerformed
}

/*
 * $Log: CompositeAction.java,v $
 * Revision 1.3  2004/11/10 09:24:38  lowende
 * Removed some compile warnings.
 *
 */
