/*
 * Decompiled with CFR 0.152.
 */
package de.m740.projectx.gigaset;

import de.m740.projectx.gigaset.GAufnahmeContainer;
import de.m740.projectx.gigaset.GAufnahmeIF;
import de.m740.projectx.gigaset.GConsole;
import de.m740.projectx.gigaset.GDialog;
import de.m740.projectx.gigaset.GPanelTableIF;
import de.m740.projectx.gigaset.GTable;
import de.m740.projectx.gigaset.GTableCellRenderer;
import de.m740.projectx.gigaset.GTableModel;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class GPanelAbstract
extends JPanel
implements GPanelTableIF {
    protected List aAufnahmen = null;
    protected GTableModel aTableModel = new GTableModel();
    protected GTable aTableAufnahmen = new GTable(this.aTableModel);
    protected JScrollPane spAufnahmen = new JScrollPane(this.aTableAufnahmen);
    private FileComparatorAZ aFileComparatorAZ = null;
    private FileComparatorZA aFileComparatorZA = null;
    private FileComparatorNO aFileComparatorNO = null;
    private FileComparatorON aFileComparatorON = null;
    protected int aSortSelector = 0;
    private GDialog aDialog = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public GPanelAbstract() {
        this.initialize();
    }

    private void initialize() {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.aTableAufnahmen.setDefaultRenderer(clazz, new GTableCellRenderer());
        }
        catch (RuntimeException exc) {
            GConsole.setErrorMessage(exc);
        }
    }

    protected void addAufnahme(int inpIndex, GAufnahmeIF inpAufnahme, HashMap inpHash) {
        String tmpTitel = inpAufnahme.getOriginalTitel();
        Object tmpObj = inpHash.get(tmpTitel);
        if (tmpObj instanceof GAufnahmeContainer) {
            GAufnahmeContainer tmpAufnahmeContainer = (GAufnahmeContainer)tmpObj;
            GAufnahmeIF tmpAufnahmeIF = tmpAufnahmeContainer.getAufnahme();
            tmpAufnahmeIF.setSerie(true);
            inpAufnahme.setSerie(true);
            tmpAufnahmeContainer.addChild(inpAufnahme);
        } else {
            GAufnahmeContainer tmpAufnahmeContainer = new GAufnahmeContainer(inpAufnahme);
            inpHash.put(tmpTitel, tmpAufnahmeContainer);
            int row = this.aTableModel.getRowCount();
            this.aTableModel.addRow(tmpAufnahmeContainer);
            this.aTableModel.fireTableRowsInserted(row, row);
        }
    }

    public void countChildren(int selector) {
        int anza = this.aTableModel == null ? 0 : this.aTableModel.getRowCount();
        int i = 0;
        while (i < anza) {
            Object tmpObject = this.aTableModel.getObjectAtRow(i);
            if (tmpObject instanceof GAufnahmeContainer) {
                ((GAufnahmeContainer)tmpObject).countChildren(selector);
            }
            ++i;
        }
    }

    private void sortiereAufnahmen(Comparator inpComparator) {
        int anza;
        this.clearSelection();
        this.aTableModel.clear();
        this.aTableModel.fireTableDataChanged();
        this.fireStateChanged();
        int n = anza = this.aAufnahmen == null ? 0 : this.aAufnahmen.size();
        if (anza > 1) {
            Collections.sort(this.aAufnahmen, inpComparator);
        }
        HashMap tmpHash = new HashMap(anza);
        int i = 0;
        while (i < anza) {
            try {
                GAufnahmeIF tmpAufnahme = (GAufnahmeIF)this.aAufnahmen.get(i);
                this.addAufnahme(i, tmpAufnahme, tmpHash);
            }
            catch (Exception exc) {
                GConsole.setErrorMessage(exc);
            }
            ++i;
        }
        this.aTableModel.fireTableRowsUpdated(0, this.aTableModel.getRowCount() - 1);
        tmpHash = null;
        if (this.aTableModel.getRowCount() == 0) {
            this.getDialog().zeigeInfos(-1);
        }
    }

    public void sortiereAufnahmen(int selector) {
        try {
            switch (selector) {
                case 1: {
                    this.sortiereAufnahmen(this.getFileComparatorAZ());
                    break;
                }
                case 2: {
                    this.sortiereAufnahmen(this.getFileComparatorZA());
                    break;
                }
                case 0: {
                    this.sortiereAufnahmen(this.getFileComparatorNO());
                    break;
                }
                case 3: {
                    this.sortiereAufnahmen(this.getFileComparatorON());
                }
            }
        }
        catch (RuntimeException exc) {
            GConsole.setErrorMessage(exc);
        }
    }

    public GAufnahmeIF getSelectedAufnahme() {
        int nr;
        block5: {
            block4: {
                try {
                    if (this.aTableAufnahmen != null && this.aTableModel != null) break block4;
                    return null;
                }
                catch (Exception exc) {
                    GConsole.setErrorMessage(exc);
                    return null;
                }
            }
            nr = this.aTableAufnahmen.getSelectedRow();
            if (nr >= 0) break block5;
            return null;
        }
        return this.aTableModel.getAufnahmeAtRow(nr);
    }

    public int readSelectedAufnahme() {
        int nr;
        block3: {
            try {
                nr = this.aTableAufnahmen.getSelectedRow();
                if (nr >= 0) break block3;
                return -1;
            }
            catch (Exception e) {
                GConsole.setErrorMessage(e);
                return -1;
            }
        }
        GAufnahmeIF tmpAufnahme = this.aTableModel.getAufnahmeAtRow(nr);
        tmpAufnahme.readAufnahme();
        return nr;
    }

    public String getSelectedExtension() {
        GAufnahmeIF tmpAufnahme = this.getSelectedAufnahme();
        if (tmpAufnahme == null) {
            return null;
        }
        return tmpAufnahme.getExtension();
    }

    public String getSelectedOutname() {
        String tmpString2;
        String tmpString = this.getSelectedTitel();
        if (tmpString != null && tmpString.indexOf(46) >= 0 && (tmpString2 = this.getSelectedExtension()) != null) {
            tmpString = String.valueOf(tmpString) + tmpString2;
        }
        return tmpString;
    }

    public String getSelectedTitel() {
        GAufnahmeIF tmpAufnahme = this.getSelectedAufnahme();
        if (tmpAufnahme == null) {
            return null;
        }
        return tmpAufnahme.getTitel();
    }

    protected String shortPathOf(String inpPath) {
        if (inpPath == null) {
            return "";
        }
        char tmpC = File.separatorChar;
        int x1 = inpPath.indexOf(tmpC);
        String tmpString = "";
        if (x1 > 0) {
            int len = inpPath.length();
            tmpString = String.valueOf(tmpString) + inpPath.substring(0, x1 + 1);
            inpPath = len - 1 == x1 ? "" : inpPath.substring(x1 + 1);
        }
        int x2 = inpPath.lastIndexOf(File.separatorChar);
        tmpString = String.valueOf(tmpString) + (x2 == x1 || x2 < 0 ? inpPath : "..." + inpPath.substring(x2));
        return tmpString;
    }

    public void addChangeListener(ChangeListener l) {
        this.removeChangeListener(l);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeChangeListener(ChangeListener l) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent tmpChangeEvent = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.swing.event.ChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (tmpChangeEvent == null) {
                    tmpChangeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(tmpChangeEvent);
            }
            i -= 2;
        }
    }

    protected GDialog getDialog() {
        return this.aDialog;
    }

    protected void setDialog(GDialog inpDialog) {
        this.aDialog = inpDialog;
    }

    protected void clearSelection() {
        this.aTableAufnahmen.getSelectionModel().clearSelection();
    }

    private void actionDone(boolean inpOK) {
        if (!inpOK) {
            this.clearSelection();
        }
        this.getDialog().actionDone(inpOK, true);
    }

    private boolean isExpander() {
        boolean ok;
        block9: {
            GAufnahmeContainer tmpContainer;
            int nr;
            block10: {
                ok = false;
                if (this.aTableAufnahmen == null || this.aTableModel == null) {
                    return ok;
                }
                nr = this.aTableAufnahmen.getSelectedRow();
                if (nr < 0) {
                    return ok;
                }
                Object tmpObject = this.aTableModel.getObjectAtRow(nr);
                if (!(tmpObject instanceof GAufnahmeContainer)) break block9;
                tmpContainer = (GAufnahmeContainer)tmpObject;
                if (tmpContainer.hasChildren()) break block10;
                return false;
            }
            try {
                ok = true;
                if (tmpContainer.isExpanded()) {
                    List tmpList = tmpContainer.getDoubles();
                    int anz = tmpList == null ? 0 : tmpList.size();
                    int i = 0;
                    while (i < anz) {
                        GAufnahmeContainer tmpDouble = (GAufnahmeContainer)tmpList.get(0);
                        this.aTableModel.removeRow(tmpDouble);
                        tmpContainer.removeDouble(tmpDouble);
                        ++i;
                    }
                    this.aTableModel.fireTableRowsDeleted(nr + 1, nr + i);
                } else {
                    List tmpList = tmpContainer.getChildren();
                    int anz = tmpList == null ? 0 : tmpList.size();
                    int r = nr;
                    int i = 0;
                    while (i < anz) {
                        GAufnahmeIF tmpAufnahme = (GAufnahmeIF)tmpList.get(i);
                        GAufnahmeContainer tmpDouble = new GAufnahmeContainer(tmpAufnahme);
                        this.aTableModel.addRow(++r, tmpDouble);
                        tmpContainer.addDouble(tmpDouble);
                        ++i;
                    }
                    this.aTableModel.fireTableRowsInserted(nr + 1, r);
                }
            }
            catch (Exception exc) {
                GConsole.setErrorMessage(exc);
            }
        }
        return ok;
    }

    protected void mouseClick(MouseEvent event) {
        int clicks = event.getClickCount();
        int x = event.getX();
        if (event.getButton() == 1 && clicks == 2 && x > 22) {
            this.actionDone(true);
        } else if (clicks == 1 & x < 21 && this.isExpander()) {
            return;
        }
    }

    protected FileComparatorAZ getFileComparatorAZ() {
        if (this.aFileComparatorAZ == null) {
            this.aFileComparatorAZ = new FileComparatorAZ();
        }
        return this.aFileComparatorAZ;
    }

    private FileComparatorZA getFileComparatorZA() {
        if (this.aFileComparatorZA == null) {
            this.aFileComparatorZA = new FileComparatorZA();
        }
        return this.aFileComparatorZA;
    }

    private FileComparatorNO getFileComparatorNO() {
        if (this.aFileComparatorNO == null) {
            this.aFileComparatorNO = new FileComparatorNO();
        }
        return this.aFileComparatorNO;
    }

    protected FileComparatorON getFileComparatorON() {
        if (this.aFileComparatorON == null) {
            this.aFileComparatorON = new FileComparatorON();
        }
        return this.aFileComparatorON;
    }

    protected int getSortSelector() {
        return this.aSortSelector;
    }

    protected void setSortSelector(int inpSortSelector) {
        this.aSortSelector = inpSortSelector;
    }

    class FileComparatorAZ
    implements Comparator {
        FileComparatorAZ() {
        }

        public int compare(Object arg0, Object arg1) {
            try {
                GAufnahmeIF tmpAufnahme = (GAufnahmeIF)arg0;
                String tmpFN0 = tmpAufnahme.getOriginalTitel();
                tmpAufnahme = (GAufnahmeIF)arg1;
                String tmpFN1 = tmpAufnahme.getOriginalTitel();
                return tmpFN0.compareToIgnoreCase(tmpFN1);
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }

    class FileComparatorZA
    implements Comparator {
        FileComparatorZA() {
        }

        public int compare(Object arg0, Object arg1) {
            try {
                return -GPanelAbstract.this.getFileComparatorAZ().compare(arg0, arg1);
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }

    class FileComparatorON
    implements Comparator {
        FileComparatorON() {
        }

        public int compare(Object arg0, Object arg1) {
            try {
                GAufnahmeIF tmpAufnahme = (GAufnahmeIF)arg0;
                String tmpFN0 = tmpAufnahme.getCridFilename();
                tmpAufnahme = (GAufnahmeIF)arg1;
                String tmpFN1 = tmpAufnahme.getCridFilename();
                return tmpFN0.compareTo(tmpFN1);
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }

    class FileComparatorNO
    implements Comparator {
        FileComparatorNO() {
        }

        public int compare(Object arg0, Object arg1) {
            try {
                return -GPanelAbstract.this.getFileComparatorON().compare(arg0, arg1);
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }
}

