/*
 * Decompiled with CFR 0.152.
 */
package de.m740.projectx.gigaset;

import de.m740.projectx.gigaset.GConsole;
import de.m740.projectx.gigaset.GDialog;
import de.m740.projectx.gigaset.GFTPHandler;
import de.m740.projectx.gigaset.GPanelFTP;
import de.m740.projectx.gigaset.GStrings;
import de.m740.projectx.gigaset.GTable;
import de.m740.projectx.gigaset.GTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.xinput.XInputDirectory;
import net.sourceforge.dvb.projectx.xinput.XInputFile;
import net.sourceforge.dvb.projectx.xinput.ftp.FtpVO;
import org.apache.commons.net.ftp.FTPClient;

public class GPanelLost
extends JPanel {
    private static final long serialVersionUID = 1L;
    private MyChangeListener aChangeListener = null;
    private JButton btnRefresh = new JButton(GStrings.getString("gdialog.lost.refresh"));
    protected JButton btnHinzufuegen = new JButton(CommonGui.loadIcon((String)"addleft.gif"));
    protected JButton btnLoeschen = new JButton(GStrings.getString("gdialog.lost.delete"));
    private GTableModel aTableModel = new GTableModel(){

        public Object getValueAt(int inpRowIndex, int inpColumnIndex) {
            String tmpObject = "";
            if (inpColumnIndex == 0 && inpRowIndex >= 0 && inpRowIndex < this.getRowCount()) {
                tmpObject = this.getListe().get(inpRowIndex);
                if (tmpObject instanceof File) {
                    return ((File)((Object)tmpObject)).getName();
                }
                if (tmpObject instanceof XInputFile) {
                    return ((XInputFile)tmpObject).getName();
                }
            }
            return tmpObject;
        }
    };
    private GTable aTableAufnahmen = new GTable(this.aTableModel);
    private JScrollPane spAufnahmen = new JScrollPane(this.aTableAufnahmen);
    private GDialog aDialog = null;
    private XInputDirectory aXInputDirectory = null;
    private GFTPHandler aFTPHandler = null;
    private GPanelFTP.XInputFileComparatorAZ aXFileComparatorAZ = null;
    protected boolean aDeleteFTP = false;

    public GPanelLost(GDialog inpDialog) {
        this.setDialog(inpDialog);
        this.buildPanel();
    }

    protected void buildPanel() {
        this.setLayout(new BorderLayout());
        JPanel tmpPanelTop = new JPanel(new GridLayout(1, 2));
        this.btnRefresh.setToolTipText(GStrings.getString("gdialog.lost.tip"));
        tmpPanelTop.add(this.btnRefresh);
        this.add((Component)tmpPanelTop, "North");
        this.add((Component)this.spAufnahmen, "Center");
        JPanel tmpPanelBottom = new JPanel(new GridLayout(1, 2));
        this.btnHinzufuegen.setEnabled(false);
        this.btnHinzufuegen.setToolTipText(GStrings.getString("gdialog.record.add"));
        tmpPanelBottom.add(this.btnHinzufuegen);
        this.btnLoeschen.setToolTipText(GStrings.getString("gdialog.delete.dir.tip"));
        this.btnLoeschen.setEnabled(false);
        tmpPanelBottom.add(this.btnLoeschen);
        this.add((Component)tmpPanelBottom, "South");
        this.aTableAufnahmen.setSelectionMode(2);
        this.btnRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPanelLost.this.aDeleteFTP = (e.getModifiers() & 1) == 1;
                GPanelLost.this.sucheAufnahmen();
            }
        });
        this.btnHinzufuegen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPanelLost.this.actionDone(true);
            }
        });
        this.btnLoeschen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPanelLost.this.delete();
            }
        });
        ListSelectionModel tmpSelectionModel = this.aTableAufnahmen.getSelectionModel();
        tmpSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    GPanelLost.this.doEnabled();
                }
            }
        });
    }

    protected void clearSelection() {
        try {
            this.aTableAufnahmen.getSelectionModel().clearSelection();
        }
        catch (RuntimeException exc) {
            GConsole.setErrorMessage(exc);
        }
    }

    private void clearTable() {
        try {
            this.clearSelection();
            this.aTableModel.clear();
            this.aTableModel.fireTableDataChanged();
            this.doEnabled();
        }
        catch (RuntimeException exc) {
            GConsole.setErrorMessage(exc);
        }
    }

    protected void clearTable(ChangeEvent inpEvent) {
        try {
            this.clearTable();
        }
        catch (RuntimeException exc) {
            GConsole.setErrorMessage(exc);
        }
    }

    protected String shortPathOf(String inpPath) {
        if (inpPath == null) {
            return "";
        }
        char tmpC = File.separatorChar;
        int x1 = inpPath.indexOf(tmpC);
        String tmpString = "";
        if (x1 > 0) {
            int len = inpPath.length();
            tmpString = String.valueOf(tmpString) + inpPath.substring(0, x1 + 1);
            inpPath = len - 1 == x1 ? "" : inpPath.substring(x1 + 1);
        }
        int x2 = inpPath.lastIndexOf(File.separatorChar);
        tmpString = String.valueOf(tmpString) + (x2 == x1 || x2 < 0 ? inpPath : "..." + inpPath.substring(x2));
        return tmpString;
    }

    protected GDialog getDialog() {
        return this.aDialog;
    }

    protected void setDialog(GDialog inpDialog) {
        this.aDialog = inpDialog;
    }

    protected GTable getTableAufnahmen() {
        return this.aTableAufnahmen;
    }

    protected void actionDone(boolean inpOK) {
        if (inpOK) {
            ActionEvent tmpActionEvent = new ActionEvent(this, 2, "apply");
            this.getDialog().getActionListener().actionPerformed(tmpActionEvent);
        }
    }

    protected void doEnabled() {
        try {
            int index = this.getTableAufnahmen().getSelectedRow();
            boolean enable = index >= 0;
            this.btnHinzufuegen.setEnabled(enable &= this.btnRefresh.isEnabled());
            this.btnLoeschen.setEnabled(enable &= this.aDeleteFTP || this.getXInputDirectory() == null);
        }
        catch (RuntimeException exc) {
            GConsole.setErrorMessage(exc);
        }
    }

    public void addDirectory(File inpDir) {
        try {
            int i = this.aTableModel.getRowCount();
            this.aTableModel.addRow(inpDir);
            this.aTableModel.fireTableRowsInserted(i, i);
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    public ChangeListener getChangeListener() {
        if (this.aChangeListener == null) {
            this.aChangeListener = new MyChangeListener();
        }
        return this.aChangeListener;
    }

    protected List getUsedRecDirectories() {
        List tmpList = null;
        try {
            tmpList = this.getDialog().getUsedRecDirectories();
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    public void sucheAufnahmen() {
        this.btnRefresh.setEnabled(false);
        Runnable tmpRunnable = new Runnable(){

            public void run() {
                try {
                    GPanelLost.this.sucheAufnahmen2();
                }
                catch (Exception exc) {
                    GConsole.setErrorMessage(exc);
                }
            }
        };
        try {
            if (EventQueue.isDispatchThread()) {
                new Thread(tmpRunnable).start();
            } else {
                EventQueue.invokeLater(tmpRunnable);
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sucheAufnahmen2() {
        try {
            try {
                this.clearTable();
                this.setXInputDirectory(null);
                ArrayList tmpList = new ArrayList();
                Object tmpObj = this.getDialog().getLostRecDirectories(tmpList);
                if (tmpObj instanceof XInputDirectory) {
                    this.setXInputDirectory((XInputDirectory)tmpObj);
                    this.btnLoeschen.setText(GStrings.getString("gdialog.lost.delete"));
                } else {
                    this.btnLoeschen.setText(GStrings.getString("gdialog.lost.detail"));
                }
                int anzd = tmpList == null ? 0 : tmpList.size();
                int i = 0;
                while (true) {
                    block9: {
                        if (i < anzd) break block9;
                        if (this.aTableModel.getRowCount() == 0) {
                            File tmpFile = new File("--- no losts found :-) ---");
                            this.aTableModel.addRow(tmpFile);
                            this.aTableModel.fireTableRowsInserted(0, 0);
                        }
                        break;
                    }
                    tmpObj = tmpList.get(i);
                    this.aTableModel.addRow(tmpObj);
                    this.aTableModel.fireTableRowsInserted(i, i);
                    ++i;
                }
            }
            catch (Exception e) {
                GConsole.setErrorMessage(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.btnRefresh.setEnabled(true);
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        this.btnRefresh.setEnabled(true);
    }

    private boolean[] deleteLocal(Object[] inpObjects, int[] inpRows) {
        File[] tmpDirs;
        boolean[] tmpOKs;
        block13: {
            String[] tmpPathes;
            String tmpTitel;
            block12: {
                block11: {
                    tmpOKs = null;
                    if (inpObjects != null && inpObjects.length != 0) break block11;
                    return null;
                }
                tmpDirs = new File[inpObjects.length];
                tmpTitel = GStrings.getString("gdialog.delete.dir");
                tmpPathes = new String[tmpDirs.length];
                int i = 0;
                while (i < tmpPathes.length) {
                    tmpDirs[i] = (File)inpObjects[i];
                    File tmpDir = tmpDirs[i];
                    if (tmpDir.isDirectory()) {
                        String tmpDirPath = tmpDir.getAbsolutePath();
                        tmpPathes[i] = tmpDirPath = tmpDirPath.replace('\\', '/');
                    }
                    ++i;
                }
                JFileChooser tmpChooser = new JFileChooser(tmpDirs[0]);
                tmpChooser.setApproveButtonText(tmpTitel);
                tmpChooser.setFileSelectionMode(2);
                int tmpI = tmpChooser.showDialog(this, tmpTitel);
                if (tmpI == 0) break block12;
                return null;
            }
            Toolkit.getDefaultToolkit().beep();
            String tmpWarning = GStrings.getString("gdialog.delete.warning");
            StringBuffer tmpBuffer = new StringBuffer();
            int i = 0;
            while (i < tmpPathes.length) {
                tmpBuffer.append(tmpPathes[i]);
                tmpBuffer.append("<br>");
                ++i;
            }
            if (JOptionPane.showConfirmDialog(this, tmpWarning = tmpWarning.replaceAll("%dir%", tmpBuffer.toString()), tmpTitel, 2) == 0) break block13;
            return null;
        }
        try {
            tmpOKs = new boolean[tmpDirs.length];
            int j = tmpDirs.length - 1;
            while (j >= 0) {
                File tmpDir = tmpDirs[j];
                File[] tmpFiles = tmpDir.listFiles();
                int anz = tmpFiles == null ? 0 : tmpFiles.length;
                boolean ok = true;
                int i = 0;
                while (ok && i < anz) {
                    File tmpFile = tmpFiles[i];
                    ok = tmpFile.delete();
                    ++i;
                }
                String tmpMsg = tmpDir.getAbsolutePath();
                if (ok && (ok = tmpDir.delete())) {
                    int row = inpRows[j];
                    this.aTableModel.removeRow(row);
                    this.aTableModel.fireTableRowsDeleted(row, row);
                }
                tmpOKs[j] = ok;
                GConsole.setInfo(String.valueOf(tmpMsg) + (ok ? " " : " not ") + "deleted");
                --j;
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpOKs;
    }

    private boolean[] deleteFTP(Object[] inpObjects, int[] inpRows) {
        int anz;
        XInputFile[][] tmpFiles;
        XInputDirectory[] tmpDirs;
        FtpVO tmpVO;
        GFTPHandler tmpHandler;
        boolean[] tmpBs;
        block10: {
            block9: {
                tmpBs = null;
                if (inpObjects != null && inpObjects.length != 0) break block9;
                return null;
            }
            tmpHandler = this.getFTPHandler();
            tmpVO = tmpHandler.makeVOFrom(this.getXInputDirectory());
            XInputFile[] inpFiles = new XInputFile[inpObjects.length];
            tmpDirs = new XInputDirectory[inpFiles.length];
            tmpFiles = new XInputFile[inpFiles.length][];
            StringBuffer tmpBuffer = new StringBuffer();
            int i = 0;
            while (i < inpFiles.length) {
                XInputDirectory tmpDir;
                inpFiles[i] = (XInputFile)inpObjects[i];
                XInputFile tmpFile = inpFiles[i];
                tmpDirs[i] = tmpDir = tmpHandler.makeDirectoryFrom(tmpFile, tmpVO);
                tmpFiles[i] = tmpDir.getFiles();
                tmpBuffer.append(tmpDir.getDirectory());
                tmpBuffer.append("<br>");
                ++i;
            }
            anz = tmpFiles == null ? 0 : tmpFiles.length;
            Toolkit.getDefaultToolkit().beep();
            String tmpWarning = GStrings.getString("gdialog.delete.warning");
            tmpWarning = tmpWarning.replaceAll("%dir%", tmpBuffer.toString());
            String tmpTitel = GStrings.getString("gdialog.delete.dir");
            if (JOptionPane.showConfirmDialog(this, tmpWarning, tmpTitel, 2) == 0) break block10;
            return null;
        }
        try {
            FTPClient tmpClient = tmpHandler.openClient(tmpVO);
            tmpBs = new boolean[anz];
            int i = anz - 1;
            while (i >= 0) {
                String tmpWD = tmpDirs[i].getDirectory();
                boolean ok = tmpClient.changeWorkingDirectory(tmpWD);
                int j = 0;
                while (ok && j < tmpFiles[i].length) {
                    XInputFile tmpFile = tmpFiles[i][j];
                    String tmpFN = tmpFile.getName();
                    if (!".".equals(tmpFN) && !"..".equals(tmpFN)) {
                        ok = tmpClient.deleteFile(tmpFN);
                    }
                    ++j;
                }
                XInputDirectory tmpDir = tmpDirs[i];
                String tmpFN = tmpDir.getDirectory();
                if (ok && (ok = tmpClient.removeDirectory(tmpFN))) {
                    int row = inpRows[i];
                    this.aTableModel.removeRow(row);
                    this.aTableModel.fireTableRowsDeleted(row, row);
                }
                tmpBs[i] = ok;
                GConsole.setInfo(String.valueOf(tmpFN) + (ok ? " " : " not ") + "deleted");
                --i;
            }
            tmpHandler.closeClient(tmpClient);
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpBs;
    }

    protected void delete() {
        this.btnLoeschen.setEnabled(false);
        try {
            GTable tmpTable = this.getTableAufnahmen();
            int[] tmpRows = tmpTable.getSelectedRows();
            if (tmpRows == null || tmpRows.length == 0) {
                return;
            }
            Object[] tmpObjects = new Object[tmpRows.length];
            int i = 0;
            while (i < tmpRows.length) {
                tmpObjects[i] = ((GTableModel)tmpTable.getModel()).getObjectAtRow(tmpRows[i]);
                ++i;
            }
            boolean[] tmpOKs = null;
            if (tmpObjects[0] instanceof File) {
                tmpOKs = this.deleteLocal(tmpObjects, tmpRows);
            } else if (tmpObjects[0] instanceof XInputFile) {
                tmpOKs = this.deleteFTP(tmpObjects, tmpRows);
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    private List copyLocal(Object[] inpObjects, int[] inpRows) {
        ArrayList<XInputFile> tmpList;
        block9: {
            tmpList = null;
            if (inpObjects != null && inpObjects.length != 0) break block9;
            return null;
        }
        try {
            int anzd = inpObjects.length;
            File[] tmpDirs = new File[anzd];
            int i = 0;
            while (i < anzd) {
                File tmpFile = (File)inpObjects[i];
                tmpDirs[i] = tmpFile.isDirectory() ? tmpFile : null;
                ++i;
            }
            i = 0;
            while (i < tmpDirs.length) {
                File tmpDir = tmpDirs[i];
                if (tmpDir != null) {
                    int anzf;
                    Object[] tmpFiles = tmpDir.listFiles(new FilenameFilter(){

                        public boolean accept(File f, String s) {
                            return s.toLowerCase().endsWith(".mpg");
                        }
                    });
                    int n = anzf = tmpFiles == null ? 0 : tmpFiles.length;
                    if (anzf > 1) {
                        Arrays.sort(tmpFiles);
                    }
                    int j = 0;
                    while (j < anzf) {
                        Object tmpFile = tmpFiles[j];
                        XInputFile tmpXFile = new XInputFile(tmpFile);
                        if (tmpList == null) {
                            tmpList = new ArrayList<XInputFile>();
                        }
                        tmpList.add(tmpXFile);
                        ++j;
                    }
                    GConsole.setMessage("Get " + anzf + " lost " + ".mpg" + "-files from " + tmpDirs[i].getName());
                }
                ++i;
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    private List copyFTP(Object[] inpObjects, int[] inpRows) {
        ArrayList<XInputFile> tmpList;
        block12: {
            tmpList = null;
            if (inpObjects != null && inpObjects.length != 0) break block12;
            return null;
        }
        try {
            GFTPHandler tmpHandler = this.getFTPHandler();
            FtpVO tmpVO = tmpHandler.makeVOFrom(this.getXInputDirectory());
            XInputFile[] inpFiles = new XInputFile[inpObjects.length];
            XInputDirectory[] tmpDirs = new XInputDirectory[inpFiles.length];
            XInputFile[][] tmpFiles = new XInputFile[inpFiles.length][];
            int i = 0;
            while (i < inpFiles.length) {
                XInputDirectory tmpDir;
                inpFiles[i] = (XInputFile)inpObjects[i];
                XInputFile tmpFile = inpFiles[i];
                tmpDirs[i] = tmpDir = tmpHandler.makeDirectoryFrom(tmpFile, tmpVO);
                XInputFile[] tmpFiles2 = tmpDir.getFiles();
                tmpFiles[i] = tmpFiles2;
                ++i;
            }
            int anz = tmpFiles == null ? 0 : tmpFiles.length;
            int i2 = 0;
            while (i2 < anz) {
                XInputFile[] tmpFilesJ = tmpFiles[i2];
                int anzf = tmpFilesJ == null ? 0 : tmpFilesJ.length;
                ArrayList<XInputFile> tmpList2 = null;
                int j = 0;
                while (j < anzf) {
                    XInputFile tmpFile = tmpFilesJ[j];
                    String tmpFN = tmpFile.getName();
                    if (tmpFN.toLowerCase().endsWith(".mpg")) {
                        if (tmpList2 == null) {
                            tmpList2 = new ArrayList<XInputFile>();
                        }
                        tmpList2.add(tmpFile);
                    }
                    ++j;
                }
                anzf = 0;
                if (tmpList2 != null) {
                    anzf = tmpList2.size();
                    if (anzf > 1) {
                        Collections.sort(tmpList2, this.getXFileComparatorAZ());
                    }
                    if (tmpList == null) {
                        tmpList = tmpList2;
                    } else {
                        tmpList.addAll(tmpList2);
                    }
                    tmpList2 = null;
                }
                GConsole.setMessage("Get " + anzf + " lost " + ".mpg" + "-files from " + tmpDirs[i2].getDirectory());
                ++i2;
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    public List getSelectedLostMPGs() {
        int[] tmpRows;
        GTable tmpTable;
        List tmpList;
        block7: {
            this.btnLoeschen.setEnabled(false);
            tmpList = null;
            tmpTable = this.getTableAufnahmen();
            tmpRows = tmpTable.getSelectedRows();
            if (tmpRows != null && tmpRows.length != 0) break block7;
            return null;
        }
        try {
            Object[] tmpObjects = new Object[tmpRows.length];
            int i = 0;
            while (i < tmpRows.length) {
                tmpObjects[i] = ((GTableModel)tmpTable.getModel()).getObjectAtRow(tmpRows[i]);
                ++i;
            }
            if (tmpObjects[0] instanceof File) {
                tmpList = this.copyLocal(tmpObjects, tmpRows);
            } else if (tmpObjects[0] instanceof XInputFile) {
                tmpList = this.copyFTP(tmpObjects, tmpRows);
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    private XInputDirectory getXInputDirectory() {
        return this.aXInputDirectory;
    }

    private void setXInputDirectory(XInputDirectory inpInputDirectory) {
        this.aXInputDirectory = inpInputDirectory;
    }

    protected GFTPHandler getFTPHandler() {
        if (this.aFTPHandler == null) {
            this.aFTPHandler = new GFTPHandler();
        }
        return this.aFTPHandler;
    }

    protected GPanelFTP.XInputFileComparatorAZ getXFileComparatorAZ() {
        if (this.aXFileComparatorAZ == null) {
            this.aXFileComparatorAZ = new GPanelFTP.XInputFileComparatorAZ();
        }
        return this.aXFileComparatorAZ;
    }

    class MyChangeListener
    implements ChangeListener {
        MyChangeListener() {
        }

        public void stateChanged(ChangeEvent inpE) {
            GPanelLost.this.clearTable(inpE);
        }
    }
}

