
#define GLE_AXIS_MAX 7
#define GLE_AXIS_X0  5
#define GLE_AXIS_Y0  6
#define GLE_AXIS_X2  3
#define GLE_AXIS_Y2  4
#define GLE_AXIS_X   1
#define GLE_AXIS_Y   2
#define GLE_AXIS_T   7

#define GLE_AXIS_LOG_DEFAULT  0
#define GLE_AXIS_LOG_OFF      1
#define GLE_AXIS_LOG_25B      2
#define GLE_AXIS_LOG_25       3
#define GLE_AXIS_LOG_1        4

bool axis_ticks_neg(int axis);
bool axis_is_max(int axis);
bool axis_horizontal(int axis);
int axis_get_orth(int axis, int which);
int axis_type(char *s);
bool axis_is_pos(double pos, int* cnt, double del, vector<double>& vec);
bool axis_is_pos_perc(double pos, int* cnt, double perc, vector<double>& vec);

class axis_struct {
public:
	int type;	/* 1=xaxis 2=yaxis 3=x2axis 4=y2axis */
	double base;
	double length;
	double shift;
	int color;
	int label_font;
	double label_hei;
	double label_scale;
	double label_dist;
	int log;
	int lgset;
	double min,max;
	int minset,maxset;
	int nofirst,nolast;
	int nticks,nsubticks;
	bool has_ftick, has_offset, ticks_both;
	double ftick, dticks, dsubticks, offset;
	double ticks_length,ticks_scale,ticks_lwidth;
	char ticks_lstyle[9];
	double subticks_length,subticks_scale,subticks_lwidth;
	char subticks_lstyle[9],label_lstyle[9];
	int off;
	int label_off;
	int side_off,ticks_off,subticks_off;
	double side_lwidth,label_lwidth;
	char side_lstyle[9];
	int title_font;
	int ticks_color,side_color,subticks_color,label_color;
	double title_dist;
	double title_hei,title_scale;
	int title_rot,title_off;
	int title_color;	/* 0=normal, 1=rotate 180 */
	int names_ds;
	double label_angle;
	string title;
	vector<string> names;
	vector<double> places;
	vector<double> noticks1;
	vector<double> noticks2;
	vector<double> noplaces;
	int negate;
	string format;
public:
	axis_struct();
	~axis_struct();
	void init(int i);
	string* getNamePtr(int i);
	void setName(int i, const char* name);
	void setPlace(int i, double place);
	void clearNoTicks();
	void addNoTick(double pos);
	void insertNoTick(double pos);
	void insertNoTickOrLabel(double pos);
	void insertNoTick(double pos, vector<double>& vec);
	void printNoTicks();
	void getLabelsFromDataSet(int ds);
	int getNbNamedPlaces();
	bool isNoPlaceLogOrReg(double pos, int* place_cnt, double delta);	
	inline bool isPlace(double pos, int* cnt, double delta) { return axis_is_pos(pos, cnt, delta, places); }
	inline bool isNoPlace(double pos, int* cnt, double delta) { return axis_is_pos(pos, cnt, delta, noplaces); }
	inline bool isNoTick1(double pos, int* cnt, double delta) { return axis_is_pos(pos, cnt, delta, noticks1); }
	inline bool isNoTick2(double pos, int* cnt, double delta) { return axis_is_pos(pos, cnt, delta, noticks2); }
	inline bool isPlacePerc(double pos, int* cnt) { return axis_is_pos_perc(pos, cnt, 0.001, places); }
	inline bool isNoPlacePerc(double pos, int* cnt) { return axis_is_pos_perc(pos, cnt, 0.001, noplaces); }
	inline bool isNoTick1Perc(double pos, int* cnt) { return axis_is_pos_perc(pos, cnt, 0.001, noticks1); }
	inline bool isNoTick2Perc(double pos, int* cnt) { return axis_is_pos_perc(pos, cnt, 0.001, noticks2); }
	inline void addName(const char* name) { names.push_back(string(name)); }
	inline void addPlace(double place) { places.push_back(place); }
	inline void addNoTick1(double pos) { noticks1.push_back(pos); }
	inline void addNoTick2(double pos) { noticks2.push_back(pos); }
	inline void addNoPlace(double pos) { noplaces.push_back(pos); }
	inline void insertNoTick1(double pos) { insertNoTick(pos, noticks1); }
	inline void insertNoTick2(double pos) { insertNoTick(pos, noticks2); }
	inline void insertNoPlace(double pos) { insertNoTick(pos, noplaces); }
	inline bool hasPlaces() { return places.size() != 0; }
	inline bool hasNames() { return names.size() != 0; }
	inline int getNbPlaces() { return places.size(); }
	inline int getNbNames() { return names.size(); }
	inline void setNamesDataSet(int i) { names_ds = i; }
	inline int getNamesDataSet() { return names_ds; }
	inline double getLabelAngle() { return label_angle; }
	inline void setLabelAngle(double angle) { label_angle = angle; }
};

void draw_axis(axis_struct *ax, gbox* box);	/* Draws the axis */
void print_axis(axis_struct *ax);
