#ifndef INCLUDE_D_INTERFACE
#define INCLUDE_D_INTERFACE
//
// all device files (d_*) should define these functions
// core.cpp calls them

class GLEDevice {
public:
	GLEDevice();
	virtual ~GLEDevice();
	virtual void arc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy) = 0;
	virtual void arcto(dbl x1,dbl y1,dbl x2,dbl y2,dbl rrr) = 0;
	virtual void beginclip(void)  = 0;
	virtual void bezier(dbl x1,dbl y1,dbl x2,dbl y2,dbl x3,dbl y3) = 0;
	virtual void box_fill(dbl x1, dbl y1, dbl x2, dbl y2) = 0;
	virtual void box_stroke(dbl x1, dbl y1, dbl x2, dbl y2, bool reverse) = 0;
	virtual void dochar(int font, int cc) = 0;
	virtual void resetfont() = 0;
	virtual void circle_fill(double zr) = 0;
	virtual void circle_stroke(double zr) = 0;
	virtual void clear(void) = 0;
	virtual void clip(void) = 0;
	virtual void closedev(void) = 0;
	virtual void closepath(void) = 0;
	virtual void dfont(char *c) = 0;
	virtual void ellipse_fill(double rx, double ry) = 0;
	virtual void ellipse_stroke(double rx, double ry) = 0;
	virtual void elliptical_arc(double rx,double ry,double t1,double t2,double cx,double cy) = 0;
	virtual void elliptical_narc(double rx,double ry,double t1,double t2,double cx,double cy) = 0;
	virtual void endclip(void)  = 0;
	virtual void fill(void) = 0;
	virtual void fill_ary(int nwk,double *wkx,double *wky) = 0;
	virtual void flush(void) = 0;
	// virtual void get_line_cap(int *i) = 0;
	virtual void get_type(char *t) = 0;
	virtual void line(double zx,double zy) = 0;
	virtual void line_ary(int nwk,double *wkx,double *wky) = 0;
	virtual void message(char *s) = 0;
	virtual void move(double zx,double zy) = 0;
	virtual void narc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy) = 0;
	virtual void newpath(void) = 0;
	virtual void opendev(double width, double height, const string& outputfile, const string& inputfile) = 0;
	virtual void pscomment(char* ss) = 0;
	virtual void reverse(void)    /* reverse the order of stuff in the current path */ = 0;
	virtual void set_color(int f) = 0;
	virtual void set_fill(int f) = 0;
	virtual void set_pattern_color(int c) = 0;
	virtual void set_line_cap(int i) = 0;
	virtual void set_line_join(int i) = 0;
	virtual void set_line_miterlimit(double d) = 0;
	virtual void set_line_style(char *s) = 0;
	virtual void set_line_styled(double dd) = 0;
	virtual void set_line_width(double w) = 0;
	virtual void set_matrix(double newmat[3][3]) = 0;
	virtual void set_path(int onoff) = 0;
	virtual void source(char *s) = 0;
	virtual void stroke(void) = 0;
	virtual void set_color(void) = 0;
	virtual void set_fill(void) = 0;
	virtual void xdbox(double x1, double y1, double x2, double y2) = 0;
	virtual void devcmd(char *s) = 0;
	virtual FILE* get_file_pointer(void) = 0;
	virtual int getDeviceType() = 0;
};

class PSGLEDevice : public GLEDevice {
protected:
	bool m_IsEps;
	bool m_IsPageSize;
	int ps_nvec;
	string output_file;
	string input_file;
	int first_ellipse;
	list<string> comments;
	FILE *psfile;
	int i,l,j;
	colortyp g_cur_fill, g_cur_color, g_cur_fill_color;
	int bb_width, bb_height, bb_xorig, bb_yorig;
public:
	PSGLEDevice(bool eps);
	virtual ~PSGLEDevice();
	virtual void arc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy);
	virtual void arcto(dbl x1,dbl y1,dbl x2,dbl y2,dbl rrr);
	virtual void beginclip(void) ;
	virtual void bezier(dbl x1,dbl y1,dbl x2,dbl y2,dbl x3,dbl y3);
	virtual void box_fill(dbl x1, dbl y1, dbl x2, dbl y2);
	virtual void box_stroke(dbl x1, dbl y1, dbl x2, dbl y2, bool reverse);
	virtual void dochar(int font, int cc);
	virtual void resetfont();
	virtual void circle_fill(double zr);
	virtual void circle_stroke(double zr);
	virtual void clear(void);
	virtual void clip(void);
	virtual void closedev(void);
	virtual void closepath(void);
	virtual void dfont(char *c);
	virtual void ellipse_fill(double rx, double ry);
	virtual void ellipse_stroke(double rx, double ry);
	virtual void elliptical_arc(double rx,double ry,double t1,double t2,double cx,double cy);
	virtual void elliptical_narc(double rx,double ry,double t1,double t2,double cx,double cy);
	virtual void endclip(void) ;
	virtual void fill(void);
	virtual void fill_ary(int nwk,double *wkx,double *wky);
	virtual void flush(void);
	// virtual void get_line_cap(int *i);
	virtual void get_type(char *t);
	virtual void line(double zx,double zy);
	virtual void line_ary(int nwk,double *wkx,double *wky);
	virtual void message(char *s);
	virtual void move(double zx,double zy);
	virtual void narc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy);
	virtual void newpath(void);
	virtual void opendev(double width, double height, const string& outputfile, const string& inputfile);
	virtual void pscomment(char* ss);
	virtual void reverse(void)    /* reverse the order of stuff in the current path */;
	virtual void set_color(int f);
	virtual void set_fill(int f);
	virtual void set_pattern_color(int c);
	virtual void set_line_cap(int i);
	virtual void set_line_join(int i);
	virtual void set_line_miterlimit(double d);
	virtual void set_line_style(char *s);
	virtual void set_line_styled(double dd);
	virtual void set_line_width(double w);
	virtual void set_matrix(double newmat[3][3]);
	virtual void set_path(int onoff);
	virtual void source(char *s);
	virtual void stroke(void);
	virtual void set_color(void);
	virtual void set_fill(void);
	virtual void xdbox(double x1, double y1, double x2, double y2);
	virtual void devcmd(char *s);
	virtual FILE* get_file_pointer(void);
	virtual int getDeviceType();
protected:
	void set_color(colortyp& color);
	void ddfill(void);
	void shade(void);
	void test_psfile(void);
	void read_psfont(void);
        void displayGeometry(double width, double height, int *gsPixelWidth, int *gsPixelHeight, int *gsPixelRes);
public:
	inline bool isEps() { return m_IsEps; }
	inline bool isOutputPageSize() { return m_IsPageSize; }
	inline void setOutputPageSize(bool out) { m_IsPageSize = out; }
	inline int getBBWidth() { return bb_width; }
	inline int getBBHeight() { return bb_height; }
	inline int getBBXOrigin() { return bb_xorig; }
	inline int getBBYOrigin() { return bb_yorig; }
};

class SVGGLEDevice : public GLEDevice {
protected:
	int ps_nvec;
	list<string> comments;
	double linewidth;
	string linecap;
	string linejoin;
	string miterlimit;
	double Width;
	double Height;
	string output_file;
	string input_file;
	FILE *SVGFile;
	int i,l,j;
	colortyp g_cur_fill, g_cur_color;
public:
	SVGGLEDevice();
	virtual ~SVGGLEDevice();
	virtual void arc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy);
	virtual void arcto(dbl x1,dbl y1,dbl x2,dbl y2,dbl rrr);
	virtual void beginclip(void) ;
	virtual void bezier(dbl x1,dbl y1,dbl x2,dbl y2,dbl x3,dbl y3);
	virtual void box_fill(dbl x1, dbl y1, dbl x2, dbl y2);
	virtual void box_stroke(dbl x1, dbl y1, dbl x2, dbl y2, bool reverse);
	virtual void dochar(int font, int cc);
	virtual void resetfont();
	virtual void circle_fill(double zr);
	virtual void circle_stroke(double zr);
	virtual void clear(void);
	virtual void clip(void);
	virtual void closedev(void);
	virtual void closepath(void);
	virtual void dfont(char *c);
	virtual void ellipse_fill(double rx, double ry);
	virtual void ellipse_stroke(double rx, double ry);
	virtual void elliptical_arc(double rx,double ry,double t1,double t2,double cx,double cy);
	virtual void elliptical_narc(double rx,double ry,double t1,double t2,double cx,double cy);
	virtual void endclip(void) ;
	virtual void fill(void);
	virtual void fill_ary(int nwk,double *wkx,double *wky);
	virtual void flush(void);
	// virtual void get_line_cap(int *i);
	virtual void get_type(char *t);
	virtual void line(double zx,double zy);
	virtual void line_ary(int nwk,double *wkx,double *wky);
	virtual void message(char *s);
	virtual void move(double zx,double zy);
	virtual void narc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy);
	virtual void newpath(void);
	virtual void opendev(double width, double height, const string& outputfile, const string& inputfile);
	virtual void pscomment(char* ss);
	virtual void reverse(void)    /* reverse the order of stuff in the current path */;
	virtual void set_color(int f);
	virtual void set_fill(int f);
	virtual void set_pattern_color(int c);
	virtual void set_line_cap(int i);
	virtual void set_line_join(int i);
	virtual void set_line_miterlimit(double d);
	virtual void set_line_style(char *s);
	virtual void set_line_styled(double dd);
	virtual void set_line_width(double w);
	virtual void set_matrix(double newmat[3][3]);
	virtual void set_path(int onoff);
	virtual void source(char *s);
	virtual void stroke(void);
	virtual void set_color(void);
	virtual void set_fill(void);
	virtual void xdbox(double x1, double y1, double x2, double y2);
	virtual void devcmd(char *s);
	virtual FILE* get_file_pointer(void);
	virtual int getDeviceType();
protected:
	void ddfill(void);
	void shade(void);
	void test_SVGFile();
	void reapsfont(void);
	string GetColor();
	inline double AY(double y) { return Height-y; }
};

class GLEDummyDevice : public GLEDevice {
protected:
	bool m_ShowError;
public:
	GLEDummyDevice(bool showerror);
	virtual ~GLEDummyDevice();
	virtual void arc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy);
	virtual void arcto(dbl x1,dbl y1,dbl x2,dbl y2,dbl rrr);
	virtual void beginclip(void) ;
	virtual void bezier(dbl x1,dbl y1,dbl x2,dbl y2,dbl x3,dbl y3);
	virtual void box_fill(dbl x1, dbl y1, dbl x2, dbl y2);
	virtual void box_stroke(dbl x1, dbl y1, dbl x2, dbl y2, bool reverse);
	virtual void dochar(int font, int cc);
	virtual void resetfont();
	virtual void circle_fill(double zr);
	virtual void circle_stroke(double zr);
	virtual void clear(void);
	virtual void clip(void);
	virtual void closedev(void);
	virtual void closepath(void);
	virtual void dfont(char *c);
	virtual void ellipse_fill(double rx, double ry);
	virtual void ellipse_stroke(double rx, double ry);
	virtual void elliptical_arc(double rx,double ry,double t1,double t2,double cx,double cy);
	virtual void elliptical_narc(double rx,double ry,double t1,double t2,double cx,double cy);
	virtual void endclip(void) ;
	virtual void fill(void);
	virtual void fill_ary(int nwk,double *wkx,double *wky);
	virtual void flush(void);
	virtual void get_type(char *t);
	virtual void line(double zx,double zy);
	virtual void line_ary(int nwk,double *wkx,double *wky);
	virtual void message(char *s);
	virtual void move(double zx,double zy);
	virtual void narc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy);
	virtual void newpath(void);
	virtual void opendev(double width, double height, const string& outputfile, const string& inputfile);
	virtual void pscomment(char* ss);
	virtual void reverse(void)    /* reverse the order of stuff in the current path */;
	virtual void set_color(int f);
	virtual void set_fill(int f);
	virtual void set_pattern_color(int c);
	virtual void set_line_cap(int i);
	virtual void set_line_join(int i);
	virtual void set_line_miterlimit(double d);
	virtual void set_line_style(char *s);
	virtual void set_line_styled(double dd);
	virtual void set_line_width(double w);
	virtual void set_matrix(double newmat[3][3]);
	virtual void set_path(int onoff);
	virtual void source(char *s);
	virtual void stroke(void);
	virtual void set_color(void);
	virtual void set_fill(void);
	virtual void xdbox(double x1, double y1, double x2, double y2);
	virtual void devcmd(char *s);
	virtual FILE* get_file_pointer(void);
	virtual int getDeviceType();
};

#ifdef HAVE_X11

#ifdef VMS
 #include <decw$include/Xlib.h>
 #include <decw$include/Xutil.h>
#else
 #ifdef aix
  #define NeedFunctionPrototypes 0
 #endif
 #include <X11/Xlib.h>
 #include <X11/Xutil.h>
#endif

#define NUM_COLTABLE_ENTRIES 34
#define X11_PATH_LENGTH 500

struct X11Pnt {int type,x,y;} ;

class X11GLEDevice : public GLEDevice {
protected:
	int color_table[NUM_COLTABLE_ENTRIES];
	int maxxsize;
	int maxysize;
	int window1W;
	int window1H;
	Display *dpy;
	Window window1;
	GC gc,gcf;
	Screen *screen;
	int doesbackingstore;
	double savexsize,saveysize;
	int gle_nspeed; /* text mode = slow and fast */
	int i,l,j,ix,iy;
	double f;
	double xsizecm,ysizecm;
	double d_scale, d_xscale, d_yscale;
	int d_graphmode;
	int d_fillstyle,d_fillcolor;
	int d_lstyle,d_lwidth;
	int d_maxy;
	int safnt;
	struct X11Pnt pnts[X11_PATH_LENGTH];
	int npnts;
	int startx,starty;
public:
	X11GLEDevice();
	virtual ~X11GLEDevice();
	virtual void arc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy);
	virtual void arcto(dbl x1,dbl y1,dbl x2,dbl y2,dbl rrr);
	virtual void beginclip(void) ;
	virtual void bezier(dbl x1,dbl y1,dbl x2,dbl y2,dbl x3,dbl y3);
	virtual void box_fill(dbl x1, dbl y1, dbl x2, dbl y2);
	virtual void box_stroke(dbl x1, dbl y1, dbl x2, dbl y2, bool reverse);
	virtual void dochar(int font, int cc);
	virtual void resetfont();
	virtual void circle_fill(double zr);
	virtual void circle_stroke(double zr);
	virtual void clear(void);
	virtual void clip(void);
	virtual void closedev(void);
	virtual void closepath(void);
	virtual void dfont(char *c);
	virtual void ellipse_fill(double rx, double ry);
	virtual void ellipse_stroke(double rx, double ry);
	virtual void elliptical_arc(double rx,double ry,double t1,double t2,double cx,double cy);
	virtual void elliptical_narc(double rx,double ry,double t1,double t2,double cx,double cy);
	virtual void endclip(void) ;
	virtual void fill(void);
	virtual void fill_ary(int nwk,double *wkx,double *wky);
	virtual void flush(void);
	// virtual void get_line_cap(int *i);
	virtual void get_type(char *t);
	virtual void line(double zx,double zy);
	virtual void line_ary(int nwk,double *wkx,double *wky);
	virtual void message(char *s);
	virtual void move(double zx,double zy);
	virtual void narc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy);
	virtual void newpath(void);
	virtual void opendev(double width, double height, const string& outputfile, const string& inputfile);
	virtual void pscomment(char* ss);
	virtual void reverse(void)    /* reverse the order of stuff in the current path */;
	virtual void set_color(int f);
	virtual void set_fill(int f);
	virtual void set_pattern_color(int c);
	virtual void set_line_cap(int i);
	virtual void set_line_join(int i);
	virtual void set_line_miterlimit(double d);
	virtual void set_line_style(char *s);
	virtual void set_line_styled(double dd);
	virtual void set_line_width(double w);
	virtual void set_matrix(double newmat[3][3]);
	virtual void set_path(int onoff);
	virtual void source(char *s);
	virtual void stroke(void);
	virtual void set_color(void);
	virtual void set_fill(void);
	virtual void xdbox(double x1, double y1, double x2, double y2);
	virtual void devcmd(char *s);
	virtual FILE* get_file_pointer(void);
	virtual int getDeviceType();
protected:
	void setcolor(int);
	void setfillcolor(int);
	void setfillstyle(int);
	double getmaxx();
	double getmaxy();
	int getmaxcolor();
	void doInitialize();
	int  doDefineColor(int n);
	void doCreateWindows();
	void doCreateGraphicsContext();
	void doLoadFont();
	void doExpose();
	void doWMHints();
	void doMapWindows();
	void openDisplay();
	void path_move(int x, int y);
	void path_line(int x, int y);
	void path_close(void);
	void path_fill(void);
	void path_newpath(void);
	void path_stroke(void);
	int set_expose(void);
	int wait_expose(void);
	void dxy(double x, double y, int *dx, int *dy);
	void rxy(double x, double y, int *dx, int *dy);
	void dxy_short(double x, double y, short *dx, short *dy);
	void rxy_short(double x, double y, short *dx, short *dy);
};

#endif
#endif
