//
// graph include
//

#define BEGINDEF extern

#define GLE_GRAPH_LM_PLAIN    0
#define GLE_GRAPH_LM_STEPS    1
#define GLE_GRAPH_LM_FSTEPS   2
#define GLE_GRAPH_LM_HIST     3
#define GLE_GRAPH_LM_IMPULSES 4

/* for key command and gx(), gy() */

#define dbg if ((gle_debug & 64)>0)
#define LARGE_NUM 1E30
extern int gle_debug;

class KeyInfo;

void graph_init(void);
void graph_free(void);
void iffree(void *p,char *s);
void setrange(double x, double y, int m);
void gdraw_key(KeyInfo* info);
void copy_default(int d);
void do_dataset(int d);
void draw_errbar(double x, double y, double eup, double ewid);
void fill_vec(double x1, double y1, double x2, double y2, vector<double>* vec);
void do_smooth(void);
void window_set(void);
bool window_min_max_set();
void draw_bars(void);
void draw_lines(void);
void draw_fills(void);
void draw_err(void);
void do_let(char *s, bool finetune) throw(ParserError);
void request(void);
/*int draw_axis(void *axis);*/
void bar_reset();
void doskip(char *s,int *ct);
double get_next_exp(TOKENS tk,int ntk,int *curtok);
void store_window_bounds_to_vars();
void draw_markers(void) throw (ParserError);
void draw_mark(double x1, double y1, int i, double sz, double dval) throw (ParserError);
void set_dataset_minmax_based_on_axis();

/* #define fnx(vv)  (((vv-wxmin)/(wxmax-wxmin)) * xlength + xbl) */
/* #define fny(vv)  (((vv-wymin)/(wymax-wymin)) * ylength + ybl) */
#define kw(ss) if (str_i_equals(tk[ct],ss))
#define true (!false)
#define false 0

void var_find_dn(int *idx, int *vara, int *nd);
char *un_quote(char *ct);

#define skipspace doskip(tk[ct],&ct)
//#define tok(n)  (*tk)[n]
#define tok(n)  tk[n]
#define next_exp (get_next_exp(tk,ntk,&ct))
#define next_font ((ct+=1),pass_font(tk[ct]))
#define next_marker ((ct+=1),pass_marker(tk[ct]))
#define next_color ((ct+=1),pass_color_var(tk[ct]))
#define next_fill ((ct+=1),pass_color_var(tk[ct]))
#define next_str(s)  (ct+=1,skipspace,strcpy(s,tk[ct]))
#define next_str_cpp(s)  (ct+=1,skipspace,s=tk[ct])
#define next_vstr(s)  (ct+=1,skipspace,mystrcpy(&s,tk[ct]))
#define next_vquote(s) (ct+=1,skipspace,mystrcpy(&s,un_quote(tk[ct])))
#define next_vquote_cpp(s) (ct+=1,skipspace,pass_file_name(tk[ct],s))
#define next_quote(s) (ct+=1,skipspace,strcpy(s,un_quote(tk[ct])))

struct fill_data {
	int da,db;	/* fill from, too */
	int type; 	/* 1= x1,d1, 2=d1,x2, 3=d1,d2, 4=d1 */
	int color;
	double xmin,ymin,xmax,ymax;
};

struct data_struct {
	double *xv;	/* x data values */
	double *yv; /* y data values */
	int *miss; /* if true miss this point */
	int nomiss;
	int np; /* NUMBER OF POINTS */
	int autoscale;
	bool axisscale;
	bool inverted;
	char lstyle[9];
	char *bigfile;	/* for datasets too big for memory */
	char *key_name;
	int key_fill;
	char errup[9],errdown[9];
	double errwidth;
	char herrup[9],herrdown[9];
	double herrwidth;
	double msize,lwidth;
	vector<string>* yv_str;
	int
	marker,
	smooth,
	smoothm,
	svg_smooth, /* Savitski Golay filtering true=on */
	svg_poly,  /* the type of polynomial 2,3,4,5...*/
	svg_points, /* the number of points 5,7,9,11.... */
	svg_iter; /* numb or time to do svg smoothing */
	int line_mode;
	int mdata;
	int color;
	double xmin,ymin,xmax,ymax;
	double mscale;
	int line;
	int axis;
	double rx1,ry1,rx2,ry2;
};

class bar_struct {
public:
	int ngrp;
	int from[20];
	int to[20];
	double width,dist;
	double lwidth[20];
	char lstyle[20][9];
	int fill[20];
	int color[20];
	int side[20];
	int top[20];
	int pattern[20];
	int notop;
	double x3d,y3d;
	bool horiz;
	string style[20];
	bar_struct();
};

#ifdef __TURBOC__
#define MAXTEMP 2000
#else
#define MAXTEMP 10000
#endif

#ifdef GRAPHDEF
#else
#define GRAPHDEF
#endif

GRAPHDEF double range_x1,range_y1,range_x2,range_y2;  /* graph unist */
GRAPHDEF double graph_x1,graph_y1,graph_x2,graph_y2;  /* in cm */
GRAPHDEF double graph_xmin,graph_ymin,graph_xmax,graph_ymax; /* graph units */
GRAPHDEF char ebuff[400];
GRAPHDEF int etype,eplen;
GRAPHDEF double wxmin,wymin,wxmax,wymax; /* in axis units the bounds of the graph */
GRAPHDEF double xbl,ybl;
GRAPHDEF double xlength,ylength;
GRAPHDEF double g_xsize,g_ysize,g_hscale,g_vscale,g_fontsz;
GRAPHDEF double last_vecx,last_vecy;
GRAPHDEF int ndata,g_nobox,g_center,done_line;
GRAPHDEF bool g_math;
GRAPHDEF double sizex,sizey;
GRAPHDEF double vscale,hscale;
/*GRAPHDEF int g_ynegate; */
GRAPHDEF int data_negate[3];		/* a.r. */

GRAPHDEF struct fill_data *fd[20];
GRAPHDEF int nfd;
GRAPHDEF int gntmp;

GRAPHDEF struct data_struct *dp[101];
GRAPHDEF struct data_struct *dpp;

GRAPHDEF bar_struct *br[20];
void vinit_axis(int i);
void vinit_title_axis();
void draw_bar(double x, double yf, double yt, double wd, bar_struct* barset, int di, int b) throw(ParserError);
void draw_user_function_calls(bool underneath) throw(ParserError);
void get_dataset_ranges();
void set_bar_axis_places();

#define DP_CAST (struct data_struct*)
#define BR_CAST (struct bar_struct*)
#define AX_CAST (axis_struct*)
#define FD_CAST (struct fill_data*)

class GLEColorMap {
public:
	string m_function;
	string m_palette;
	int m_wd, m_hi;
	bool m_color;
	double m_xmin, m_xmax;
	double m_ymin, m_ymax;
	double m_zmin, m_zmax;
	bool m_has_zmin;
	bool m_has_zmax;
	bool m_invert;
	bool m_haspal;
public:
	GLEColorMap();
	void draw(double wd, double hi);
	void setXRange(double min, double max);
	void setYRange(double min, double max);
	void setZMin(double val);
	void setZMax(double val);
	void setPalette(const string& pal);
	inline bool hasZMin() { return m_has_zmin; }
	inline bool hasZMax() { return m_has_zmax; }
	inline double getZMin() { return m_zmin; }
	inline double getZMax() { return m_zmax; }
	inline void setFunction(const char* f) { m_function = f; }
	inline void setWidth(int wd) { m_wd = wd; }
	inline void setHeight(int hi) { m_hi = hi; }
	inline const string& getFunction() { return m_function; }
	inline int getWidth() { return m_wd; }
	inline int getHeight() { return m_hi; }
	inline double getXMin() { return m_xmin; }
	inline double getXMax() { return m_xmax; }
	inline double getYMin() { return m_ymin; }
	inline double getYMax() { return m_ymax; }
	inline bool isColor() { return m_color; }
	inline void setColor(bool color) { m_color = color; }
	inline void setInvert(bool inv) { m_invert = inv; }
	inline bool isInverted() { return m_invert; }
	inline bool hasPalette() { return m_haspal; }
	inline const string& getPaletteFunction() { return m_palette; }
};
