
#include "all.h"
#include "tokens/Tokenizer.h"
#include "SourceLine.h"
#include "mem_limits.h"
#include "token.h"
#include "SourceLine.h"
#include "glearray.h"
#include "polish.h"
#include "pass.h"
#include "key.h"
#include "mygraph.h"
#include "justify.h"
#include "color.h"
#include "core.h"
#include "gprint.h"
#include "cutils.h"
#include "op_def.h"

/* for key command and gx(), gy() */
extern double graph_x1,graph_y1,graph_x2,graph_y2;  /* in cm */
extern double graph_xmin,graph_ymin,graph_xmax,graph_ymax; /* graph units */

#define BEGINDEF extern
#include "begin.h"
#include <math.h>
#define dbg if ((gle_debug & 64)>0)
#define LARGE_NUM 1E30

char *un_quote(char *ct);
extern int gle_debug;
void doskip(char *s,int *ct);
double get_next_exp(TOKENS tk,int ntk,int *curtok);

#define kw(ss) if (str_i_equals(tk[ct],ss))
#define true (!false)
#define false 0
#define skipspace doskip(tk[ct],&ct)
#define tok(n)  (*tk)[n]
#define next_exp (get_next_exp(tk,ntk,&ct))
#define next_font ((ct+=1),pass_font(tk[ct]))
#define next_marker ((ct+=1),pass_marker(tk[ct]))
#define next_color ((ct+=1),pass_color_var(tk[ct]))
#define next_fill ((ct+=1),pass_color_var(tk[ct]))
#define next_str(s)  (ct+=1,strcpy(s,tk[ct]))
#define next_vstr(s)  (ct+=1,mystrcpy(&s,tk[ct]))
#define next_vquote(s) (ct+=1,mystrcpy(&s,un_quote(tk[ct])))
#define next_quote(s) (ct+=1,strcpy(&s,un_quote(tk[ct])))
#define next_vquote_cpp(s) (ct+=1,skipspace,pass_file_name(tk[ct],s))

#define KEY_FILL_HEI_FY 0.66
#define KEY_FILL_HEI_FX 0.7

key_struct *kd[100];

void begin_key(int *pln, int *pcode, int *cp) throw(ParserError) {
    int nkd=0;
    double khei=0,zzhei;
    char kpos[34];
    int st;
    int ct;
    int col = 0;
    bool has_error = false;
    KeyInfo info;
    g_get_hei(&zzhei);
    (*pln)++;
    begin_init();
    for (;;) {
		st = begin_token(&pcode,cp,pln,srclin,tk,&ntk,outbuff);
		if (!st) {
			/* exit loop */
			break;
		}
		/* line count variable*/
		ct = 1;
		while (ct<=ntk) {
			skipspace;
			kw("OFFSET") {
				info.setOffsetX(next_exp);
				info.setOffsetY(next_exp);
			}
			else kw("MARGINS") {
				double mx = next_exp;
				double my = next_exp;
				info.setMarginXY(mx, my);
			}
			else kw("ABSOLUTE") {
				if (ct <= ntk-1) {
					info.setOffsetX(next_exp);
					info.setOffsetY(next_exp);
				}
				info.setAbsolute(true);
			}
			else kw("ROW") info.setBase(next_exp);
			else kw("LPOS") info.setLinePos(next_exp);
			else kw("LLEN") info.setLineLen(next_exp);
			else kw("NOBOX") info.setNoBox(true);
			else kw("HEI") khei = next_exp;
			else kw("POSITION") next_str(info.getJustify());
			else kw("POS") next_str(info.getJustify());
			else kw("SEPARATOR") {
				if (nkd == 0) {
					g_throw_parser_error("key: 'separator' should come after a valid key entry");
					has_error = true;
				} else {
					ct++;
					kw("LSTYLE") {
						kd[nkd]->sepstyle = (int)floor(next_exp + 0.5);
					} else {
						ct--;
					}
					col++;
				}
			}
			else kw("JUSTIFY") {
				next_str(info.getJustify());
				info.setPosOrJust(false);
			}
			else kw("JUST") {
				next_str(info.getJustify());
				info.setPosOrJust(false);
			}
			else kw("DIST") info.setDist(next_exp);
			else kw("COLDIST") info.setColDist(next_exp);
			else {
				if (ct==1) {
					nkd++;
					kd[nkd] = new key_struct(col);
				}
				if (nkd==0) return;
				kw("TEXT") {
					next_vquote_cpp(kd[nkd]->descrip);
					if (g_get_tex_labels()) {
						kd[nkd]->descrip.insert(0, "\\tex{");
						kd[nkd]->descrip.append("}");
					}
				}
				else kw("MARKER") {
					kd[nkd]->marker = next_marker;
				}
				else kw("MSIZE") kd[nkd]->msize = next_exp;
				else kw("MSCALE") kd[nkd]->msize = (next_exp) * zzhei;
				else kw("COLOR") kd[nkd]->color = next_color;
				else kw("FILL") kd[nkd]->fill = next_fill;
				else kw("PATTERN") kd[nkd]->pattern = next_fill;
				else kw("LSTYLE") next_str(kd[nkd]->lstyle);
				else kw("LINE") strcpy(kd[nkd]->lstyle,"1");
				else kw("LWIDTH") kd[nkd]->lwidth = next_exp;
				else g_throw_parser_error("unrecognised KEY sub command: '",tk[ct],"'");
			}
			ct++;
		}
    }
    if (!has_error) {
	info.setHei(khei);
	draw_key(nkd, &info);
    }
}

KeyRCInfo::KeyRCInfo() {
	size = 0.0;
	offs = 0.0;
	descent = 0.0;
	elems = 0;
	mleft = 0.0;
	mright = 0.0;
	m_Line = false;
	m_Marker = false;
	m_Fill = false;
}

KeyRCInfo::KeyRCInfo(const KeyRCInfo& other) {
	size = other.size;
	offs = other.offs;
	descent = other.descent;
	elems = other.elems;
	mleft = other.mleft;
	mright = other.mright;
	m_Line = other.m_Line;
	m_Marker = other.m_Marker;
	m_Fill = other.m_Fill;
}

KeyInfo::KeyInfo() {
	m_MaxRow = 0;
	m_NoBox = false;
	m_Fill = false;
	m_MarginX = -1e30;
	m_MarginY = -1e30;
	m_Hei = 0.0;
	m_Base = 0.0;
	m_TotHei = 0.0;
	m_ColDist = -1e30;
	m_Dist = -1e30;
	m_LinePos = -1e30;
	m_LineLen = -1e30;
	m_OffsX = 0.0;
	m_OffsY = 0.0;
	m_PosOrJust = true;
	m_Absolute = false;
	m_HasOffset = false;
	strcpy(m_Justify, "");
}

void KeyInfo::setOffsetX(double x) {
	m_OffsX = x;
	m_HasOffset = true;
}

void KeyInfo::setOffsetY(double y) {
	m_OffsY = y;
	m_HasOffset = true;
}

void KeyInfo::initPosition() {
	if (m_Justify[0] == 0) {
		// no justify or position given
		if (hasOffset()) {
			strcpy(m_Justify, "BL");
			setPosOrJust(false);
		} else {
			strcpy(m_Justify, "BR");
			setPosOrJust(true);
		}
	}
}

KeyRCInfo* KeyInfo::expandToCol(int col) {
	while (m_ColInfo.size() <= col) {
		m_ColInfo.push_back(KeyRCInfo());
	}
	return &m_ColInfo[col];
}

void KeyInfo::expandToRow(int row) {
	while (m_RowInfo.size() <= row) {
		m_RowInfo.push_back(KeyRCInfo());
	}
}

void draw_key(int nkd, KeyInfo* info) {
	int i;
	int old_color;
	double ox,oy,bl,br,bu,bd,savex,savey;
	double midx,midy,save_hei;
	/* Initialize */
	info->initPosition();
	g_get_hei(&save_hei);
	g_get_xy(&savex, &savey);
	g_get_color(&old_color);
	if (nkd == 0) return;
	if (!info->hasHei()) {
		info->setHei(save_hei);
	}
	double khei = info->getHei();
	if (!info->hasBase()) {
		info->setBase(1.2*khei);
	}
	double rowhi = info->getBase();
	info->setDefaultColor(old_color);
	/* Init margins */
	double margin_x = 0.45*rowhi;
	double margin_y = 0.45*rowhi;
	if (info->hasMargins()) {
		margin_x = info->getMarginX();
		margin_y = info->getMarginY();
	}
	if (!info->hasColDist()) {
		info->setColDist(margin_x);
	}
	if (!info->hasDist()) {
		info->setDist(margin_x * 0.85);
	}
	if (!info->hasLineLen()) {
		info->setLineLen(1.5*rowhi);
	}
	/* Use fill somewhere? */
	for (i = 1; i <= nkd; i++) {
		if (kd[i]->fill != 0) info->setHasFill(true);
	}
	/* Use dummy device for measurements */
	GLEDevice* old_device = g_set_dummy_device();
	/* Measure all labels and count rows in each column */
	g_set_hei(khei);
	double linePos = 1e30;
	for (i = 1; i <= nkd; i++) {
		int col = kd[i]->column;
		KeyRCInfo* colinfo = info->expandToCol(col);
		int row = colinfo->elems;
		info->expandToRow(row);
		if (kd[i]->descrip != "") {
			g_measure(kd[i]->descrip,&bl,&br,&bu,&bd);
			if (colinfo->size < br) colinfo->size = br;
			if (-bd > info->getRow(row)->descent) info->getRow(row)->descent = -bd;
			// size should not include descent, only ascent of the text
			if (bu > info->getRow(row)->size) info->getRow(row)->size = bu;
			// cout << "key = " << kd[i]->descrip << " bl = " << bl << " br = " << br << " bu = " << bu << " bd = " << bd << endl;
			if (bu/2 < linePos) linePos = bu/2;
		}
		/* Set booleans: kl = lstyle, km = marker, kf = fill */
		if (kd[i]->lstyle[0] == 0 && kd[i]->lwidth > 0) kd[i]->lstyle[0]='1';
		if (kd[i]->lstyle[0] != 0) colinfo->setHasLine(true);
		if (kd[i]->lwidth > 0) colinfo->setHasLine(true);
		if (kd[i]->marker != 0) colinfo->setHasMarker(true);
		if (kd[i]->fill != 0) colinfo->setHasFill(true);
		/* Adjust row height in case of fill */
		if (info->hasFill()) {
			if (rowhi*KEY_FILL_HEI_FY > info->getRow(row)->size) {
				// Row should have at least the height of the fill box
				info->getRow(row)->size = rowhi*KEY_FILL_HEI_FY;
			}
		}
		if (kd[i]->marker != 0) {
			double z = kd[i]->msize;
			if (z == 0) z = khei;
			GLEMeasureBox marksize;
			marksize.measureStart();
			g_move(0.0, 0.0);
			g_marker(kd[i]->marker,z);
			marksize.measureEnd();
			// cout << "m - size: " << z << endl;
			// cout << "x1 " << marksize.getX1() << endl;
			// cout << "x2 " << marksize.getX2() << endl;
			// cout << "y1 " << marksize.getY1() << endl;
			// cout << "y2 " << marksize.getY2() << endl;
			if (info->getCol(col)->mleft < -marksize.getX1()) info->getCol(col)->mleft = -marksize.getX1();
			if (info->getCol(col)->mright < marksize.getX2()) info->getCol(col)->mright = marksize.getX2();
		}
		info->getCol(col)->elems++;
	}
	/* Set linePos based to half of the fill block */
	if (info->hasFill()) {
		linePos = rowhi*KEY_FILL_HEI_FY/2;
	}
	if (!info->hasLinePos()) {
		info->setLinePos(linePos);
	}
	/* Add separator dist */
	for (i = 1; i <= nkd; i++) {
		info->getCol(kd[i]->column)->size += kd[i]->sepdist;
	}
	/* Compute sum of column widths and max number of rows */
	int maxrow = 0;
	double sumwid = 0.0;
	for (i = 0; i < info->getNbCols(); i++) {
		sumwid += info->getCol(i)->size;
		if (info->getCol(i)->elems > maxrow) maxrow = info->getCol(i)->elems;
	}
	info->setMaxRow(maxrow);
	/* Initialize offsets for each column */
	info->getCol(0)->offs = 0.0;
	for (i = 1; i < info->getNbCols(); i++) {
		double entry_wd = 0.0;
		KeyRCInfo* prev_col = info->getCol(i-1);
		if (prev_col->hasLine()) entry_wd += info->getLineLen() + info->getDist();
		if (prev_col->hasMarker()) entry_wd += info->getDist();
		if (prev_col->hasFill()) entry_wd += KEY_FILL_HEI_FX*rowhi + info->getDist();
		info->getCol(i)->offs = prev_col->offs + prev_col->size + entry_wd + info->getColDist() +
		                        prev_col->mleft + prev_col->mright;
	}
	/* Initialize offsets for each row */
	double rowoffs = 0.0;
	for (i = info->getNbRows()-2; i >= 0; i--) {
		double prev_rowhi = info->getRow(i)->descent * 1.3 + info->getRow(i+1)->size * 1.1;
		if (rowhi > prev_rowhi) prev_rowhi = rowhi;
		rowoffs += prev_rowhi;
		info->getRow(i)->offs = rowoffs;
	}
	/* Measure entire key */
	GLEMeasureBox measure;
	measure.measureStart();
	do_draw_key(0.0, 0.0, nkd, true, info);
	measure.measureEnd();
	g_restore_device(old_device);
	double extra_y = 0.0;
	double sx = measure.getWidth()+2*margin_x;
	double sy = measure.getHeight()+2*margin_y;
	info->setTotalHei(sy);
	// Make sure text does not go out of box
	double b_descent = info->getRow(info->getNbRows()-1)->descent;
	if (b_descent * 1.3 > margin_y) {
		extra_y = b_descent * 1.3 - margin_y;
		sy += extra_y;
	}
	double dx = info->getOffsetX();
	double dy = info->getOffsetY();
	if (info->isPosOrJust()) {
		/* Relative to graph */
		midx = graph_x1 + (graph_x2-graph_x1)/2;
		midy = graph_y1 + (graph_y2-graph_y1)/2;
		if (str_i_equals(info->getJustify(),"TL"))      { ox = graph_x1+dx;    oy = graph_y2-sy-dy; }
		else if (str_i_equals(info->getJustify(),"BL")) { ox = graph_x1+dx;    oy = graph_y1+dy;    }
		else if (str_i_equals(info->getJustify(),"BR")) { ox = graph_x2-sx-dx; oy = graph_y1+dy;    }
		else if (str_i_equals(info->getJustify(),"TR")) { ox = graph_x2-sx-dx; oy = graph_y2-sy-dy; }
		else if (str_i_equals(info->getJustify(),"TC")) { ox = midx-sx/2+dx;   oy = graph_y2-sy-dy; }
		else if (str_i_equals(info->getJustify(),"BC")) { ox = midx-sx/2+dx;   oy = graph_y1+dy;    }
		else if (str_i_equals(info->getJustify(),"RC")) { ox = graph_x2-sx-dx; oy = midy-sy/2+dy;   }
		else if (str_i_equals(info->getJustify(),"LC")) { ox = graph_x1+dx;    oy = midy-sy/2+dy;   }
		else if (str_i_equals(info->getJustify(),"CC")) { ox = midx-sx/2+dx;   oy = midy-sy/2+dy;   }
		else {
			if (strlen(info->getJustify())>0) gprint("Expecting POS BL,BR,TR or TL\n");
			ox = graph_x2-sx; oy = graph_y2-sy;
		}
	} else {
		ox = dx; oy = dy;
		if (!info->isAbsolute()) {
			ox += savex;
			oy += savey;
		}
		/* Support different relative positions for offset command */
		if (str_i_equals(info->getJustify(),"TL"))      { oy -= sy;               }
		else if (str_i_equals(info->getJustify(),"BR")) { ox -= sx;               }
		else if (str_i_equals(info->getJustify(),"TR")) { ox -= sx;   oy -= sy;   }
		else if (str_i_equals(info->getJustify(),"TC")) { ox -= sx/2; oy -= sy;   }
		else if (str_i_equals(info->getJustify(),"BC")) { ox -= sx/2;             }
		else if (str_i_equals(info->getJustify(),"RC")) { ox -= sx;   oy -= sy/2; }
		else if (str_i_equals(info->getJustify(),"LC")) { oy -= sy/2;             }
		else if (str_i_equals(info->getJustify(),"CC")) { ox -= sx/2; oy -= sy/2; }
	}
	g_set_fill(COLOR_WHITE);
	if (!info->getNoBox()) g_box_fill(ox,oy,ox+sx,oy+sy);
	g_set_color(old_color);
	double xoffs = margin_x-measure.getX1();
	do_draw_key(ox+xoffs, oy+margin_y-measure.getY1()+extra_y, nkd, false, info);
	int prev_col = 0;
	for (int i = 1; i <= nkd; i++) {
		if (prev_col != kd[i]->column) {
			prev_col = kd[i]->column;
			if (i > 1 && kd[i-1]->sepstyle != -1) {
				char msep[9];
				// should implement g_set_line_style that takes int
				sprintf(msep, "%d", kd[i-1]->sepstyle);
				g_set_line_style(msep);
				double xsep = ox+xoffs+info->getCol(prev_col)->offs-info->getColDist()/2;
				g_move(xsep, oy);
				g_line(xsep, oy+sy);
				g_set_line_style("1");
			}
		}
	}
	if (!info->getNoBox()) g_box_stroke(ox,oy,ox+sx,oy+sy);
	g_move(savex,savey);
	g_set_hei(save_hei);
}

void do_draw_key(double ox, double oy, int nkd, bool notxt, KeyInfo* info) {
	double savelw;
	double cx, cy, z;
	/* Draw all labels */
	int row = 0;
	int prev_col = 0;
	double khei = info->getHei();
	double rowhi = info->getBase();
	for (int i = 1; i <= nkd; i++) {
		if (prev_col != kd[i]->column) {
			row = 0;
			prev_col = kd[i]->column;
		}
		KeyRCInfo* col_info = info->getCol(prev_col);
		cx = ox+col_info->offs;
		cy = oy+info->getRow(row)->offs;
		g_move(cx, cy);
		g_set_bounds(cx, cy);
		if (kd[i]->color!=0) g_set_color(kd[i]->color);
		if (col_info->hasMarker()) {
			g_rmove(col_info->mleft, info->getLinePos());
			z = kd[i]->msize;
			if (z == 0) z = khei;
			// cout << "size: " << z << endl;
			if (kd[i]->marker!=0) g_marker(kd[i]->marker,z);
			g_rmove(col_info->mright+info->getDist(),-info->getLinePos());
		}
		if (col_info->hasLine()) {
			g_set_line_style(kd[i]->lstyle);
			g_get_line_width(&savelw);
			g_set_line_width(kd[i]->lwidth);
			g_rmove(0.0,info->getLinePos());
			if (kd[i]->lstyle[0]==0) g_rmove(info->getLineLen(),0.0);
			else g_rline(info->getLineLen(),0.0);
			g_rmove(info->getDist(),-info->getLinePos());
			g_set_line_style("1");
			g_set_line_width(savelw);
		}
		if (col_info->hasFill()) {
			if (kd[i]->fill!=0) {
				if (kd[i]->pattern != -1 && kd[i]->pattern != GLE_FILL_CLEAR) {
					g_set_fill(kd[i]->pattern);
					g_set_pattern_color(kd[i]->fill);
				} else {
					g_set_fill(kd[i]->fill);
					g_set_pattern_color(GLE_COLOR_BLACK);
				}
				g_get_xy(&cx,&cy);
				g_box_fill(cx,cy,cx+rowhi*KEY_FILL_HEI_FX, cy+rowhi*KEY_FILL_HEI_FY);
				g_box_stroke(cx,cy,cx+rowhi*KEY_FILL_HEI_FX, cy+rowhi*KEY_FILL_HEI_FY);
			}
			g_rmove(KEY_FILL_HEI_FX*rowhi + info->getDist(), 0.0);
		}
		g_get_xy(&cx,&cy);
		if (kd[i]->color!=0) g_set_color(info->getDefaultColor());
		if (!notxt) {
			g_set_just(JUST_LEFT);
			if (kd[i]->descrip != "") g_text((char*)kd[i]->descrip.c_str());
		} else {
			g_set_bounds(cx+col_info->size, cy+info->getRow(row)->size);
		}
		row++;
	}
}

key_struct::key_struct(int col) {
	column = col;
	sepstyle = -1;
	sepdist = 0.0;
	pattern = -1;
	lstyle[0] = 0;
	lwidth = 0.0;
	color = 0; fill = 0;
	marker = 0; msize = 0.0;
}

key_struct::~key_struct() {
}
