
#include "all.h"
#include "SourceLine.h"
#include "tokens/Tokenizer.h"
#include "mygraph.h"
#include "cutils.h"
#include "gprint.h"
#include "var.h"
#include "name.h"

void swap_minmax(double *x1, double *y1, double *x2, double *y2);

typedef struct {
	double x1,y1,x2,y2;
	char *name;
	int srclin1, srclin2;
	GLELocalVars* vars;
	GLEVarMap* var_map;
} Aname;

static Aname *names = NULL;
static int nnam = 0, maxnam = 0;

void name_clear() {
	nnam = 0;
	maxnam = 0;
	if (names != NULL) {
		myfree(names);
		names = NULL;
	}
}

int name_add(void) {
	Aname *newname;
	if (nnam>=maxnam) {
		maxnam+=20;
		newname =(Aname*) myallocz(sizeof(Aname)*maxnam);
		if (names!=NULL) {
			memcpy(newname,names,sizeof(Aname)*nnam);
			myfree(names);
		}
		names = newname;
	}
	return nnam++;
}

void name_show_all() {
	cout << "============" << endl;
	for (int i = 0; i < nnam; i++) {
		cout << names[i].name << " x1 = ";
		cout << names[i].x1 << " x2 = ";
		cout << names[i].x2 << " y1 = ";
		cout << names[i].y1 << " y2 = ";
		cout << names[i].y2 << endl;
	}
	cout << "============" << endl;
}

int name_set(char *n,double x1,double y1,double x2,double y2) {
	double xx1,yy1,xx2,yy2;
	int i;
	for (i=0;i<nnam;i++) if (str_i_equals(n,names[i].name)) break;
	if (i>=nnam) {
		i = name_add();
		names[i].name = sdup(n);
	} else {
		if (names[i].vars != NULL) delete names[i].vars;
	}
	g_dev(x1,y1,&xx1,&yy1);
	g_dev(x2,y2,&xx2,&yy2);
	swap_minmax(&xx1, &yy1, &xx2, &yy2);
	names[i].x1= xx1;
	names[i].y1 = yy1;
	names[i].x2= xx2;
	names[i].y2= yy2;
	names[i].srclin1 = -1;
	names[i].srclin2 = -1;
	names[i].vars = NULL;
	names[i].var_map = NULL;
	return i;
}

void name_set_vars(int name, GLELocalVars* vars, GLEVarMap* varmap) {
	names[name].vars = vars;
	names[name].var_map = varmap;
}

GLELocalVars* name_get_vars(int name) {
	return names[name].vars;
}

GLEVarMap* name_get_varmap(int name) {
	return names[name].var_map;
}

void name_set_start_end(int name, int srclin1, int srclin2) {
	names[name].srclin1 = srclin1;
	names[name].srclin2 = srclin2;
}

int name_get_start(int name) {
	return names[name].srclin1;
}

int name_get_end(int name) {
	return names[name].srclin2;
}

void swap_minmax(double *x1, double *y1, double *x2, double *y2) {
	double a;
	if (*x1 > *x2) { a = *x1; *x1 = *x2; *x2 = a;}
	if (*y1 > *y2) { a = *y1; *y1 = *y2; *y2 = a;}
}

void name_show() {
	int i;
	for (i=0;i<nnam;i++) {
		gprint("Name %d {%s} \n",i,names[i].name);
	}
}

int name_get_int(char *n,double *x1,double *y1,double *x2,double *y2) throw(ParserError) {
	int i;
	double xx1,yy1,xx2,yy2;
	for (i=0;i<nnam;i++) {
		if (str_i_equals(n,names[i].name)) break;
	}
	if (i >= nnam) {
		g_throw_parser_error(string("Name not defined: '")+n+"'");
	}
	g_undev(names[i].x1,names[i].y1,&xx1,&yy1);
	g_undev(names[i].x2,names[i].y2,&xx2,&yy2);
	swap_minmax(&xx1, &yy1, &xx2, &yy2);
	*x1 = xx1;
	*y1 = yy1;
	*x2 = xx2;
	*y2 = yy2;
	return i;
}

bool name_get(char *n,double *x1,double *y1,double *x2,double *y2) throw(ParserError) {
	name_get_int(n, x1, y1, x2, y2);
	return true;
}
