
#ifndef CHARBITMAP
#define CHARBITMAP

#define CharBitMapSize 8
#define CharBitMapIntIndexSize 5
#define CharBitMapIntIndexMask 31

class CharBitMap {
 private:
  typedef unsigned char uchar;
  int map[CharBitMapSize];
  inline int thebit(char c) const;
  inline int index(char c) const;
 public:
  inline void reset(char c);
  inline void set(char c);
  inline int get(char c) const;
  inline void set(const char *cset);
  inline void reset(const char *cset);
  inline void clear();
  inline void setall();
  inline CharBitMap();
  inline CharBitMap(const char *cset);
  };


inline int CharBitMap::index(char c) const {
  return ((uchar)c)>>CharBitMapIntIndexSize;
}
inline int CharBitMap::thebit(char c) const {
  return 1<<(c&CharBitMapIntIndexMask);
}
inline void CharBitMap::set(char c) {
  map[index(c)]|=thebit(c);
}
inline void CharBitMap::reset(char c) {
  map[index(c)]&=~thebit(c);
}
inline int CharBitMap::get(char c) const {
  return (map[index(c)]&thebit(c))!=0;
}
inline void CharBitMap::set(const char *cset) {
  while(*cset!=0)
    set(*(cset++));
}
inline void CharBitMap::reset(const char *cset) {
  while(*cset!=0)
    reset(*(cset++));
}
inline void CharBitMap::clear() {
  for(int i=0;i<CharBitMapSize;i++) map[i]=0;
}
inline void CharBitMap::setall() {
  for(int i=0;i<CharBitMapSize;i++) map[i]=~0;
}
inline CharBitMap::CharBitMap() {
  clear();
}
inline CharBitMap::CharBitMap(const char *cset) {
  clear();set(cset);
}
#endif
