
/*
 * 2004 Jan Struyf
 *
 * ASCII85 Encoding Support.
 *
 */

#include "../basicconf.h"
#include "img2ps.h"

#define PS_MAXLINE 36

static char* Ascii85Encode(unsigned char* raw) {
	static char encoded[6];
	unsigned int word = (((raw[0]<<8)+raw[1])<<16) + (raw[2]<<8) + raw[3];
	if (word != 0L) {
		unsigned int q;
		unsigned int w1;

		q = word / (85L*85*85*85);	/* actually only a byte */
		encoded[0] = q + '!';

		word -= q * (85L*85*85*85); q = word / (85L*85*85);
		encoded[1] = q + '!';

		word -= q * (85L*85*85); q = word / (85*85);
		encoded[2] = q + '!';

		w1 = (unsigned int) ((word - q*(85L*85)) & 0xFFFF);
		encoded[3] = (w1 / 85) + '!';
		encoded[4] = (w1 % 85) + '!';
		encoded[5] = '\0';
	} else {
		encoded[0] = 'z', encoded[1] = '\0';
	}
	return encoded;
}

GLEASCII85ByteStream::GLEASCII85ByteStream(FILE* file) {
	m_File = file;
	m_BreakLength = 2*PS_MAXLINE;
	m_Count = 0;
}

int GLEASCII85ByteStream::sendByte(unsigned char code) {
	m_Buffer[m_Count++] = code;
	if (m_Count >= 4) {
		int n;
		unsigned char* p;
		for (n = m_Count, p = m_Buffer; n >= 4; n -= 4, p += 4) {
			char* cp;
			for (cp = Ascii85Encode(p); *cp; cp++) {
				putc(*cp, m_File);
				if (--m_BreakLength == 0) {
					putc('\n', m_File);
					m_BreakLength = 2*PS_MAXLINE;
				}
			}
		}
		for (int i = 0; i < n; i++) {
			m_Buffer[i] = p[i];
		}
		m_Count = n;
	}
	return GLE_IMAGE_ERROR_NONE;
}

int GLEASCII85ByteStream::term() {
	if (!isTerminated()) {
		if (m_Count > 0) {
			char* res;
			for (int i = 0; i < 3; i++) {
				m_Buffer[m_Count+i] = 0;
			}
			res = Ascii85Encode(m_Buffer);
			fwrite(res[0] == 'z' ? "!!!!" : res, m_Count + 1, 1, m_File);
		}
		fputs("~>\n", m_File);
	}
	return GLEByteStream::term();
}

GLEASCII85ByteStream::~GLEASCII85ByteStream() {
}
