#ifndef INC_COLOR_H
#define INC_COLOR_H

#define COLOR_CLEAR 0XFF000000
#define COLOR_BLACK 0X01000000
#define COLOR_WHITE 0X01FFFFFF
#define COLOR_RED   0X01FF0000
#define COLOR_GREEN 0X0100FF00
#define COLOR_BLUE  0X010000FF
#define COLOR_GREY  0X017F7F7F

typedef union {
	int l;
	unsigned char b[4];
} colortyp;

typedef struct {
	double red, green, blue;
} rgb01;

#ifdef WORDS_BIGENDIAN
	#define B_F 0
	#define B_R 1
	#define B_G 2
	#define B_B 3
#else
	#define B_F 3
	#define B_R 2
	#define B_G 1
	#define B_B 0
#endif

#endif
