#ifndef INC_CORE_H
#define INC_CORE_H

#include "color.h"
#include "d_interface.h"

#define GLE_DEVICE_NONE   -1
#define GLE_DEVICE_EPS     0
#define GLE_DEVICE_PS      1
#define GLE_DEVICE_PDF     2
#define GLE_DEVICE_SVG     3
#define GLE_DEVICE_JPEG    4
#define GLE_DEVICE_PNG     5
#define GLE_DEVICE_X11     6
#define GLE_DEVICE_DUMMY   7

#define GLE_PAPER_UNKNOWN  0
#define GLE_PAPER_A0       1
#define GLE_PAPER_A1       2
#define GLE_PAPER_A2       3
#define GLE_PAPER_A3       4
#define GLE_PAPER_A4       5
#define GLE_PAPER_LETTER   6

#define PDF_IMG_COMPR_AUTO 0
#define PDF_IMG_COMPR_ZIP  1
#define PDF_IMG_COMPR_JPEG 2
#define PDF_IMG_COMPR_PS   3

#define GLE_COMPAT_35      0
#define GLE_COMPAT_40      1

#define GLEC_MAX_INT       1
#define GLEC_COMPATIBILITY 0

#define GLEC_MAX_DOUBLE    6
#define GLEC_TITLESCALE    0
#define GLEC_ATITLESCALE   1
#define GLEC_ALABELSCALE   2
#define GLEC_TICKSSCALE    3
#define GLEC_ATITLEDIST    4
#define GLEC_ALABELDIST    5

#define GLE_ARRSTY_SIMPLE 0
#define GLE_ARRSTY_FILLED 1
#define GLE_ARRSTY_EMPTY  2
#define GLE_ARRSTY_SUB    10

class GLEBitmap;

struct gmodel {
	double image[3][3];
	double fontn,fontsz;	/* up to here for font caching */
	colortyp color,fill;
	double lwidth,lstyled,curx,cury;
	double endx,endy;
	double miterlimit;
	int lcap,ljoin;
	int just,xinline,npath; /* up to here for STATE */
	bool inpath;
	char lstyle [9];
	/* 18*8, 6*int, 2*int */
	double xmin,xmax,ymin,ymax;	 /* bounds in USER coordinates */
	double startx,starty;
	double closex,closey;	     /* for closepath */
	double arrowsize, arrowangle;
	double userwidth,userheight; /* The user req size */
	double pagewidth,pageheight;
	double topmargin, bottommargin;
	double leftmargin, rightmargin;
	int arrowstyle;
	bool texlabels;
	bool fullpage;
	bool landscape;
	int papersize;
	bool hasbox;
	bool isopen;
	int devtype;
	GLEDevice* dev;
	bool console_output;
	bool needs_newline;
	int pdfimgformat;
	int intconst[GLEC_MAX_INT];
	double floatconst[GLEC_MAX_DOUBLE];
};

class GLEMeasureBox {
protected:
	double n_x1, n_y1, n_x2, n_y2;
public:
	void measureStart();
	void measureEnd();
	inline double getX1() { return n_x1; }
	inline double getX2() { return n_x2; }
	inline double getY1() { return n_y1; }
	inline double getY2() { return n_y2; }
	inline double getXMid() { return (n_x1+n_x2)/2; }
	inline double getYMid() { return (n_y1+n_y2)/2; }
	inline double getWidth() { return n_x2 - n_x1; }
	inline double getHeight() { return n_y2 - n_y1; }
};

typedef struct {
	double xmin,xmax,ymin,ymax;
} gbox;

unsigned int coreleft();
unsigned int farcoreleft();

#define SIZEOFSTATE sizeof(gmodel)

void g_init();
void g_open(const string& outputfile, const string& inputfile);
void g_get_font(int *f);
//void g_close(void);
void g_defmarker(char *mname,char *font, int ccc, double dx, double dy, double sz, int autodx);
void g_get_hei(double *h);
//void g_gsave(void);
void g_hint(char *s);
void g_marker(int i, double sz);
void g_marker2(int i, double sz, double dval) throw (ParserError);
void g_set_hei(double h);
void gclip(double *x1,double *y1, double *x2, double *y2,double xmin, double ymin, double xmax, double ymax, int *invis);
void g_pscomment(char* ss);
void g_psbbtweak(void);
void g_message_first_newline(bool newline);
bool g_has_console_output();
void g_set_console_output(bool set);

//
// -- no need to ifdef these
// they will simply print warning message if libraries are not linked
//
void g_bitmap(string& fname, double wx, double wy, int type);
void g_bitmap_info(string& fname, int xvar, int yvar, int type);
int g_bitmap_string_to_type(const char* stype);

void g_ellipse_stroke(double rx, double ry);
void g_ellipse_fill(double rx, double ry);
void g_elliptical_arc(double rx,double ry,double t1,double t2,double cx,double cy,int marrow,int can_fillpath);
void g_elliptical_narc(double rx,double ry,double t1,double t2,double cx,double cy,int marrow,int can_fillpath);

void g_arrowsize(double *len, double *angle);
void g_arrowline(double x2, double y2, int flag, int can_fillpath) throw(ParserError);

void g_arrow(double dx, double dy) throw(ParserError);
void g_arrowpoints(double cx,double cy,double dx,double dy, double *ax1,
                   double *ay1,double *ax2,double *ay2, double *nnx, double *nny);
void g_psarrow(double x1, double y1, double x2, double y2, int flag);

void g_arc(double r,double t1,double t2,double cx,double cy,int marrow,int can_fillpath);
void g_narc(double r,double t1,double t2,double cx,double cy,int marrow,int can_fillpath);

void g_get_colortyp(colortyp *color);
void g_colortyp_to_rgb01(colortyp* c1, rgb01 *c2);
int g_is_black(colortyp *color);

bool g_is_bbtweak();
double g_get_angle_deg();

void g_select_device(int device);
GLEDevice* g_get_device_ptr();
GLEDevice* g_set_dummy_device();
void g_restore_device(GLEDevice* device);
int g_get_device();
bool g_is_dummy_device();
void g_resetfont();

void g_arrow(double dx, double dy, int can_fillpath) throw(ParserError);
void g_arrowcurve(double x, double y, int arrow, double a1, double a2, double d1, double d2, int can_fill);
void g_set_size(double width, double height, bool box);
int  g_papersize_type(const string& papersize);
void g_set_pagesize(int type);
void g_set_pagesize(double width, double height);
void g_set_margins(double top, double bottom, double left, double right);
void g_set_fullpage(bool fullpage);
void g_on_open();
bool g_is_fullpage();
void g_set_landscape(bool landscape);
bool g_is_landscape();
void g_set_arrow_size(double size);
void g_set_arrow_angle(double angle);
void g_set_pdf_image_format(const char* format);
int g_get_pdf_image_format();

int g_get_compatibility();
void g_set_compatibility(int compat);

void g_set_iconst(int i, int value);
void g_set_fconst(int i, double value);
int g_get_iconst(int i);
double g_get_fconst(int i);

void g_update_bounds_box(gbox* box);
void g_update_bounds_box_pt(gbox* box, double x, double y);
void g_init_bounds_box(gbox* box);
void g_get_bounds_box(gbox* box);
void g_set_bounds_box(gbox* box);
void g_restore_bounds(gbox* box);
void g_set_bounds(double x, double y, gmodel* model);
void g_debug_bounds();
void g_check_bounds(char* after);
bool g_has_box(gmodel* model);
void g_set_state(gmodel *s);
void g_get_state(gmodel *s);
void g_rset_pos(double x, double y);

void g_undev(double ux, double uy, double *x, double *y, gmodel* model);
void g_set_arrow_style(const char* shape) throw (ParserError);

void g_set_pattern_color(int color);
void g_bitmap(GLEBitmap*, double wx, double wy);

void g_set_tex_scale(const char* ss);
void g_set_tex_labels(bool onoff);
bool g_get_tex_labels();

void g_restore_defaults();

#endif
