
#ifndef _GLE_ARRAY_H_
#define _GLE_ARRAY_H_

class GLEObject : public RefCountObject {
public:
	GLEObject();
	virtual ~GLEObject();
	virtual int size();
	virtual double getDoubleAt(int i);
	virtual void setDoubleAt(double v, int i);
	virtual bool getBoolAt(int i);
	virtual void setBoolAt(bool v, int i);
	virtual GLEObject* getObjectAt(int i);
	virtual void setObjectAt(GLEObject* v, int i);
};

class GLEObjectArray : public GLEObject {
protected:
	RefCountVector<GLEObject> m_Elems;
public:
	GLEObjectArray();
	virtual ~GLEObjectArray();
	virtual int size();
	virtual GLEObject* getObjectAt(int i);
	virtual void setObjectAt(GLEObject* v, int i);
protected:
	void resize(int n);
};

class GLEDoubleArray : public GLEObject {
protected:
	vector<double> m_Elems;
public:
	GLEDoubleArray();
	virtual ~GLEDoubleArray();
	virtual int size();
	virtual double getDoubleAt(int i);
	virtual void setDoubleAt(double v, int i);
	double* toArray();
protected:
	void resize(int n);
};

class GLEBoolArray : public GLEObject {
protected:
	vector<bool> m_Elems;
public:
	GLEBoolArray();
	virtual ~GLEBoolArray();
	virtual int size();
	virtual bool getBoolAt(int i);
	virtual void setBoolAt(bool v, int i);
	int* toArray();
protected:
	void resize(int n);
};

#endif
