#ifndef INC_KEY_H
#define INC_KEY_H

class key_struct {
public:
	char lstyle[9];
	int color,fill,pattern;
	int marker;
	int column;
	double msize,lwidth;
	string descrip;
	int sepstyle;
	double sepdist;
public:
	key_struct(int col);
	~key_struct();
};

class KeyRCInfo {
public:
	double size;
	double offs;
	double descent;
	double mleft;
	double mright;
	int elems;
	bool m_Line, m_Marker, m_Fill;
public:
	KeyRCInfo();
	KeyRCInfo(const KeyRCInfo& other);
	inline bool hasLine() { return m_Line; }
	inline bool hasMarker() { return m_Marker; }
	inline bool hasFill() { return m_Fill; }
	inline void setHasLine(bool val) { m_Line = val; }
	inline void setHasMarker(bool val) { m_Marker = val; }
	inline void setHasFill(bool val) { m_Fill = val; }
};

class KeyInfo {
protected:
	int m_MaxRow, m_Color;
	vector<KeyRCInfo> m_ColInfo;
	vector<KeyRCInfo> m_RowInfo;
	double m_Hei, m_Base, m_LinePos, m_LineLen;
	double m_MarginX, m_MarginY, m_TotHei, m_ColDist, m_Dist;
	double m_OffsX, m_OffsY;
	bool m_PosOrJust, m_Absolute, m_HasOffset, m_NoBox, m_Fill;
	char m_Justify[34];
public:
	KeyInfo();
	KeyRCInfo* expandToCol(int col);
	void expandToRow(int row);
	void setOffsetX(double x);
	void setOffsetY(double y);
	void initPosition();
	inline bool hasFill() { return m_Fill; }
	inline void setHasFill(bool val) { m_Fill = val; }
	inline double getOffsetX() { return m_OffsX; }
	inline double getOffsetY() { return m_OffsY; }
	inline bool isPosOrJust() { return m_PosOrJust; }
	inline void setPosOrJust(bool pj) { m_PosOrJust = pj; }
	inline bool isAbsolute() { return m_Absolute; }
	inline void setAbsolute(bool abs) { m_Absolute = abs; }
	inline bool hasOffset() { return m_HasOffset; }
	inline char* getJustify() { return m_Justify; }
	inline int getMaxRow() { return m_MaxRow; }
	inline void setMaxRow(int row) { m_MaxRow = row; }
	inline KeyRCInfo* getCol(int i) { return &m_ColInfo[i]; }
	inline int getNbCols() { return m_ColInfo.size(); }
	inline KeyRCInfo* getRow(int i) { return &m_RowInfo[i]; }
	inline int getNbRows() { return m_RowInfo.size(); }
	inline int getDefaultColor() { return m_Color; }
	inline void setDefaultColor(int col) { m_Color = col; }
	inline double getHei() { return m_Hei; }
	inline bool hasHei() { return m_Hei != 0.0; }
	inline void setHei(double hei) { m_Hei = hei; }
	inline double getBase() { return m_Base; }
	inline bool hasBase() { return m_Base != 0.0; }
	inline void setBase(double base) { m_Base = base; }
	inline bool getNoBox() { return m_NoBox; }
	inline void setNoBox(bool nb) { m_NoBox = nb; }
	inline double getMarginX() { return m_MarginX; }
	inline double getMarginY() { return m_MarginY; }
	inline void setMarginXY(double mx, double my) { m_MarginX = mx; m_MarginY = my; }
	inline bool hasMargins() { return m_MarginX > -1e20; }
	inline double getTotalHei() { return m_TotHei; }
	inline void setTotalHei(double hei) { m_TotHei = hei; }
	inline double getColDist() { return m_ColDist; }
	inline void setColDist(double dist) { m_ColDist = dist; }
	inline bool hasColDist() { return m_ColDist > -1e20; }
	inline double getDist() { return m_Dist; }
	inline void setDist(double dist) { m_Dist = dist; }
	inline bool hasDist() { return m_Dist >= 0; }
	inline bool hasLinePos() { return m_LinePos >= 0; }
	inline double getLinePos() { return m_LinePos; }
	inline void setLinePos(double pos) { m_LinePos = pos; }
	inline bool hasLineLen() { return m_LineLen >= 0; }
	inline double getLineLen() { return m_LineLen; }
	inline void setLineLen(double Len) { m_LineLen = Len; }
};

void draw_key(int nkd, KeyInfo* info);

void do_draw_key(double ox, double oy, int nkd, bool notxt, KeyInfo* info);

#endif
