
#include "op_def.h"

/*--------------------------------------------------------------------------------------*/
/* Pos = Offset to find the data                                                        */
/* Idx = For switches, which can only have one value                                    */
/* The pos is the order the items will be placed in the pcode                           */
/*                                                                                      */
/* indexes (idx) for types                                                              */
/* ===================================================================================  */
/* typ_switch   Switches    LONG    Placed in directly, 1 present, 0 not present        */
/* expressions              LONG*   Pointed to, 0 if not present                        */
/* type_fill    color/fill  LONG*   Pointer to exp 0 if not present                     */
/* marker                   LONG*   Pointer to exp 0 if not present                     */
/* lstyle                   LONG*   Pointer to exp 0 if not present                     */
/* typ_str      font        int*    Pointer to string expression                        */
/*                                                                                      */
/*--------------------------------------------------------------------------------------*/

struct op_key op_box[] = {
		 "JUSTIFY", 	typ_justify, 	1, 0
		,"JUST", 	typ_justify, 	1, 0
		,"FILL", 	typ_fill, 	2, 0
		,"NOSTROKE", 	typ_switch, 	3, 1
		,"NOBORDER", 	typ_switch, 	3, 1
		,"NOBOX", 	typ_switch, 	3, 1
		,"REVERSE",	typ_switch,	4, 1
		,"ROUND",	typ_val, 	5, 0
		,"NAME", 	typ_str, 	6, 0
		,"END", 	typ_end, 	0, 0  };

struct op_key op_circle[] = {
		 "JUSTIFY", 	typ_justify, 	1, 0
		,"JUST", 	typ_justify, 	1, 0
		,"NOSTROKE", 	typ_switch, 	2, 1
		,"FILL", 	typ_fill, 	3, 0
		,"NAME", 	typ_str, 	4, 0
		,"END", 	typ_end, 	0, 0  };

struct op_key op_defmarker[] = {
		 "FONT", 	typ_str, 	1, 0
		,"CHAR", 	typ_str, 	2, 0
		,"DX", 		typ_val, 	3, 0
		,"DY", 		typ_val, 	4, 0
		,"END", 	typ_end, 	0, 0  };

struct op_key op_fill[] = {
		 "FILL", 	typ_fill, 	1, 0
		,"END", 	typ_end, 	0, 0  };

struct op_key op_for_step[] = {
		 "STEP", 	typ_val, 	1, 0
		,"END", 	typ_end, 	0, 0  };

struct op_key op_begin_text[] = {
		 "WIDTH", 	typ_val, 	1, 0
		,"DEPTH", 	typ_val, 	2, 0
		,"JUSTIFY", 	typ_justify, 	3, 0
		,"JUST", 	typ_justify, 	3, 0
		,"END", 	typ_end, 	0, 0  };

struct op_key op_justify[] = {
		 "LEFT", 	typ_switch, 	1, 0x100
		,"CENT", 	typ_switch, 	1, 0x110
		,"CENTER", 	typ_switch, 	1, 0x110
		,"CENTRE", 	typ_switch, 	1, 0x110
		,"RIGHT", 	typ_switch, 	1, 0x120
		,"LT",	 	typ_switch, 	1, 0x02
		,"TL",	 	typ_switch, 	1, 0x02
		,"CL",	 	typ_switch, 	1, 0x01
		,"LC",	 	typ_switch, 	1, 0x01
		,"BL",	 	typ_switch, 	1, 0x00
		,"LB",	 	typ_switch, 	1, 0x00
		,"CB",	 	typ_switch, 	1, 0x10
		,"BC",	 	typ_switch, 	1, 0x10
		,"RB",	 	typ_switch, 	1, 0x20
		,"BR",	 	typ_switch, 	1, 0x20
		,"CR",	 	typ_switch, 	1, 0x21
		,"RC",	 	typ_switch, 	1, 0x21
		,"TR",	 	typ_switch, 	1, 0x22
		,"RT",	 	typ_switch, 	1, 0x22
		,"TC",	 	typ_switch, 	1, 0x12
		,"CT",	 	typ_switch, 	1, 0x12
		,"CC",	 	typ_switch, 	1, 0x11
		,"CI",	 	typ_switch, 	1, 0x1011
		,"C",	 	typ_switch, 	1, 0x1011
		,"VI",	 	typ_switch, 	1, 0x2000
		,"V",	 	typ_switch, 	1, 0x2000
		,"HO",	 	typ_switch, 	1, 0x3000
		,"H",	 	typ_switch, 	1, 0x3000
		,"BOX",	 	typ_switch, 	1, 0x5011
		,"BO",	 	typ_switch, 	1, 0x5011
		,"END", 	typ_end, 	1, 1 };

struct op_key op_begin[] = {
		 "PATH", 	typ_switch, 	1, 1
		,"BOX", 	typ_switch, 	1, 2
		,"SCALE", 	typ_switch, 	1, 3
		,"ROTATE", 	typ_switch, 	1, 4
		,"TRANSLATE", 	typ_switch, 	1, 5
		,"ROT", 	typ_switch, 	1, 4
		,"TRAN", 	typ_switch, 	1, 5
		,"IF", 		typ_switch, 	1, 6
		,"SUB", 	typ_switch, 	1, 7
		,"NAME", 	typ_switch, 	1, 8
		,"TEXT", 	typ_switch, 	1, 9
		,"GRAPH", 	typ_switch, 	1, 10
		,"XAXIS", 	typ_switch, 	1, 11
		,"YAXIS", 	typ_switch, 	1, 12
		,"X2AXIS", 	typ_switch, 	1, 13
		,"Y2AXIS", 	typ_switch, 	1, 14
		,"CURVE",	typ_switch,	1, 15
		,"KEY",		typ_switch,	1, 16
		,"ORIGIN",	typ_switch,	1, 17
		,"TABLE",	typ_switch,	1, 18
		,"CLIP",	typ_switch,	1, 19
		,"UNTIL",	typ_switch,	1, 20
		,"SHEAR",	typ_switch,	1, 21
		,"CONFIG",      typ_switch,     1, 22
		,"TEXPREAMBLE", typ_switch,     1, 23
		,"SURFACE",     typ_switch,     1, 24
		,"LETZ",        typ_switch,     1, 25
		,"FITZ",        typ_switch,     1, 26
		,"FIT",         typ_switch,     1, 27 /* what previously fitls used to be */
		,"CONTOUR",     typ_switch,     1, 28
		,"TEX",         typ_switch,     1, 29
		,"OBJECT",      typ_switch,     1, OP_BEGIN_OBJECT
		,"END", 	typ_end, 	1, 1 };

struct op_key op_set[] = {
		 "HEI", 	typ_switch, 	1, 1
		,"FONT", 	typ_switch, 	1, 2
		,"JUSTIFY", 	typ_switch, 	1, 3
		,"JUST", 	typ_switch, 	1, 3
		,"COLOR", 	typ_switch, 	1, 4
		,"DASHLEN", 	typ_switch, 	1, 5
		,"DASH", 	typ_switch, 	1, 6
		,"LDIST", 	typ_switch, 	1, 5
		,"LSTYLE", 	typ_switch, 	1, 6
		,"LWIDTH", 	typ_switch, 	1, 7
		,"JOIN", 	typ_switch, 	1, 8
		,"CAP", 	typ_switch, 	1, 9
		,"FONTLWIDTH", 	typ_switch, 	1, 10
		,"TEXSCALE",    typ_switch, 	1, OP_SET_TEX_SCALE
		,"TEXLABELS",   typ_switch, 	1, OP_SET_TEX_LABELS
		,"ARROWSTYLE",  typ_switch, 	1, OP_SET_ARROW_STYLE
		,"ARROWSIZE",   typ_switch, 	1, OP_SET_ARROW_SIZE
		,"ARROWANGLE",  typ_switch, 	1, OP_SET_ARROW_ANGLE
		,"IMAGEFORMAT", typ_switch, 	1, OP_SET_IMAGE_FORMAT
		,"TITLESCALE",  typ_switch,     1, OP_SET_TITLE_SCALE
		,"ATITLESCALE", typ_switch,     1, OP_SET_ATITLE_SCALE
		,"ALABELSCALE", typ_switch,     1, OP_SET_ALABEL_SCALE
		,"TICKSSCALE",  typ_switch,     1, OP_SET_TICKS_SCALE
		,"ATITLEDIST",  typ_switch,     1, OP_SET_ATITLE_DIST
		,"ALABELDIST",  typ_switch,     1, OP_SET_ALABEL_DIST
		,"END", 	typ_end, 	1, 1 };

/* colors, fills,  First byte is pattern, then red,green,blue intensities*/
/* currently defined patterns are,  ff=clear, 1=black,  */
struct op_key op_color_typ[] = {
		"AQUA",	 typ_switch,	 1,	 0X0170DB93
		,"AQUAMARINE",	 typ_switch,	 1,	 0X0170DB93
		,"BAKERS_CHOCOLATE",	 typ_switch,	 1,	 0X015C3317
		,"BLACK",	 typ_switch,	 1,	 GLE_COLOR_BLACK
		,"BLUE",	 typ_switch,	 1,	 0X010000FF
		,"BLUE_VIOLET",	 typ_switch,	 1,	 0X019F5F9F
		,"BRASS",	 typ_switch,	 1,	 0X01B5A642
		,"BRIGHT_GOLD",	 typ_switch,	 1,	 0X01D9D919
		,"BRONZE",	 typ_switch,	 1,	 0X018C7853
		,"BRONZE_II",	 typ_switch,	 1,	 0X01A67D3D
		,"BROWN",	 typ_switch,	 1,	 0X01A52A2A
		,"BROWN_WEB",	 typ_switch,	 1,	 0X01A62A2A
		,"CADET_BLUE",	 typ_switch,	 1,	 0X015F9F9F
		,"CLEAR",	 typ_switch,	 1,	 GLE_FILL_CLEAR
		,"COOL_COPPER",	 typ_switch,	 1,	 0X01D98719
		,"COPPER",	 typ_switch,	 1,	 0X01B87333
		,"CORAL",	 typ_switch,	 1,	 0X01FF7F00
		,"CORN_FLOWER_BLUE",	 typ_switch,	 1,	 0X0142426F
		,"CYAN",	 typ_switch,	 1,	 0X0100FFFF
		,"DARK_BROWN",	 typ_switch,	 1,	 0X015C4033
		,"DARK_GREEN",	 typ_switch,	 1,	 0X012F4F2F
		,"DARK_GREEN_COPPER",	 typ_switch,	 1,	 0X014A766E
		,"DARK_OLIVE_GREEN",	 typ_switch,	 1,	 0X014F4F2F
		,"DARK_ORCHID",	 typ_switch,	 1,	 0X019932CD
		,"DARK_PURPLE",	 typ_switch,	 1,	 0X01871F78
		,"DARK_SLATE_BLUE",	 typ_switch,	 1,	 0X016B238E
		,"DARK_SLATE_GREY",	 typ_switch,	 1,	 0X012F4F4F
		,"DARK_TAN",	 typ_switch,	 1,	 0X0197694F
		,"DARK_TURQUOISE",	 typ_switch,	 1,	 0X017093DB
		,"DARK_WOOD",	 typ_switch,	 1,	 0X01855E42
		,"DIM_GREY",	 typ_switch,	 1,	 0X01545454
		,"DUSTY_ROSE",	 typ_switch,	 1,	 0X01856363
		,"FELDSPAR",	 typ_switch,	 1,	 0X01D19275
		,"FIREBRICK",	 typ_switch,	 1,	 0X018E2323
		,"FOREST_GREEN",	 typ_switch,	 1,	 0X01228B22
		,"FOREST_GREEN_WEB",	 typ_switch,	 1,	 0X01238E23
		,"FUCHSIA",	 typ_switch,	 1,	 0X01FF00FF
		,"GOLD",	 typ_switch,	 1,	 0X01CD7F32
		,"GOLDENROD",	 typ_switch,	 1,	 0X01DBDB70
		,"GREEN",	 typ_switch,	 1,	 0X0100FF00
		,"GREEN_COPPER",	 typ_switch,	 1,	 0X01527F76
		,"GREEN_YELLOW",	 typ_switch,	 1,	 0X0193DB70
		,"GREY",	 typ_switch,	 1,	 0X017F7F7F
		,"GREY1",	 typ_switch,	 1,	 0X01FDFDFD
		,"GREY10",	 typ_switch,	 1,	 0X01C8C8C8
		,"GREY20",	 typ_switch,	 1,	 0X01AFAFAF
		,"GREY30",	 typ_switch,	 1,	 0X01969696
		,"GREY40",	 typ_switch,	 1,	 0X017D7D7D
		,"GREY5",	 typ_switch,	 1,	 0X01F0F0F0
		,"GREY50",	 typ_switch,	 1,	 0X01646464
		,"GREY60",	 typ_switch,	 1,	 0X014B4B4B
		,"GREY70",	 typ_switch,	 1,	 0X01323232
		,"GREY80",	 typ_switch,	 1,	 0X01191919
		,"GREY90",	 typ_switch,	 1,	 0X01060606
		,"GREY_WEB",	 typ_switch,	 1,	 0X01C0C0C0
		,"DARK_SLATE_GRAY",      typ_switch,     1,      0X012F4F4F
		,"DIM_GRAY",     typ_switch,     1,      0X01545454
		,"GRAY",         typ_switch,     1,      0X017F7F7F
		,"GRAY1",        typ_switch,     1,      0X01FDFDFD
		,"GRAY10",       typ_switch,     1,      0X01C8C8C8
		,"GRAY20",       typ_switch,     1,      0X01AFAFAF
		,"GRAY30",       typ_switch,     1,      0X01969696
		,"GRAY40",       typ_switch,     1,      0X017D7D7D
		,"GRAY5",        typ_switch,     1,      0X01F0F0F0
		,"GRAY50",       typ_switch,     1,      0X01646464
		,"GRAY60",       typ_switch,     1,      0X014B4B4B
		,"GRAY70",       typ_switch,     1,      0X01323232
		,"GRAY80",       typ_switch,     1,      0X01191919
		,"GRAY90",       typ_switch,     1,      0X01060606
		,"GRAY_WEB",     typ_switch,     1,      0X01C0C0C0
		,"LIGHT_GRAY",   typ_switch,     1,      0X01A8A8A8
		,"VERY_LIGHT_GRAY",      typ_switch,     1,      0X01CDCDCD
		,"HUNTER_GREEN",	 typ_switch,	 1,	 0X01215E21
		,"INDIAN_RED",	 typ_switch,	 1,	 0X014E2F2F
		,"KHAKI",	 typ_switch,	 1,	 0X019F9F5F
		,"LAWN_GREEN",	 typ_switch,	 1,	 0X017CFC00
		,"LIGHT_BLUE",	 typ_switch,	 1,	 0X01C0D9D9
		,"LIGHT_GREY",	 typ_switch,	 1,	 0X01A8A8A8
		,"LIGHT_STEEL_BLUE",	 typ_switch,	 1,	 0X018F8FBD
		,"LIGHT_WOOD",	 typ_switch,	 1,	 0X01E9C2A6
		,"LIME",	 typ_switch,	 1,	 0X0100FF01
		,"LIME_GREEN",	 typ_switch,	 1,	 0X0132CD32
		,"MAGENTA",	 typ_switch,	 1,	 0X01FF00FF
		,"MANDARIAN_ORANGE",	 typ_switch,	 1,	 0X01E47833
		,"MAROON",	 typ_switch,	 1,	 0X01800000
		,"MAROON_WEB",	 typ_switch,	 1,	 0X018E236B
		,"MEDIUM_AQUAMARINE",	 typ_switch,	 1,	 0X0132CD99
		,"MEDIUM_BLUE",	 typ_switch,	 1,	 0X013232CD
		,"MEDIUM_FOREST_GREEN",	 typ_switch,	 1,	 0X016B8E23
		,"MEDIUM_GOLDENROD",	 typ_switch,	 1,	 0X01EAEAAE
		,"MEDIUM_ORCHID",	 typ_switch,	 1,	 0X019370DB
		,"MEDIUM_SEA_GREEN",	 typ_switch,	 1,	 0X01426F42
		,"MEDIUM_SLATE_BLUE",	 typ_switch,	 1,	 0X017F00FF
		,"MEDIUM_SPRING_GREEN",	 typ_switch,	 1,	 0X017FFF00
		,"MEDIUM_TURQUOISE",	 typ_switch,	 1,	 0X0170DBDB
		,"MEDIUM_VIOLET_RED",	 typ_switch,	 1,	 0X01DB7093
		,"MEDIUM_WOOD",	 typ_switch,	 1,	 0X01A68064
		,"MIDNIGHT_BLUE",	 typ_switch,	 1,	 0X012F2F4F
		,"NAVY",	 typ_switch,	 1,	 0X01000080
		,"NAVY_BLUE",	 typ_switch,	 1,	 0X0123238E
		,"NEON_BLUE",	 typ_switch,	 1,	 0X014D4DFF
		,"NEON_PINK",	 typ_switch,	 1,	 0X01FF6EC7
		,"NEW_MIDNIGHT_BLUE",	 typ_switch,	 1,	 0X0100009C
		,"NEW_TAN",	 typ_switch,	 1,	 0X01EBC79E
		,"NONE",	 typ_switch,	 1,	 GLE_FILL_CLEAR
		,"OLD_GOLD",	 typ_switch,	 1,	 0X01CFB53B
		,"OLIVE",	 typ_switch,	 1,	 0X01808000
		,"ORANGE",	 typ_switch,	 1,	 0X01FF7F10
		,"ORANGE_RED",	 typ_switch,	 1,	 0X01FF2400
		,"ORANGE_WEB",	 typ_switch,	 1,	 0X01FF7F00
		,"ORCHID",	 typ_switch,	 1,	 0X01DB70DB
		,"PALE_GREEN",	 typ_switch,	 1,	 0X018FBC8F
		,"PINK",	 typ_switch,	 1,	 0X01FFC0CB
		,"PINK_WEB",	 typ_switch,	 1,	 0X01BC8F8F
		,"PLUM",	 typ_switch,	 1,	 0X01EAADEA
		,"PURPLE",	 typ_switch,	 1,	 0X01800080
		,"QUARTZ",	 typ_switch,	 1,	 0X01D9D9F3
		,"RED",	 typ_switch,	 1,	 0X01FF0000
		,"RICH_BLUE",	 typ_switch,	 1,	 0X015959AB
		,"SALMON",	 typ_switch,	 1,	 0X016F4242
		,"SCARLET",	 typ_switch,	 1,	 0X018C1717
		,"SEA_GREEN",	 typ_switch,	 1,	 0X01238E68
		,"SEMI_SWEET_CHOCOLATE",	 typ_switch,	 1,	 0X016B4226
		,"SIENNA",	 typ_switch,	 1,	 0X018E6B23
		,"SILVER",	 typ_switch,	 1,	 0X01C0C0C0
		,"SILVER_WEB",	 typ_switch,	 1,	 0X01E6E8FA
		,"SKY_BLUE",	 typ_switch,	 1,	 0X013299CC
		,"SLATE_BLUE",	 typ_switch,	 1,	 0X01007FFF
		,"SPICY_PINK",	 typ_switch,	 1,	 0X01FF1CAE
		,"SPRING_GREEN",	 typ_switch,	 1,	 0X0100FF7F
		,"STEEL_BLUE",	 typ_switch,	 1,	 0X01236B8E
		,"SUMMER_SKY",	 typ_switch,	 1,	 0X0138B0DE
		,"TAN_COLOR",	 typ_switch,	 1,	  0X01008080
		,"TEAL",	 typ_switch,	 1,	 0X01008080
		,"THISTLE",	 typ_switch,	 1,	 0X01D8BFD8
		,"TURQUOISE",	 typ_switch,	 1,	 0X01ADEAEA
		,"VERY_DARK_BROWN",	 typ_switch,	 1,	 0X015C4033
		,"VERY_LIGHT_GREY",	 typ_switch,	 1,	 0X01CDCDCD
		,"VIOLET",	 typ_switch,	 1,	 0X01EE82EE
		,"VIOLET_RED",	 typ_switch,	 1,	 0X01CC3299
		,"VIOLET_WEB",	 typ_switch,	 1,	 0X014F2F4F
		,"WHEAT",	 typ_switch,	 1,	 0X01D8D8BF
		,"WHITE",	 typ_switch,	 1,	 0X01FFFFFF
		,"YELLOW",	 typ_switch,	 1,	 0X01FFFF00
		,"YELLOW_GREEN",	 typ_switch,	 1,	 0X0199CC32
		,"GRID", 	typ_switch, 	1, 0X02002020
		,"RED_GRID", 	typ_switch, 	1, 0X03002020
		,"GREEN_GRID", 	typ_switch, 	1, 0X04002020
		,"BLUE_GRID", 	typ_switch, 	1, 0X05002020
		,"YELLOW_GRID", typ_switch, 	1, 0X06002020
		,"GRID1", 	typ_switch, 	1, 0X02040f0f
		,"GRID2", 	typ_switch, 	1, 0X02001010
		,"GRID3", 	typ_switch, 	1, 0X02052020
		,"GRID4", 	typ_switch, 	1, 0X02104040
		,"GRID5", 	typ_switch, 	1, 0X02206060
		,"SHADE", 	typ_switch, 	1, 0X02000020
		,"SHADE1", 	typ_switch, 	1, 0X0204000C
		,"SHADE2", 	typ_switch, 	1, 0X02000010
		,"SHADE3", 	typ_switch, 	1, 0X02050020
		,"SHADE4", 	typ_switch, 	1, 0X02100040
		,"SHADE5", 	typ_switch, 	1, 0X02200060
		,"RSHADE", 	typ_switch, 	1, 0X02002000
		,"RSHADE1", 	typ_switch, 	1, 0X02040C00
		,"RSHADE2", 	typ_switch, 	1, 0X02001000
		,"RSHADE3", 	typ_switch, 	1, 0X02052000
		,"RSHADE4", 	typ_switch, 	1, 0X02104000
		,"RSHADE5", 	typ_switch, 	1, 0X02206000
		,"END", 	typ_end, 	1, 1 };

struct op_key op_marker[] = {
		"DOT", 	typ_switch, 	1, 1
		,"CROSS", 	typ_switch, 	1, 2
		,"FCIRCLE", 	typ_switch, 	1, 3
		,"FSQUARE", 	typ_switch, 	1, 4
		,"FTRIANGLE", 	typ_switch, 	1, 5
		,"FDIAMOND", 	typ_switch, 	1, 6
		,"CIRCLE", 	typ_switch, 	1, 7
		,"SQUARE", 	typ_switch, 	1, 8
		,"TRIANGLE", 	typ_switch, 	1, 9
		,"DIAMOND", 	typ_switch, 	1, 10
		,"PLUS", 	typ_switch, 	1, 11
		,"CLUB", 	typ_switch, 	1, 12
		,"HEART", 	typ_switch, 	1, 13
		,"DIAMOND", 	typ_switch, 	1, 14
		,"SPADE", 	typ_switch, 	1, 15
		,"STAR", 	typ_switch, 	1, 16
		,"SNAKE", 	typ_switch, 	1, 17
		,"DAG", 	typ_switch, 	1, 18
		,"DDAG", 	typ_switch, 	1, 19
		,"ASTERIX", 	typ_switch, 	1, 20
		,"ASTERISK", 	typ_switch, 	1, 20
		,"OPLUS", 	typ_switch, 	1, 21
		,"OMINUS", 	typ_switch, 	1, 22
		,"OTIMES", 	typ_switch, 	1, 23
		,"ODOT", 	typ_switch, 	1, 24
		,"TRIANGLEZ", 	typ_switch, 	1, 25
		,"DIAMONDZ", 	typ_switch, 	1, 26
		,"WCIRCLE", 	typ_switch, 	1, 27
		,"WTRIANGLE", 	typ_switch, 	1, 28
		,"WSQUARE", 	typ_switch, 	1, 29
		,"WDIAMOND", 	typ_switch, 	1, 30
		,"END", 	typ_end, 	1, 1 };

struct op_key op_begin_path[] = {
		 "STROKE", 	typ_switch, 	1, 1
		,"FILL", 	typ_fill, 	2, 0
		,"CLIP", 	typ_switch, 	3, 1
		,"END", 	typ_end, 	0, 0 };

struct op_key op_begin_box[] = {
		 "ADD", 	typ_val, 	1, 0
		,"FILL", 	typ_fill, 	2, 0
		,"NOSTROKE", 	typ_switch, 	3, 1
		,"NOBORDER", 	typ_switch, 	3, 1
		,"NOBOX", 	typ_switch, 	3, 1
		,"ROUND",	typ_val, 	4, 0
		,"NAME", 	typ_str, 	5, 0
		,"END", 	typ_end, 	0, 0 };

struct op_key op_begin_scale[] = {
		 "TRANSLATE", 	typ_val2, 	1, 0
		,"TRAN", 	typ_val2, 	1, 0
		,"SCALE", 	typ_val2, 	3, 0
		,"ROTATE", 	typ_val, 	5, 0
		,"ROT", 	typ_val, 	5, 0
		,"END", 	typ_end, 	0, 0 };

struct op_key op_arc[] = {
		 "ARROW", 	typ_arrow, 	1, 1
		,"CENTER", 	typ_val2, 	2, 0
		,"CENTRE", 	typ_val2, 	2, 0
		,"CENT", 	typ_val2, 	2, 0
		,"END", 	typ_end, 	0, 0 };

struct op_key op_arrow[] = {
		 "START", 	typ_switch, 	1, 1
		,"END", 	typ_switch, 	1, 2
		,"BOTH", 	typ_switch, 	1, 3
		,"END", 	typ_end, 	0, 0 };

struct op_key op_joinname[] = {
		 "->",	 	typ_switch, 	1, 1
		,"<-",	 	typ_switch, 	1, 2
		,"<->", 	typ_switch, 	1, 3
		,"-", 		typ_switch, 	1, 4
		,"END", 	typ_end, 	0, 0 };

struct op_key op_line[] = {
		 "ARROW", 	typ_arrow, 	1, 1
		,"CURVE",	typ_val4,	2, 0
		,"END", 	typ_end, 	0, 0 };

struct op_key op_curve[] = {
		 "CURVE",	typ_val4,	1, 0
		,"END", 	typ_end, 	0, 0 };

struct op_key op_size[] = {
		 "BOX", 	typ_switch, 	1, 1
		,"END", 	typ_end, 	0, 0 };

struct op_key op_join[] = {
		 "MITRE", 	typ_switch, 	1, 0
		,"ROUND", 	typ_switch, 	1, 1
		,"BEVEL", 	typ_switch, 	1, 2
		,"END", 	typ_end, 	0, 0 };

struct op_key op_cap[] = {
		 "BUTT", 	typ_switch, 	1, 0
		,"ROUND", 	typ_switch, 	1, 1
		,"SQUARE", 	typ_switch, 	1, 2
		,"END", 	typ_end, 	0, 0 };

struct op_key op_bitmap[] = {
		 "COLORS",      typ_val,        1, 0
		,"COMPRESS",	typ_str, 	2, 0
		,"DPI",         typ_val,        3, 0
		,"GRAYSCALE",   typ_switch,     4, 1
		,"RESIZE",      typ_switch,     5, 1
		,"TYPE",	typ_str,        6, 0
		,"END", 	typ_end,	0, 0 };

struct op_key op_bitmap_info[] = {
		 "TYPE",	typ_str,        1, 0
		,"END", 	typ_end,	0, 0 };

struct op_key op_tex[] = {
		 "ADD", 	typ_val, 	1, 0
		,"NAME",	typ_str,        2, 0
		,"END", 	typ_end,	0, 0 };

struct op_key op_draw[] = {
		 "NAME",	typ_str,        2, 0
		,"END", 	typ_end,	0, 0 };

struct op_key op_orientation[] = {
		 "PORTRAIT", 	typ_switch, 	1, 0
		,"LANDSCAPE", 	typ_switch, 	1, 1
		,"END", 	typ_end, 	0, 0 };

struct op_key op_colormap[] = {
		 "COLOR", 	typ_switch, 	1, 1
		,"END", 	typ_end, 	0, 0 };
