#ifndef G_INPUT_H
#define G_INPUT_H

#ifdef __cplusplus
extern "C" {
#endif

#ifdef WITH_GTK
#include <gtk/gtk.h>
#endif

#define DIRECTINPUT_VERSION 0x0500  // for joystick support
#ifndef __PORT__
#include <dinput.h>
#endif
//#include <mmsystem.h>

struct K_Def {
	unsigned int Start, Mode;
	unsigned int A, B, C;
	unsigned int X, Y, Z;
	unsigned int Up, Down, Left, Right;
	};

extern struct K_Def Keys_Def[8];
extern unsigned char Kaillera_Keys[16];

int String_Size(char *Chaine);
unsigned int Get_Key(void);
int Check_Key_Pressed(int key);

#ifdef __PORT__
#ifdef WITH_GTK
int Setting_Keys(GtkWidget* control_window, int Player, int TypeP);
#endif
#else
int Setting_Keys(HWND hset, int Player, int Type);
#endif
int Init_Input(HINSTANCE hInst, HWND hWnd);
void End_Input(void);
void Update_Input(void);
void Update_Controllers(void);
void Scan_Player_Net(int Player);
void Update_Controllers_Net(int num_player);
#ifdef __PORT__
void input_set_joy_down(int button, int on);
void input_set_joy_motion(int axis, int value);
#endif

#ifdef __cplusplus
}
#endif


#endif
