/*
 * Decompiled with CFR 0.152.
 */
package javax.units;

import javax.units.Converter;

public final class MultiplyConverter
extends Converter {
    private final double _factor;

    public MultiplyConverter(double factor) {
        this._factor = factor;
    }

    public Converter inverse() {
        return new MultiplyConverter(1.0 / this._factor);
    }

    public double convert(double amount) {
        return this._factor * amount;
    }

    public double derivative(double x) {
        return this._factor;
    }

    public boolean isLinear() {
        return true;
    }

    public Converter concatenate(Converter converter) {
        if (converter instanceof MultiplyConverter) {
            double factor = this._factor * ((MultiplyConverter)converter)._factor;
            return new MultiplyConverter(factor);
        }
        return super.concatenate(converter);
    }
}

