/*
 * Decompiled with CFR 0.152.
 */
package javax.units;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.HashMap;
import javax.units.AddConverter;
import javax.units.Converter;
import javax.units.MultiplyConverter;
import javax.units.ProductUnit;
import javax.units.TransformedUnit;
import javax.units.Unit;

public abstract class UnitFormat
extends Format {
    private static final HashMap LABEL_UNIT = new HashMap();
    private static final HashMap UNIT_LABEL = new HashMap();
    private static final HashMap ALIAS_UNIT = new HashMap();
    private static final int DEFAULT = 0;
    private static final int SYSTEM_NAME = 1;
    private static final int NAME = 2;
    private static final int EXPONENT = 3;
    private static final int MARKUP = 4;
    private static final int ESCAPE = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Unit label(Unit unit, String label) {
        if (label != null) {
            if (Unit.searchSymbol(label) != null) {
                throw new IllegalArgumentException("Label: " + label + " is a known symbol");
            }
            Unit u = (Unit)LABEL_UNIT.get(label);
            if (u != null && u != unit) {
                throw new IllegalArgumentException("Label: " + label + " is attached to a different unit" + " (must be detached first)");
            }
        }
        Class clazz = UnitFormat.class;
        synchronized (clazz) {
            String prevLabel = (String)UNIT_LABEL.remove(unit);
            LABEL_UNIT.remove(prevLabel);
            Unit prevUnit = (Unit)LABEL_UNIT.remove(label);
            UNIT_LABEL.remove(prevUnit);
            LABEL_UNIT.put(label, unit);
            UNIT_LABEL.put(unit, label);
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Unit alias(Unit unit, String alias) {
        Class clazz = UnitFormat.class;
        synchronized (clazz) {
            ALIAS_UNIT.put(alias, unit);
        }
        return unit;
    }

    public static final UnitFormat getInstance() {
        return UnitFormat.getStandardInstance();
    }

    public static final UnitFormat getStandardInstance() {
        return Standard.INSTANCE;
    }

    public static final UnitFormat getAsciiInstance() {
        return Ascii.INSTANCE;
    }

    public static final UnitFormat getHtmlInstance() {
        return Html.INSTANCE;
    }

    public static boolean isUnitIdentifierPart(char ch) {
        return ch > '\"' && (ch <= '%' || ch > '?') && ch != '^' && ch != '\u00b9' && ch != '\u00b2' && ch != '\u00b3' && ch != '\u00b7';
    }

    public abstract StringBuffer format(Object var1, StringBuffer var2, FieldPosition var3);

    public final Object parseObject(String source, ParsePosition pos) {
        try {
            int start = pos.getIndex();
            Unit unit = this.parseUnit(source.substring(start));
            pos.setIndex(source.length());
            return unit;
        }
        catch (ParseException e) {
            pos.setErrorIndex(e.getErrorOffset());
            return null;
        }
    }

    public Unit parseUnit(CharSequence source) throws ParseException {
        int state = 0;
        CharSequence name = null;
        CharSequence power = null;
        CharSequence root = null;
        boolean isInverse = false;
        boolean isSlash = false;
        boolean requestFlush = false;
        int start = 0;
        int bracketLevel = 0;
        Unit result = Unit.ONE;
        for (int i = 0; i <= source.length(); ++i) {
            char c = i < source.length() ? (char)source.charAt(i) : (char)' ';
            switch (state) {
                case 0: {
                    if (c == '[') {
                        start = i;
                        state = 1;
                        requestFlush = true;
                        break;
                    }
                    if (UnitFormat.isUnitIdentifierPart(c)) {
                        start = i;
                        state = 2;
                        requestFlush = true;
                        break;
                    }
                    if (UnitFormat.isExponent(c)) {
                        start = i;
                        state = 3;
                        break;
                    }
                    if (c == '<') {
                        state = 4;
                        break;
                    }
                    if (c != 38) break;
                    state = 5;
                    break;
                }
                case 1: {
                    if (c == '[') {
                        ++bracketLevel;
                        break;
                    }
                    if (c == ']' && bracketLevel == 0) {
                        name = source.subSequence(start, i + 1);
                        state = 0;
                        break;
                    }
                    if (c != 93) break;
                    --bracketLevel;
                    break;
                }
                case 2: {
                    if (UnitFormat.isUnitIdentifierPart(c)) break;
                    name = source.subSequence(start, i);
                    if (UnitFormat.isExponent(c)) {
                        start = i;
                        state = 3;
                        break;
                    }
                    if (c == '<') {
                        state = 4;
                        break;
                    }
                    if (c == '&') {
                        state = 5;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 3: {
                    if (UnitFormat.isExponent(c)) break;
                    if (power == null) {
                        power = source.subSequence(start, i);
                    } else {
                        isSlash = false;
                        root = source.subSequence(start, i);
                    }
                    if (c == '[') {
                        start = i;
                        state = 1;
                        requestFlush = true;
                        break;
                    }
                    if (UnitFormat.isUnitIdentifierPart(c)) {
                        start = i;
                        state = 2;
                        requestFlush = true;
                        break;
                    }
                    if (c == '<') {
                        state = 4;
                        break;
                    }
                    if (c == '&') {
                        state = 5;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 4: {
                    if (c != 62) break;
                    state = 0;
                    break;
                }
                case 5: {
                    if (c != 59) break;
                    state = 0;
                    break;
                }
                default: {
                    throw new InternalError("state " + state + " unknown");
                }
            }
            if (c == '/' && state == 0) {
                isSlash = true;
            }
            if (i == source.length()) {
                if (state == 2) {
                    name = source.subSequence(start, source.length());
                } else if (state == 3) {
                    if (power == null) {
                        power = source.subSequence(start, source.length());
                    } else {
                        root = source.subSequence(start, source.length());
                    }
                }
                requestFlush = true;
            }
            if (!requestFlush) continue;
            if (name != null) {
                Unit unit = this.unitFor(name);
                if (unit != null) {
                    int powValue = UnitFormat.parseExponent(power);
                    int rootValue = UnitFormat.parseExponent(root);
                    powValue = isInverse ? -powValue : powValue;
                    result = result.multiply(unit.pow(powValue).root(rootValue));
                } else {
                    throw new ParseException("Label: " + name + " not recognized", i);
                }
            }
            isInverse = isSlash ? !isInverse : isInverse;
            requestFlush = false;
            name = null;
            power = null;
            root = null;
            isSlash = false;
        }
        return result;
    }

    private static boolean isExponent(char c) {
        return Character.isDigit(c) || c == '-' || c == '\u00b9' || c == '\u00b2' || c == '\u00b3';
    }

    private static int parseExponent(CharSequence chars) {
        if (chars != null) {
            boolean isNegative = false;
            int exp = 0;
            for (int i = 0; i < chars.length(); ++i) {
                int c = chars.charAt(i);
                if (c == 45) {
                    isNegative = true;
                    continue;
                }
                if (c == 43) continue;
                if (c == 185) {
                    c = 49;
                } else if (c == 178) {
                    c = 50;
                } else if (c == 179) {
                    c = 51;
                }
                exp = exp * 10 + (c - 48);
            }
            return isNegative ? -exp : exp;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String labelFor(Unit unit) {
        Class clazz = UnitFormat.class;
        synchronized (clazz) {
            String label = (String)UNIT_LABEL.get(unit);
            if (label != null) {
                return label;
            }
        }
        if (unit._symbol != null) {
            return unit._symbol;
        }
        if (unit instanceof TransformedUnit) {
            TransformedUnit tfmUnit = (TransformedUnit)unit;
            Unit systemUnit = tfmUnit.getSystemUnit();
            Converter cvtr = tfmUnit.getConverterTo(systemUnit);
            if (cvtr instanceof AddConverter) {
                return "[" + systemUnit + "+" + ((AddConverter)cvtr).getOffset() + "]";
            }
            if (cvtr instanceof MultiplyConverter) {
                return "[" + systemUnit + "*" + ((MultiplyConverter)cvtr).derivative(0.0) + "]";
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Unit unitFor(CharSequence label) {
        Class clazz = UnitFormat.class;
        synchronized (clazz) {
            Unit unit = (Unit)LABEL_UNIT.get(label);
            if (unit != null) {
                return unit;
            }
            unit = (Unit)ALIAS_UNIT.get(label);
            if (unit != null) {
                return unit;
            }
        }
        Unit unit = Unit.searchSymbol(label);
        if (unit != null) {
            return unit;
        }
        return null;
    }

    private static void append(StringBuffer str, String symbol, int pow, int root) {
        str.append(symbol);
        if (pow != 1 || root != 1) {
            if (pow == 2 && root == 1) {
                str.append('\u00b2');
            } else if (pow == 3 && root == 1) {
                str.append('\u00b3');
            } else {
                str.append("^" + String.valueOf(pow));
                if (root != 1) {
                    str.append(':' + String.valueOf(root));
                }
            }
        }
    }

    static {
        try {
            Class.forName("javax.units.SI");
            Class.forName("javax.units.NonSI");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final class Ascii
    extends UnitFormat {
        private static final Ascii INSTANCE = new Ascii();

        private Ascii() {
        }

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            String label;
            if (obj instanceof Unit && (label = this.labelFor((Unit)obj)) != null) {
                toAppendTo.append(label);
                return toAppendTo;
            }
            if (obj instanceof ProductUnit) {
                ProductUnit unit = (ProductUnit)obj;
                int startIndex = toAppendTo.length();
                for (int i = 0; i < unit.size(); ++i) {
                    if (startIndex != toAppendTo.length()) {
                        toAppendTo.append(" ");
                    }
                    String label2 = this.labelFor(unit.get(i).getUnit());
                    int pow = unit.get(i).getPow();
                    int root = unit.get(i).getRoot();
                    toAppendTo.append(label2);
                    if (pow == 1 && root == 1) continue;
                    toAppendTo.append("^" + String.valueOf(pow));
                    if (root == 1) continue;
                    toAppendTo.append(":" + String.valueOf(root));
                }
            } else {
                throw new IllegalArgumentException("Cannot format given Object as a Unit");
            }
            return toAppendTo;
        }
    }

    private static final class Html
    extends UnitFormat {
        private static final Html INSTANCE = new Html();

        private Html() {
        }

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            String label;
            if (obj instanceof Unit && (label = this.labelFor((Unit)obj)) != null) {
                toAppendTo.append(label);
                return toAppendTo;
            }
            if (obj instanceof ProductUnit) {
                ProductUnit unit = (ProductUnit)obj;
                int startIndex = toAppendTo.length();
                for (int i = 0; i < unit.size(); ++i) {
                    if (startIndex != toAppendTo.length()) {
                        toAppendTo.append("&#183;");
                    }
                    String label2 = this.labelFor(unit.get(i).getUnit());
                    int pow = unit.get(i).getPow();
                    int root = unit.get(i).getRoot();
                    toAppendTo.append(label2);
                    if (pow == 1 && root == 1) continue;
                    toAppendTo.append("<sup>" + String.valueOf(pow));
                    if (root != 1) {
                        toAppendTo.append(":" + String.valueOf(root));
                    }
                    toAppendTo.append("</sup>");
                }
            } else {
                throw new IllegalArgumentException("Cannot format given Object as a Unit");
            }
            return toAppendTo;
        }
    }

    private static final class Standard
    extends UnitFormat {
        private static final Standard INSTANCE = new Standard();

        private Standard() {
        }

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            String label;
            if (obj instanceof Unit && (label = this.labelFor((Unit)obj)) != null) {
                toAppendTo.append(label);
                return toAppendTo;
            }
            if (obj instanceof ProductUnit) {
                int root;
                int pow;
                String label2;
                int i;
                ProductUnit unit = (ProductUnit)obj;
                int invNbr = 0;
                int startIndex = toAppendTo.length();
                for (i = 0; i < unit.size(); ++i) {
                    label2 = this.labelFor(unit.get(i).getUnit());
                    pow = unit.get(i).getPow();
                    root = unit.get(i).getRoot();
                    if (pow >= 0) {
                        if (startIndex != toAppendTo.length()) {
                            toAppendTo.append('\u00b7');
                        }
                        UnitFormat.append(toAppendTo, label2, pow, root);
                        continue;
                    }
                    ++invNbr;
                }
                if (invNbr != 0) {
                    if (startIndex == toAppendTo.length()) {
                        toAppendTo.append('1');
                    }
                    toAppendTo.append('/');
                    if (invNbr > 1) {
                        toAppendTo.append('(');
                    }
                    startIndex = toAppendTo.length();
                    for (i = 0; i < unit.size(); ++i) {
                        label2 = this.labelFor(unit.get(i).getUnit());
                        pow = unit.get(i).getPow();
                        root = unit.get(i).getRoot();
                        if (pow >= 0) continue;
                        if (startIndex != toAppendTo.length()) {
                            toAppendTo.append('\u00b7');
                        }
                        UnitFormat.append(toAppendTo, label2, -pow, root);
                    }
                    if (invNbr > 1) {
                        toAppendTo.append(')');
                    }
                }
            } else {
                throw new IllegalArgumentException("Cannot format given Object as a Unit");
            }
            return toAppendTo;
        }
    }
}

