/*$************************************************************************************************
 **
 ** $Id: DomainObject.java 1122 2007-11-24 18:49:16Z desruisseaux $
 **
 ** $URL: https://geoapi.svn.sourceforge.net/svnroot/geoapi/tags/2.1.0/geoapi/src/main/java/org/opengis/coverage/DomainObject.java $
 **
 ** Copyright (C) 2005 Open GIS Consortium, Inc.
 ** All Rights Reserved. http://www.opengis.org/legal/
 **
 *************************************************************************************************/
package org.opengis.coverage;

import java.util.Set;
import org.opengis.geometry.Geometry;
import org.opengis.temporal.TemporalGeometricPrimitive;
import org.opengis.annotation.UML;

import static org.opengis.annotation.Obligation.*;
import static org.opengis.annotation.Specification.*;


/**
 * Represents an element of the domain of the {@linkplain Coverage coverage}. It is an aggregation
 * of objects that may include any combination of {@linkplain Geometry geometry}, or spatial or
 * temporal objects such as {@linkplain org.opengis.coverage.grid.GridPoint grid point}.
 *
 * @author ISO/DIS 19123
 * @author Stephane Fellah
 * @author Martin Desruisseaux
 *
 * @see Coverage#getDomainElements
 */
@UML(identifier="CV_DomainObject", specification=ISO_19123)
public interface DomainObject {
    /**
     * Returns the set of geometries of which this domain is composed.
     * The set may be empty.
     */
    @UML(identifier="spatialElement", obligation=OPTIONAL, specification=ISO_19123)
    Set<Geometry> getSpatialElements();

    /**
     * Returns the set of geometric primitives of which this domain is composed.
     * The set may be empty.
     */
    @UML(identifier="temporalElement", obligation=OPTIONAL, specification=ISO_19123)
    Set<TemporalGeometricPrimitive> getTemporalElements();
}
