/*$************************************************************************************************
 **
 ** $Id: LinePlacement.java 982 2007-03-27 10:54:51Z desruisseaux $
 **
 ** $URL: https://geoapi.svn.sourceforge.net/svnroot/geoapi/tags/2.1.0/geoapi/src/main/java/org/opengis/sld/LinePlacement.java $
 **
 ** Copyright (C) 2005 Open GIS Consortium, Inc.
 ** All Rights Reserved. http://www.opengis.org/legal/
 **
 *************************************************************************************************/
package org.opengis.sld;

import org.opengis.filter.expression.Expression;
import org.opengis.annotation.XmlElement;


/**
 * Helds by a {@link TextSymbol} to indicate that text should be drawn at some distance
 * from a line.
 *
 * @version <A HREF="http://portal.opengeospatial.org/files/?artifact_id=1188">Implementation specification 1.0</A>
 * @author Chris Dillard (SYS Technologies)
 * @since GeoAPI 2.0
 */
@XmlElement("PointPlacement")
public interface LinePlacement extends TextPlacement {
    /**
     * Returns the expression that is used to compute how far from the lines
     * the text will be drawn.  The distance must evaluate to a non-negative
     * number.
     */
    @XmlElement("PerpendicularOffset")
    Expression getPerpendicularOffset();

    /**
     * Sets the expression that is used to compute how far from the lines
     * the text will be drawn.
     * See {@link #getPerpendicularOffset} for details.
     */
    @XmlElement("PerpendicularOffset")
    void setPerpendicularOffset(Expression e);
}
